/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import org.fluentlenium.adapter.util.SharedDriverHelper;
import org.fluentlenium.adapter.util.ShutdownHook;
import org.fluentlenium.core.FluentAdapter;
import org.fluentlenium.core.FluentPage;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

public abstract class FluentTest
extends FluentAdapter {
    private static WebDriver sharedDriver;
    private static boolean isSharedDriverPerClass;
    private Mode snapshotMode = Mode.NEVER_TAKE_SNAPSHOT;
    private String snapshotPath;
    @Rule
    public TestName name = new TestName();
    @Rule
    public TestRule watchman = new TestWatcher(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void starting(Description description) {
            super.starting(description);
            if (SharedDriverHelper.isSharedDriverOnce(description.getTestClass())) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (sharedDriver == null) {
                        FluentTest.this.initFluentFromDefaultDriver();
                        sharedDriver = FluentTest.this.getDriver();
                        FluentTest.this.killTheBrowserOnShutdown();
                    } else {
                        FluentTest.this.initFluentWithExistingDriver();
                    }
                }
            } else if (SharedDriverHelper.isSharedDriverPerClass(description.getTestClass())) {
                1 var2_3 = this;
                synchronized (var2_3) {
                    if (!isSharedDriverPerClass) {
                        FluentTest.this.initFluentFromDefaultDriver();
                        sharedDriver = FluentTest.this.getDriver();
                        isSharedDriverPerClass = true;
                    } else {
                        FluentTest.this.initFluentWithExistingDriver();
                    }
                }
            } else {
                FluentTest.this.initFluentFromDefaultDriver();
            }
            FluentTest.this.initTest();
            FluentTest.this.setDefaultConfig();
        }

        public void finished(Description description) {
            super.finished(description);
            if (SharedDriverHelper.isSharedDriverPerMethod(description.getTestClass()) || SharedDriverHelper.isDefaultSharedDriver(description.getTestClass())) {
                FluentTest.this.quit();
            } else if (SharedDriverHelper.isDeleteCookies(description.getTestClass()) && sharedDriver != null) {
                sharedDriver.manage().deleteAllCookies();
            }
        }

        public void failed(Throwable e, Description description) {
            if (FluentTest.this.snapshotMode == Mode.TAKE_SNAPSHOT_ON_FAIL) {
                FluentTest.this.takeScreenShot(FluentTest.this.snapshotPath + "/" + description.getTestClass().getSimpleName() + "_" + description.getMethodName() + ".png");
            }
        }
    };

    public void setSnapshotPath(String path) {
        this.snapshotPath = path;
    }

    public void setSnapshotMode(Mode mode) {
        this.snapshotMode = mode;
    }

    private void killTheBrowserOnShutdown() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHook("fluentlenium", this));
    }

    private void initFluentWithExistingDriver() {
        this.initFluent(sharedDriver).withDefaultUrl(this.getDefaultBaseUrl());
    }

    private void initFluentFromDefaultDriver() {
        this.initFluent(this.getDefaultDriver()).withDefaultUrl(this.getDefaultBaseUrl());
    }

    public WebDriver getDefaultDriver() {
        return new FirefoxDriver();
    }

    @AfterClass
    public static void afterClass() {
        if (isSharedDriverPerClass) {
            sharedDriver.quit();
            sharedDriver = null;
            isSharedDriverPerClass = false;
        }
    }

    @Beta
    public void setDefaultConfig() {
    }

    public static void assertAt(FluentPage fluent) {
        fluent.isAt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Mode {
        TAKE_SNAPSHOT_ON_FAIL,
        NEVER_TAKE_SNAPSHOT;

    }
}

