/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.FluentThread;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.wait.FluentWaitMatcher;
import org.fluentlenium.core.wait.WaitMessage;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.FluentWait;

public class FluentWaitPageMatcher {
    private List<Filter> filters = new ArrayList<Filter>();
    private FluentWait wait;
    private WebDriver webDriver;
    private FluentPage page;

    public FluentWaitPageMatcher(FluentWait wait, WebDriver driver) {
        this.wait = wait;
        this.webDriver = driver;
    }

    public FluentWaitPageMatcher(FluentWait wait, WebDriver driver, FluentPage page) {
        this.wait = wait;
        this.webDriver = driver;
        this.page = page;
    }

    public Fluent isLoaded() {
        if (!(this.webDriver instanceof JavascriptExecutor)) {
            throw new UnsupportedOperationException("Driver must support javascript execution to use this feature");
        }
        Predicate<WebDriver> isLoaded = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)webDriver;
                Object result = javascriptExecutor.executeScript("if (document.readyState) return document.readyState;", new Object[0]);
                if (result != null) {
                    return "complete".equals((String)result);
                }
                return false;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isLoaded, this.filters, WaitMessage.isPageLoaded(this.webDriver.getCurrentUrl()));
        return FluentThread.get();
    }

    public void isAt() {
        if (this.page == null) {
            throw new IllegalArgumentException("You should use a page argument when you call the untilPage method to specify the page you want to be. Example : await().untilPage(myPage).isAt();");
        }
        Predicate<WebDriver> isLoaded = new Predicate<WebDriver>(){

            public boolean apply(@Nullable WebDriver webDriver) {
                try {
                    FluentWaitPageMatcher.this.page.isAt();
                }
                catch (Error e) {
                    return false;
                }
                return true;
            }
        };
        FluentWaitMatcher.until(this.wait, (Predicate)isLoaded, this.filters, "");
    }
}

