/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.util.regex.Pattern;
import org.fluentlenium.core.filter.Filter;
import org.fluentlenium.core.filter.FilterType;
import org.fluentlenium.core.filter.matcher.ContainsMatcher;
import org.fluentlenium.core.filter.matcher.EndsWithMatcher;
import org.fluentlenium.core.filter.matcher.EqualMatcher;
import org.fluentlenium.core.filter.matcher.Matcher;
import org.fluentlenium.core.filter.matcher.NotContainsMatcher;
import org.fluentlenium.core.filter.matcher.NotEndsWithMatcher;
import org.fluentlenium.core.filter.matcher.NotStartsWithMatcher;
import org.fluentlenium.core.filter.matcher.StartsWithMatcher;
import org.fluentlenium.core.wait.FluentWaitMatcher;

public class FluentWaitBuilder {
    FluentWaitMatcher fluentLeniumWait;
    String attribute;

    public FluentWaitBuilder(FluentWaitMatcher fluentWaitBuilder, FilterType filterType) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = filterType.name();
    }

    public FluentWaitBuilder(FluentWaitMatcher fluentWaitBuilder, String attribute) {
        this.fluentLeniumWait = fluentWaitBuilder;
        this.attribute = attribute;
    }

    public FluentWaitMatcher equalTo(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EqualMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher contains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher contains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new ContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher startsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher startsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new StartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher endsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher endsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new EndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notContains(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notContains(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotContainsMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notStartsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notStartsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotStartsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notEndsWith(String equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }

    public FluentWaitMatcher notEndsWith(Pattern equal) {
        this.fluentLeniumWait.addFilter(new Filter(this.attribute, (Matcher)new NotEndsWithMatcher(equal)));
        return this.fluentLeniumWait;
    }
}

