/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.events.AnnotatedEventDriver;
import org.eclipse.jetty.websocket.common.message.MessageAppender;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final int BUFFER_SIZE = 65535;
    private static final int COMPACT_THRESHOLD = 5;
    private final AnnotatedEventDriver driver;
    private final ByteBuffer buf;
    private int size;
    private boolean finished;
    private boolean needsNotification;
    private int readPosition;

    public MessageInputStream(AnnotatedEventDriver driver) {
        this.driver = driver;
        this.buf = ByteBuffer.allocate(65535);
        BufferUtil.clearToFill((ByteBuffer)this.buf);
        this.size = 0;
        this.readPosition = this.buf.position();
        this.finished = false;
        this.needsNotification = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.driver.getPolicy().assertValidMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        ByteBuffer byteBuffer = this.buf;
        synchronized (byteBuffer) {
            BufferUtil.put((ByteBuffer)payload, (ByteBuffer)this.buf);
        }
        if (this.needsNotification) {
            this.needsNotification = true;
            this.driver.onInputStream(this);
        }
    }

    @Override
    public void close() throws IOException {
        this.finished = true;
        super.close();
    }

    @Override
    public void messageComplete() {
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        ByteBuffer byteBuffer = this.buf;
        synchronized (byteBuffer) {
            byte b = this.buf.get(this.readPosition);
            ++this.readPosition;
            if (this.readPosition <= this.buf.limit() - 5) {
                int curPos = this.buf.position();
                this.buf.compact();
                int offsetPos = this.buf.position() - curPos;
                this.readPosition += offsetPos;
            }
            return b;
        }
    }
}

