/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;

public class WebSocketRemoteEndpoint
implements RemoteEndpoint {
    private static final Logger LOG = Log.getLogger(WebSocketRemoteEndpoint.class);
    public final LogicalConnection connection;
    public final OutgoingFrames outgoing;

    public WebSocketRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoing) {
        if (connection == null) {
            throw new IllegalArgumentException("LogicalConnection cannot be null");
        }
        this.connection = connection;
        this.outgoing = outgoing;
    }

    private void blockingWrite(WebSocketFrame frame) throws IOException {
        Future<Void> fut = this.sendAsyncFrame(frame);
        try {
            fut.get();
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to write bytes", e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException("Failed to write bytes", e);
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.connection.getRemoteAddress();
    }

    private Future<Void> sendAsyncFrame(WebSocketFrame frame) {
        FutureWriteCallback future = new FutureWriteCallback();
        try {
            this.connection.getIOState().assertOutputOpen();
            this.outgoing.outgoingFrame((Frame)frame, (WriteCallback)future);
        }
        catch (IOException e) {
            future.writeFailed(e);
        }
        return future;
    }

    public void sendBytes(ByteBuffer data) throws IOException {
        this.connection.getIOState().assertOutputOpen();
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytes with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(data);
        this.blockingWrite(frame);
    }

    public Future<Void> sendBytesByFuture(ByteBuffer data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBytesByFuture with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(data);
        return this.sendAsyncFrame(frame);
    }

    public void sendPartialBytes(ByteBuffer fragment, boolean isLast) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPartialBytes({}, {})", new Object[]{BufferUtil.toDetailString((ByteBuffer)fragment), isLast});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(fragment).setFin(isLast);
        this.blockingWrite(frame);
    }

    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPartialString({}, {})", new Object[]{fragment, isLast});
        }
        WebSocketFrame frame = WebSocketFrame.text(fragment).setFin(isLast);
        this.blockingWrite(frame);
    }

    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        WebSocketFrame frame = WebSocketFrame.ping().setPayload(applicationData);
        this.blockingWrite(frame);
    }

    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        WebSocketFrame frame = WebSocketFrame.pong().setPayload(applicationData);
        this.blockingWrite(frame);
    }

    public void sendString(String text) throws IOException {
        WebSocketFrame frame = WebSocketFrame.text(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendString with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
        }
        this.blockingWrite(WebSocketFrame.text(text));
    }

    public Future<Void> sendStringByFuture(String text) {
        WebSocketFrame frame = WebSocketFrame.text(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendStringByFuture with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
        }
        return this.sendAsyncFrame(frame);
    }
}

