/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class MetaInfConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(MetaInfConfiguration.class);
    public static final String METAINF_TLDS = "org.eclipse.jetty.tlds";
    public static final String METAINF_FRAGMENTS = "org.eclipse.jetty.webFragments";
    public static final String METAINF_RESOURCES = "org.eclipse.jetty.resources";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        ArrayList<Resource> jars = new ArrayList<Resource>();
        jars.addAll(context.getMetaData().getContainerResources());
        jars.addAll(context.getMetaData().getWebInfJars());
        if (jars != null) {
            for (Resource r : jars) {
                Resource resourcesDir;
                URI uri = r.getURI();
                Resource fragXml = Resource.newResource((String)("jar:" + uri + "!/META-INF/web-fragment.xml"));
                if (fragXml.exists()) {
                    HashMap<Resource, Resource> fragments = (HashMap<Resource, Resource>)context.getAttribute(METAINF_FRAGMENTS);
                    if (fragments == null) {
                        fragments = new HashMap<Resource, Resource>();
                        context.setAttribute(METAINF_FRAGMENTS, fragments);
                    }
                    fragments.put(r, fragXml);
                }
                if (!(resourcesDir = Resource.newResource((String)("jar:" + uri + "!/META-INF/resources"))).exists()) continue;
                HashSet<Resource> dirs = (HashSet<Resource>)context.getAttribute(METAINF_RESOURCES);
                if (dirs == null) {
                    dirs = new HashSet<Resource>();
                    context.setAttribute(METAINF_RESOURCES, dirs);
                }
                dirs.add(resourcesDir);
            }
        }
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(METAINF_FRAGMENTS, null);
        context.setAttribute(METAINF_RESOURCES, null);
        context.setAttribute(METAINF_TLDS, null);
    }
}

