/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread.strategy;

import java.util.concurrent.Executor;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutionStrategy;

public class ProduceExecuteConsume
implements ExecutionStrategy {
    private static final Logger LOG = Log.getLogger(ExecutionStrategy.class);
    private final ExecutionStrategy.Producer _producer;
    private final Executor _executor;

    public ProduceExecuteConsume(ExecutionStrategy.Producer producer, Executor executor) {
        this._producer = producer;
        this._executor = executor;
    }

    @Override
    public void execute() {
        while (true) {
            Runnable task = this._producer.produce();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} PER produced {}", this._producer, task);
            }
            if (task == null) break;
            this._executor.execute(task);
        }
    }

    @Override
    public void dispatch() {
        this.execute();
    }
}

