/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.maven.plugin.ServerSupport;
import org.eclipse.jetty.maven.plugin.WebAppPropertyConverter;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class Starter {
    private static final Logger LOG = Log.getLogger(Starter.class);
    private List<File> jettyXmls;
    private Server server;
    private JettyWebAppContext webApp;
    private Map<String, String> jettyProperties;
    private int stopPort = 0;
    private String stopKey = null;
    private File propsFile;
    private String token;

    public void configureJetty() throws Exception {
        File qs;
        LOG.debug("Starting Jetty Server ...", new Object[0]);
        Resource.setDefaultUseCaches((boolean)false);
        this.applyJettyXml();
        ServerSupport.configureConnectors(this.server, null);
        ServerSupport.configureHandlers(this.server, null);
        ServerSupport.configureDefaultConfigurationClasses(this.server);
        this.webApp = new JettyWebAppContext();
        this.configureWebApp();
        if (this.webApp.getTempDirectory() != null && (qs = new File(this.webApp.getTempDirectory(), "quickstart-web.xml")).exists() && qs.isFile()) {
            this.webApp.setQuickStartWebDescriptor(Resource.newResource((File)qs));
        }
        ServerSupport.addWebApplication(this.server, this.webApp);
        if (this.stopPort > 0 && this.stopKey != null) {
            ShutdownMonitor monitor = ShutdownMonitor.getInstance();
            monitor.setPort(this.stopPort);
            monitor.setKey(this.stopKey);
            monitor.setExitVm(true);
        }
    }

    public void configureWebApp() throws Exception {
        if (this.propsFile == null) {
            return;
        }
        WebAppPropertyConverter.fromProperties(this.webApp, this.propsFile, this.server, this.jettyProperties);
    }

    public void getConfiguration(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            String[] tmp;
            if ("--stop-port".equals(args[i])) {
                this.stopPort = Integer.parseInt(args[++i]);
                continue;
            }
            if ("--stop-key".equals(args[i])) {
                this.stopKey = args[++i];
                continue;
            }
            if ("--jetty-xml".equals(args[i])) {
                this.jettyXmls = new ArrayList<File>();
                String[] names = StringUtil.csvSplit((String)args[++i]);
                for (int j = 0; names != null && j < names.length; ++j) {
                    this.jettyXmls.add(new File(names[j].trim()));
                }
                continue;
            }
            if ("--props".equals(args[i])) {
                this.propsFile = new File(args[++i].trim());
                continue;
            }
            if ("--token".equals(args[i])) {
                this.token = args[++i].trim();
                continue;
            }
            if (this.jettyProperties == null) {
                this.jettyProperties = new HashMap<String, String>();
            }
            if ((tmp = args[i].trim().split("=")).length != 2) continue;
            this.jettyProperties.put(tmp[0], tmp[1]);
        }
    }

    public void run() throws Exception {
        LOG.info("Started Jetty Server", new Object[0]);
        this.server.start();
    }

    public void join() throws Exception {
        this.server.join();
    }

    public void communicateStartupResult() {
        if (this.token != null) {
            try {
                Resource r = Resource.newResource((String)this.token);
                r.getFile().createNewFile();
            }
            catch (Exception x) {
                throw new IllegalStateException(x);
            }
        }
    }

    public void applyJettyXml() throws Exception {
        Server tmp = ServerSupport.applyXmlConfigurations(this.server, this.jettyXmls, this.jettyProperties);
        if (this.server == null) {
            this.server = tmp;
        }
        if (this.server == null) {
            this.server = new Server();
        }
    }

    protected void prependHandler(Handler handler, HandlerCollection handlers) {
        if (handler == null || handlers == null) {
            return;
        }
        Handler[] existing = handlers.getChildHandlers();
        Handler[] children = new Handler[existing.length + 1];
        children[0] = handler;
        System.arraycopy(existing, 0, children, 1, existing.length);
        handlers.setHandlers(children);
    }

    private List<String> fromCSV(String csv) {
        if (csv == null || "".equals(csv.trim())) {
            return null;
        }
        String[] atoms = StringUtil.csvSplit((String)csv);
        ArrayList<String> list = new ArrayList<String>();
        for (String a : atoms) {
            list.add(a.trim());
        }
        return list;
    }

    public static final void main(String[] args) {
        if (args == null) {
            System.exit(1);
        }
        Starter starter = null;
        try {
            starter = new Starter();
            starter.getConfiguration(args);
            starter.configureJetty();
            starter.run();
            starter.communicateStartupResult();
            starter.join();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

