/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebFilterAnnotationHandler
implements AnnotationParser.DiscoverableAnnotationHandler {
    protected WebAppContext _wac;

    public WebFilterAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        FilterHolder holder;
        Class clazz = null;
        try {
            clazz = Loader.loadClass(null, (String)className);
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
            return;
        }
        if (!Filter.class.isAssignableFrom(clazz)) {
            Log.warn((String)(clazz.getName() + " is not assignable from javax.servlet.Filter"));
            return;
        }
        WebFilter filterAnnotation = clazz.getAnnotation(WebFilter.class);
        if (filterAnnotation.value().length > 0 && filterAnnotation.urlPatterns().length > 0) {
            Log.warn((String)(clazz.getName() + " defines both @WebFilter.value and @WebFilter.urlPatterns"));
            return;
        }
        String name = filterAnnotation.filterName().equals("") ? clazz.getName() : filterAnnotation.filterName();
        String[] urlPatterns = filterAnnotation.value();
        if (urlPatterns.length == 0) {
            urlPatterns = filterAnnotation.urlPatterns();
        }
        if ((holder = this._wac.getServletHandler().getFilter(name)) == null) {
            String s;
            int i$;
            holder = this._wac.getServletHandler().newFilterHolder(Holder.Source.ANNOTATION);
            holder.setHeldClass(clazz);
            holder.setName(name);
            holder.setDisplayName(filterAnnotation.displayName());
            for (WebInitParam ip : filterAnnotation.initParams()) {
                holder.setInitParameter(ip.name(), ip.value());
            }
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            if (urlPatterns.length > 0) {
                ArrayList<String> paths = new ArrayList<String>();
                String[] arr$ = urlPatterns;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    s = arr$[i$];
                    paths.add(Util.normalizePattern(s));
                }
                mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
            }
            if (filterAnnotation.servletNames().length > 0) {
                ArrayList<String> names = new ArrayList<String>();
                String[] arr$ = filterAnnotation.servletNames();
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    s = arr$[i$];
                    names.add(s);
                }
                mapping.setServletNames(names.toArray(new String[names.size()]));
            }
            EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
            for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                dispatcherSet.add(d);
            }
            mapping.setDispatcherTypes(dispatcherSet);
            holder.setAsyncSupported(filterAnnotation.asyncSupported());
            this._wac.getServletHandler().addFilter(holder);
            this._wac.getServletHandler().addFilterMapping(mapping);
        } else {
            for (WebInitParam ip : filterAnnotation.initParams()) {
                if (holder.getInitParameter(ip.name()) != null) continue;
                holder.setInitParameter(ip.name(), ip.value());
            }
            FilterMapping[] mappings = this._wac.getServletHandler().getFilterMappings();
            boolean mappingExists = false;
            if (mappings != null) {
                for (FilterMapping m : mappings) {
                    if (!m.getFilterName().equals(name)) continue;
                    mappingExists = true;
                    break;
                }
            }
            if (!mappingExists) {
                String s;
                int i$;
                FilterMapping mapping = new FilterMapping();
                mapping.setFilterName(holder.getName());
                if (urlPatterns.length > 0) {
                    ArrayList<String> paths = new ArrayList<String>();
                    String[] arr$ = urlPatterns;
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        s = arr$[i$];
                        paths.add(Util.normalizePattern(s));
                    }
                    mapping.setPathSpecs(paths.toArray(new String[paths.size()]));
                }
                if (filterAnnotation.servletNames().length > 0) {
                    ArrayList<String> names = new ArrayList<String>();
                    String[] arr$ = filterAnnotation.servletNames();
                    int len$ = arr$.length;
                    for (i$ = 0; i$ < len$; ++i$) {
                        s = arr$[i$];
                        names.add(s);
                    }
                    mapping.setServletNames(names.toArray(new String[names.size()]));
                }
                EnumSet<DispatcherType> dispatcherSet = EnumSet.noneOf(DispatcherType.class);
                for (DispatcherType d : filterAnnotation.dispatcherTypes()) {
                    dispatcherSet.add(d);
                }
                mapping.setDispatcherTypes(dispatcherSet);
                this._wac.getServletHandler().addFilterMapping(mapping);
            }
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@WebFilter not applicable for fields: " + className + "." + fieldName));
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@WebFilter not applicable for methods: " + className + "." + methodName + " " + signature));
    }
}

