/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.collection.mutable;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.PrimitiveFunctions;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.primitive.ObjectDoubleMaps;
import org.eclipse.collections.impl.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

public abstract class AbstractMultiReaderMutableCollection<T>
implements MutableCollection<T> {
    protected transient ReadWriteLock lock;
    protected transient ReadWriteLockWrapper lockWrapper;

    protected abstract MutableCollection<T> getDelegate();

    public boolean contains(Object item) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().contains(item);
            return bl;
        }
    }

    public boolean containsAll(Collection<?> collection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().containsAll(collection);
            return bl;
        }
    }

    public boolean containsAllIterable(Iterable<?> source) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().containsAllIterable(source);
            return bl;
        }
    }

    public boolean containsAllArguments(Object ... elements) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().containsAllArguments(elements);
            return bl;
        }
    }

    public boolean noneSatisfy(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().noneSatisfy(predicate);
            return bl;
        }
    }

    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().noneSatisfyWith(predicate, parameter);
            return bl;
        }
    }

    public boolean allSatisfy(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().allSatisfy(predicate);
            return bl;
        }
    }

    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().allSatisfyWith(predicate, parameter);
            return bl;
        }
    }

    public boolean anySatisfy(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().anySatisfy(predicate);
            return bl;
        }
    }

    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().anySatisfyWith(predicate, parameter);
            return bl;
        }
    }

    public <R extends Collection<T>> R into(R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().into(target);
            return (R)collection;
        }
    }

    public MutableList<T> toList() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.getDelegate().toList();
            return mutableList;
        }
    }

    public ImmutableList<T> toImmutableList() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableList immutableList = this.getDelegate().toImmutableList();
            return immutableList;
        }
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMap mutableMap = this.getDelegate().toMap(keyFunction, valueFunction);
            return mutableMap;
        }
    }

    public <K, V, R extends Map<K, V>> R toMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Map map = this.getDelegate().toMap(keyFunction, valueFunction, target);
            return (R)map;
        }
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedMap mutableSortedMap = this.getDelegate().toSortedMap(keyFunction, valueFunction);
            return mutableSortedMap;
        }
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedMap mutableSortedMap = this.getDelegate().toSortedMap(comparator, keyFunction, valueFunction);
            return mutableSortedMap;
        }
    }

    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedMap mutableSortedMap = this.getDelegate().toSortedMapBy(sortBy, keyFunction, valueFunction);
            return mutableSortedMap;
        }
    }

    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBiMap mutableBiMap = this.getDelegate().toBiMap(keyFunction, valueFunction);
            return mutableBiMap;
        }
    }

    public LazyIterable<T> asLazy() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            LazyIterable lazyIterable = this.getDelegate().asLazy();
            return lazyIterable;
        }
    }

    public MutableSet<T> toSet() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSet mutableSet = this.getDelegate().toSet();
            return mutableSet;
        }
    }

    public ImmutableSet<T> toImmutableSet() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSet immutableSet = this.getDelegate().toImmutableSet();
            return immutableSet;
        }
    }

    public MutableBag<T> toBag() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.getDelegate().toBag();
            return mutableBag;
        }
    }

    public ImmutableBag<T> toImmutableBag() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableBag immutableBag = this.getDelegate().toImmutableBag();
            return immutableBag;
        }
    }

    public MutableSortedBag<T> toSortedBag() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBag();
            return mutableSortedBag;
        }
    }

    public ImmutableSortedBag<T> toImmutableSortedBag() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedBag immutableSortedBag = this.getDelegate().toImmutableSortedBag();
            return immutableSortedBag;
        }
    }

    public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBag(comparator);
            return mutableSortedBag;
        }
    }

    public ImmutableSortedBag<T> toImmutableSortedBag(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedBag immutableSortedBag = this.getDelegate().toImmutableSortedBag(comparator);
            return immutableSortedBag;
        }
    }

    public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedBag mutableSortedBag = this.getDelegate().toSortedBagBy(function);
            return mutableSortedBag;
        }
    }

    public <V extends Comparable<? super V>> ImmutableSortedBag<T> toImmutableSortedBagBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedBag immutableSortedBag = this.getDelegate().toImmutableSortedBagBy(function);
            return immutableSortedBag;
        }
    }

    public MutableList<T> toSortedList() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.getDelegate().toSortedList();
            return mutableList;
        }
    }

    public ImmutableList<T> toImmutableSortedList() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableList immutableList = this.getDelegate().toImmutableSortedList();
            return immutableList;
        }
    }

    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.getDelegate().toSortedList(comparator);
            return mutableList;
        }
    }

    public ImmutableList<T> toImmutableSortedList(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableList immutableList = this.getDelegate().toImmutableSortedList(comparator);
            return immutableList;
        }
    }

    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableList mutableList = this.getDelegate().toSortedListBy(function);
            return mutableList;
        }
    }

    public <V extends Comparable<? super V>> ImmutableList<T> toImmutableSortedListBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableList immutableList = this.getDelegate().toImmutableSortedListBy(function);
            return immutableList;
        }
    }

    public MutableSortedSet<T> toSortedSet() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSet();
            return mutableSortedSet;
        }
    }

    public ImmutableSortedSet<T> toImmutableSortedSet() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedSet immutableSortedSet = this.getDelegate().toImmutableSortedSet();
            return immutableSortedSet;
        }
    }

    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSet(comparator);
            return mutableSortedSet;
        }
    }

    public ImmutableSortedSet<T> toImmutableSortedSet(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedSet immutableSortedSet = this.getDelegate().toImmutableSortedSet(comparator);
            return immutableSortedSet;
        }
    }

    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableSortedSet mutableSortedSet = this.getDelegate().toSortedSetBy(function);
            return mutableSortedSet;
        }
    }

    public <V extends Comparable<? super V>> ImmutableSortedSet<T> toImmutableSortedSetBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableSortedSet immutableSortedSet = this.getDelegate().toImmutableSortedSetBy(function);
            return immutableSortedSet;
        }
    }

    public int count(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.getDelegate().count(predicate);
            return n;
        }
    }

    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.getDelegate().countWith(predicate, parameter);
            return n;
        }
    }

    public T detect(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().detect(predicate);
            return (T)object;
        }
    }

    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().detectWith(predicate, parameter);
            return (T)object;
        }
    }

    public Optional<T> detectOptional(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().detectOptional(predicate);
            return optional;
        }
    }

    public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().detectWithOptional(predicate, parameter);
            return optional;
        }
    }

    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().detectIfNone(predicate, function);
            return (T)object;
        }
    }

    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().detectWithIfNone(predicate, parameter, function);
            return (T)object;
        }
    }

    public T min(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().min(comparator);
            return (T)object;
        }
    }

    public T max(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().max(comparator);
            return (T)object;
        }
    }

    public Optional<T> minOptional(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().minOptional(comparator);
            return optional;
        }
    }

    public Optional<T> maxOptional(Comparator<? super T> comparator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().maxOptional(comparator);
            return optional;
        }
    }

    public T min() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().min();
            return (T)object;
        }
    }

    public T max() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().max();
            return (T)object;
        }
    }

    public Optional<T> minOptional() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().minOptional();
            return optional;
        }
    }

    public Optional<T> maxOptional() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().maxOptional();
            return optional;
        }
    }

    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().minBy(function);
            return (T)object;
        }
    }

    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().maxBy(function);
            return (T)object;
        }
    }

    public <V extends Comparable<? super V>> Optional<T> minByOptional(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().minByOptional(function);
            return optional;
        }
    }

    public <V extends Comparable<? super V>> Optional<T> maxByOptional(Function<? super T, ? extends V> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Optional optional = this.getDelegate().maxByOptional(function);
            return optional;
        }
    }

    public T getFirst() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().getFirst();
            return (T)object;
        }
    }

    public T getLast() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().getLast();
            return (T)object;
        }
    }

    public T getOnly() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().getOnly();
            return (T)object;
        }
    }

    public boolean notEmpty() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().notEmpty();
            return bl;
        }
    }

    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Twin twin = this.getDelegate().selectAndRejectWith(predicate, parameter);
            return twin;
        }
    }

    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().collect(function, target);
            return (R)collection;
        }
    }

    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBooleanCollection mutableBooleanCollection = this.getDelegate().collectBoolean(booleanFunction, target);
            return (R)mutableBooleanCollection;
        }
    }

    public <R extends MutableBooleanCollection> R flatCollectBoolean(Function<? super T, ? extends BooleanIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBooleanCollection mutableBooleanCollection = this.getDelegate().flatCollectBoolean(function, target);
            return (R)mutableBooleanCollection;
        }
    }

    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableByteCollection mutableByteCollection = this.getDelegate().collectByte(byteFunction, target);
            return (R)mutableByteCollection;
        }
    }

    public <R extends MutableByteCollection> R flatCollectByte(Function<? super T, ? extends ByteIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableByteCollection mutableByteCollection = this.getDelegate().flatCollectByte(function, target);
            return (R)mutableByteCollection;
        }
    }

    public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCharCollection mutableCharCollection = this.getDelegate().collectChar(charFunction, target);
            return (R)mutableCharCollection;
        }
    }

    public <R extends MutableCharCollection> R flatCollectChar(Function<? super T, ? extends CharIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableCharCollection mutableCharCollection = this.getDelegate().flatCollectChar(function, target);
            return (R)mutableCharCollection;
        }
    }

    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableDoubleCollection mutableDoubleCollection = this.getDelegate().collectDouble(doubleFunction, target);
            return (R)mutableDoubleCollection;
        }
    }

    public <R extends MutableDoubleCollection> R flatCollectDouble(Function<? super T, ? extends DoubleIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableDoubleCollection mutableDoubleCollection = this.getDelegate().flatCollectDouble(function, target);
            return (R)mutableDoubleCollection;
        }
    }

    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableFloatCollection mutableFloatCollection = this.getDelegate().collectFloat(floatFunction, target);
            return (R)mutableFloatCollection;
        }
    }

    public <R extends MutableFloatCollection> R flatCollectFloat(Function<? super T, ? extends FloatIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableFloatCollection mutableFloatCollection = this.getDelegate().flatCollectFloat(function, target);
            return (R)mutableFloatCollection;
        }
    }

    public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableIntCollection mutableIntCollection = this.getDelegate().collectInt(intFunction, target);
            return (R)mutableIntCollection;
        }
    }

    public <R extends MutableIntCollection> R flatCollectInt(Function<? super T, ? extends IntIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableIntCollection mutableIntCollection = this.getDelegate().flatCollectInt(function, target);
            return (R)mutableIntCollection;
        }
    }

    public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableLongCollection mutableLongCollection = this.getDelegate().collectLong(longFunction, target);
            return (R)mutableLongCollection;
        }
    }

    public <R extends MutableLongCollection> R flatCollectLong(Function<? super T, ? extends LongIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableLongCollection mutableLongCollection = this.getDelegate().flatCollectLong(function, target);
            return (R)mutableLongCollection;
        }
    }

    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableShortCollection mutableShortCollection = this.getDelegate().collectShort(shortFunction, target);
            return (R)mutableShortCollection;
        }
    }

    public <R extends MutableShortCollection> R flatCollectShort(Function<? super T, ? extends ShortIterable> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableShortCollection mutableShortCollection = this.getDelegate().flatCollectShort(function, target);
            return (R)mutableShortCollection;
        }
    }

    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().flatCollect(function, target);
            return (R)collection;
        }
    }

    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().collectIf(predicate, function, target);
            return (R)collection;
        }
    }

    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().collectWith(function, parameter, targetCollection);
            return (R)collection;
        }
    }

    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().selectWith(predicate, parameter, targetCollection);
            return (R)collection;
        }
    }

    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().reject(predicate, target);
            return (R)collection;
        }
    }

    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().rejectWith(predicate, parameter, targetCollection);
            return (R)collection;
        }
    }

    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().select(predicate, target);
            return (R)collection;
        }
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().injectInto(injectedValue, function);
            return (IV)object;
        }
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.getDelegate().injectInto(injectedValue, function);
            return n;
        }
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            long l = this.getDelegate().injectInto(injectedValue, function);
            return l;
        }
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            double d = this.getDelegate().injectInto(injectedValue, function);
            return d;
        }
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            float f = this.getDelegate().injectInto(injectedValue, function);
            return f;
        }
    }

    public long sumOfInt(IntFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            long l = this.getDelegate().sumOfInt(function);
            return l;
        }
    }

    public double sumOfFloat(FloatFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            double d = this.getDelegate().sumOfFloat(function);
            return d;
        }
    }

    public long sumOfLong(LongFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            long l = this.getDelegate().sumOfLong(function);
            return l;
        }
    }

    public double sumOfDouble(DoubleFunction<? super T> function) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            double d = this.getDelegate().sumOfDouble(function);
            return d;
        }
    }

    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByIntFunction(groupBy, function));
    }

    public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByFloatFunction(groupBy, function));
    }

    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByLongFunction(groupBy, function));
    }

    public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        MutableObjectDoubleMap result = ObjectDoubleMaps.mutable.empty();
        return this.injectInto(result, PrimitiveFunctions.sumByDoubleFunction(groupBy, function));
    }

    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object object = this.getDelegate().injectIntoWith(injectValue, function, parameter);
            return (IV)object;
        }
    }

    public boolean removeIf(Predicate<? super T> predicate) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().removeIf(predicate);
            return bl;
        }
    }

    public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().removeIfWith(predicate, parameter);
            return bl;
        }
    }

    public boolean add(T item) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().add(item);
            return bl;
        }
    }

    public boolean addAll(Collection<? extends T> collection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().addAll(collection);
            return bl;
        }
    }

    public boolean addAllIterable(Iterable<? extends T> iterable) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().addAllIterable(iterable);
            return bl;
        }
    }

    public void clear() {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            this.getDelegate().clear();
        }
    }

    public boolean isEmpty() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.getDelegate().isEmpty();
            return bl;
        }
    }

    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Iterator is not supported directly on MultiReader collections.  If you would like to use an iterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Spliterator<T> spliterator() {
        throw new UnsupportedOperationException("Spliterator is not supported directly on MultiReader collections.  If you would like to use an spliterator, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Stream<T> stream() {
        throw new UnsupportedOperationException("Stream is not supported directly on MultiReader collections.  If you would like to use stream, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public Stream<T> parallelStream() {
        throw new UnsupportedOperationException("parallelStream is not supported directly on MultiReader collections.  If you would like to use parallelStream, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    public boolean remove(Object item) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().remove(item);
            return bl;
        }
    }

    public boolean removeAll(Collection<?> collection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().removeAll(collection);
            return bl;
        }
    }

    public boolean removeAllIterable(Iterable<?> iterable) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().removeAllIterable(iterable);
            return bl;
        }
    }

    public boolean retainAll(Collection<?> collection) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().retainAll(collection);
            return bl;
        }
    }

    public boolean retainAllIterable(Iterable<?> iterable) {
        try (LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.getDelegate().retainAllIterable(iterable);
            return bl;
        }
    }

    public int size() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.getDelegate().size();
            return n;
        }
    }

    public Object[] toArray() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object[] objectArray = this.getDelegate().toArray();
            return objectArray;
        }
    }

    public <E> E[] toArray(E[] a) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Object[] objectArray = this.getDelegate().toArray((Object[])a);
            return objectArray;
        }
    }

    public void each(Procedure<? super T> procedure) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().forEach(procedure);
        }
    }

    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().forEachWith(procedure, parameter);
        }
    }

    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().forEachWithIndex(objectIntProcedure);
        }
    }

    public String toString() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.getDelegate().toString();
            return string;
        }
    }

    public String makeString() {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.getDelegate().makeString();
            return string;
        }
    }

    public String makeString(String separator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.getDelegate().makeString(separator);
            return string;
        }
    }

    public String makeString(String start, String separator, String end) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.getDelegate().makeString(start, separator, end);
            return string;
        }
    }

    public void appendString(Appendable appendable) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().appendString(appendable);
        }
    }

    public void appendString(Appendable appendable, String separator) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().appendString(appendable, separator);
        }
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.getDelegate().appendString(appendable, start, separator, end);
        }
    }

    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMultimap mutableMultimap = this.getDelegate().groupBy(function, target);
            return (R)mutableMultimap;
        }
    }

    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMultimap mutableMultimap = this.getDelegate().groupByEach(function, target);
            return (R)mutableMultimap;
        }
    }

    public <V, R extends MutableMapIterable<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableMapIterable mutableMapIterable = this.getDelegate().groupByUniqueKey(function, target);
            return (R)mutableMapIterable;
        }
    }

    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().zip(that, target);
            return (R)collection;
        }
    }

    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        try (LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            Collection collection = this.getDelegate().zipWithIndex(target);
            return (R)collection;
        }
    }

    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public static class LockWrapper
    implements AutoCloseable {
        private final Lock lock;

        public LockWrapper(Lock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }

    public static class ReadWriteLockWrapper {
        private final LockWrapper readLock;
        private final LockWrapper writeLock;

        public ReadWriteLockWrapper(ReadWriteLock readWriteLock) {
            this.readLock = new LockWrapper(readWriteLock.readLock());
            this.writeLock = new LockWrapper(readWriteLock.writeLock());
        }

        public LockWrapper acquireReadLock() {
            this.readLock.lock.lock();
            return this.readLock;
        }

        public LockWrapper acquireWriteLock() {
            this.writeLock.lock.lock();
            return this.writeLock;
        }
    }

    protected static abstract class UntouchableMutableCollection<T>
    implements MutableCollection<T> {
        protected MutableCollection<T> delegate;

        protected UntouchableMutableCollection() {
        }

        public boolean allSatisfy(Predicate<? super T> predicate) {
            return this.delegate.allSatisfy(predicate);
        }

        public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.allSatisfyWith(predicate, parameter);
        }

        public boolean noneSatisfy(Predicate<? super T> predicate) {
            return this.delegate.noneSatisfy(predicate);
        }

        public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.noneSatisfyWith(predicate, parameter);
        }

        public boolean anySatisfy(Predicate<? super T> predicate) {
            return this.delegate.anySatisfy(predicate);
        }

        public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.anySatisfyWith(predicate, parameter);
        }

        public <R extends Collection<T>> R into(R target) {
            return (R)this.delegate.into(target);
        }

        public MutableList<T> toList() {
            return this.delegate.toList();
        }

        public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toMap(keyFunction, valueFunction);
        }

        public <NK, NV, R extends Map<NK, NV>> R toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction, R target) {
            return (R)this.delegate.toMap(keyFunction, valueFunction, target);
        }

        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(keyFunction, valueFunction);
        }

        public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
        }

        public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toSortedMapBy(sortBy, keyFunction, valueFunction);
        }

        public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
            return this.delegate.toBiMap(keyFunction, valueFunction);
        }

        public MutableSet<T> toSet() {
            return this.delegate.toSet();
        }

        public MutableBag<T> toBag() {
            return this.delegate.toBag();
        }

        public MutableSortedBag<T> toSortedBag() {
            return this.delegate.toSortedBag();
        }

        public MutableSortedBag<T> toSortedBag(Comparator<? super T> comparator) {
            return this.delegate.toSortedBag(comparator);
        }

        public <V extends Comparable<? super V>> MutableSortedBag<T> toSortedBagBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedBagBy(function);
        }

        public MutableList<T> toSortedList() {
            return this.delegate.toSortedList();
        }

        public MutableList<T> toSortedList(Comparator<? super T> comparator) {
            return this.delegate.toSortedList(comparator);
        }

        public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedListBy(function);
        }

        public MutableSortedSet<T> toSortedSet() {
            return this.delegate.toSortedSet();
        }

        public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
            return this.delegate.toSortedSet(comparator);
        }

        public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
            return this.delegate.toSortedSetBy(function);
        }

        public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.collect(function, target);
        }

        public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
            return (R)this.delegate.flatCollect(function, target);
        }

        public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.collectIf(predicate, function, target);
        }

        public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
            return (R)this.delegate.collectWith(function, parameter, targetCollection);
        }

        public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.groupBy(function, target);
        }

        public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
            return (R)this.delegate.groupByEach(function, target);
        }

        public <V, R extends MutableMapIterable<V, T>> R groupByUniqueKey(Function<? super T, ? extends V> function, R target) {
            return (R)this.delegate.groupByUniqueKey(function, target);
        }

        public int count(Predicate<? super T> predicate) {
            return this.delegate.count(predicate);
        }

        public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.countWith(predicate, parameter);
        }

        public T detect(Predicate<? super T> predicate) {
            return (T)this.delegate.detect(predicate);
        }

        public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return (T)this.delegate.detectWith(predicate, parameter);
        }

        public Optional<T> detectOptional(Predicate<? super T> predicate) {
            return this.delegate.detectOptional(predicate);
        }

        public <P> Optional<T> detectWithOptional(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.detectWithOptional(predicate, parameter);
        }

        public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
            return (T)this.delegate.detectIfNone(predicate, function);
        }

        public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
            return (T)this.delegate.detectWithIfNone(predicate, parameter, function);
        }

        public T min(Comparator<? super T> comparator) {
            return (T)this.delegate.min(comparator);
        }

        public T max(Comparator<? super T> comparator) {
            return (T)this.delegate.max(comparator);
        }

        public T min() {
            return (T)this.delegate.min();
        }

        public T max() {
            return (T)this.delegate.max();
        }

        public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
            return (T)this.delegate.minBy(function);
        }

        public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
            return (T)this.delegate.maxBy(function);
        }

        public T getFirst() {
            return (T)this.delegate.getFirst();
        }

        public T getLast() {
            return (T)this.delegate.getLast();
        }

        public T getOnly() {
            return (T)this.delegate.getOnly();
        }

        public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
            return (IV)this.delegate.injectInto(injectedValue, function);
        }

        public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
            return this.delegate.injectInto(injectedValue, function);
        }

        public long sumOfInt(IntFunction<? super T> function) {
            return this.delegate.sumOfInt(function);
        }

        public double sumOfFloat(FloatFunction<? super T> function) {
            return this.delegate.sumOfFloat(function);
        }

        public long sumOfLong(LongFunction<? super T> function) {
            return this.delegate.sumOfLong(function);
        }

        public double sumOfDouble(DoubleFunction<? super T> function) {
            return this.delegate.sumOfDouble(function);
        }

        public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
            return this.delegate.sumByInt(groupBy, function);
        }

        public <V> MutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
            return this.delegate.sumByFloat(groupBy, function);
        }

        public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
            return this.delegate.sumByLong(groupBy, function);
        }

        public <V> MutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
            return this.delegate.sumByDouble(groupBy, function);
        }

        public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
            return (IV)this.delegate.injectIntoWith(injectValue, function, parameter);
        }

        public boolean notEmpty() {
            return this.delegate.notEmpty();
        }

        public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
            return (R)this.delegate.reject(predicate, target);
        }

        public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return (R)this.delegate.rejectWith(predicate, parameter, targetCollection);
        }

        public boolean removeIf(Predicate<? super T> predicate) {
            return this.delegate.removeIf(predicate);
        }

        public <P> boolean removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.removeIfWith(predicate, parameter);
        }

        public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
            return (R)this.delegate.select(predicate, target);
        }

        public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.delegate.selectAndRejectWith(predicate, parameter);
        }

        public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
            return (R)this.delegate.selectWith(predicate, parameter, targetCollection);
        }

        public boolean add(T o) {
            return this.delegate.add(o);
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.delegate.addAll(collection);
        }

        public boolean addAllIterable(Iterable<? extends T> iterable) {
            return this.delegate.addAllIterable(iterable);
        }

        public void clear() {
            this.delegate.clear();
        }

        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.delegate.containsAll(collection);
        }

        public boolean containsAllIterable(Iterable<?> source) {
            return this.delegate.containsAllIterable(source);
        }

        public boolean containsAllArguments(Object ... elements) {
            return this.delegate.containsAllArguments(elements);
        }

        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean remove(Object o) {
            return this.delegate.remove(o);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.delegate.removeAll(collection);
        }

        public boolean removeAllIterable(Iterable<?> iterable) {
            return this.delegate.removeAllIterable(iterable);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.delegate.retainAll(collection);
        }

        public boolean retainAllIterable(Iterable<?> iterable) {
            return this.delegate.retainAllIterable(iterable);
        }

        public int size() {
            return this.delegate.size();
        }

        public Object[] toArray() {
            return this.delegate.toArray();
        }

        public <E> E[] toArray(E[] a) {
            return this.delegate.toArray((Object[])a);
        }

        public void each(Procedure<? super T> procedure) {
            this.delegate.forEach(procedure);
        }

        public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
            this.delegate.forEachWith(procedure, parameter);
        }

        public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
            this.delegate.forEachWithIndex(objectIntProcedure);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public String makeString() {
            return this.delegate.makeString();
        }

        public String makeString(String separator) {
            return this.delegate.makeString(separator);
        }

        public String makeString(String start, String separator, String end) {
            return this.delegate.makeString(start, separator, end);
        }

        public void appendString(Appendable appendable) {
            this.delegate.appendString(appendable);
        }

        public void appendString(Appendable appendable, String separator) {
            this.delegate.appendString(appendable, separator);
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            this.delegate.appendString(appendable, start, separator, end);
        }

        public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
            return (R)this.delegate.zip(that, target);
        }

        public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
            return (R)this.delegate.zipWithIndex(target);
        }

        public RichIterable<RichIterable<T>> chunk(int size) {
            return this.delegate.chunk(size);
        }
    }
}

