/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.pooling;

import java.util.Map;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.layers.convolutional.KerasConvolutionUtils;
import org.deeplearning4j.nn.modelimport.keras.layers.pooling.KerasPoolingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerasPooling2D
extends KerasLayer {
    private static final Logger log = LoggerFactory.getLogger(KerasPooling2D.class);

    public KerasPooling2D(Map<String, Object> layerConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true);
    }

    public KerasPooling2D(Map<String, Object> layerConfig, boolean enforceTrainingConfig) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        SubsamplingLayer.Builder builder = ((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)((SubsamplingLayer.Builder)new SubsamplingLayer.Builder(KerasPoolingUtils.mapPoolingType(this.className, this.conf)).name(this.layerName)).dropOut(this.dropout)).dataFormat(this.dimOrder == KerasLayer.DimOrder.TENSORFLOW ? CNN2DFormat.NHWC : CNN2DFormat.NCHW)).convolutionMode(KerasConvolutionUtils.getConvolutionModeFromConfig(layerConfig, this.conf))).kernelSize(KerasConvolutionUtils.getKernelSizeFromConfig(layerConfig, 2, this.conf, this.kerasMajorVersion)).stride(KerasConvolutionUtils.getStrideFromConfig(layerConfig, 2, this.conf));
        int[] padding = KerasConvolutionUtils.getPaddingFromBorderModeConfig(layerConfig, 2, this.conf, this.kerasMajorVersion);
        if (padding != null) {
            builder.padding(padding);
        }
        this.layer = builder.build();
        SubsamplingLayer subsamplingLayer = (SubsamplingLayer)this.layer;
        subsamplingLayer.setDefaultValueOverridden(true);
        this.vertex = null;
    }

    public SubsamplingLayer getSubsampling2DLayer() {
        return (SubsamplingLayer)this.layer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras Subsampling 2D layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSubsampling2DLayer().getOutputType(-1, inputType[0]);
    }
}

