/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx;

import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclonedx.BomGenerator;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.model.Attribute;
import org.cyclonedx.model.Hash;
import org.cyclonedx.model.License;
import org.cyclonedx.model.LicenseChoice;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class AbstractBomGenerator
extends CycloneDxSchema
implements BomGenerator {
    Document doc;

    AbstractBomGenerator() {
    }

    Element createElement(Node parent, String name) {
        Element node = this.doc.createElement(name);
        parent.appendChild(node);
        return node;
    }

    Element createElement(Node parent, String name, Object value) {
        return this.createElement(parent, name, value, new Attribute[0]);
    }

    Element createElement(Node parent, String name, Object value, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = name.contains(":") ? this.doc.createElement(name) : this.doc.createElementNS(this.getSchemaVersion().getNamespace(), name);
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                node.appendChild(this.doc.createTextNode(value.toString()));
            }
            parent.appendChild(node);
        }
        return node;
    }

    void createHashesNode(Node parent, List<Hash> hashes) {
        if (hashes != null && !hashes.isEmpty()) {
            Element hashesNode = this.createElement(parent, "hashes");
            for (Hash hash : hashes) {
                this.createElement(hashesNode, "hash", hash.getValue(), new Attribute("alg", hash.getAlgorithm()));
            }
        }
    }

    void createLicenseNode(Node parent, LicenseChoice licenseChoice, boolean expressionSupport) {
        if (licenseChoice != null) {
            Element licensesNode = this.doc.createElement("licenses");
            if (licenseChoice.getLicenses() != null) {
                parent.appendChild(licensesNode);
                for (License license : licenseChoice.getLicenses()) {
                    Element licenseNode = this.doc.createElement("license");
                    if (license.getId() != null) {
                        Element licenseIdNode = this.doc.createElement("id");
                        licenseIdNode.appendChild(this.doc.createTextNode(license.getId()));
                        licenseNode.appendChild(licenseIdNode);
                    } else if (license.getName() != null) {
                        Element licenseNameNode = this.doc.createElement("name");
                        licenseNameNode.appendChild(this.doc.createTextNode(license.getName()));
                        licenseNode.appendChild(licenseNameNode);
                    }
                    licensesNode.appendChild(licenseNode);
                }
            } else if (expressionSupport && licenseChoice.getExpression() != null) {
                this.createElement(licensesNode, "expression", AbstractBomGenerator.stripBreaks(licenseChoice.getExpression()));
            }
        }
    }

    Element createRootElement(String name, Object value, Attribute ... attributes) {
        Element node = null;
        if (value != null || attributes.length > 0) {
            node = this.doc.createElementNS(this.getSchemaVersion().getNamespace(), name);
            for (Attribute attribute : attributes) {
                node.setAttribute(attribute.getKey(), attribute.getValue());
            }
            if (value != null) {
                node.appendChild(this.doc.createTextNode(value.toString()));
            }
            this.doc.appendChild(node);
        }
        return node;
    }

    static String stripBreaks(String in) {
        if (in == null) {
            return null;
        }
        return in.trim().replace("\r\n", " ").replace("\n", " ").replace("\t", " ").replace("\r", " ").replaceAll(" +", " ");
    }

    @Override
    public String toXmlString() throws TransformerException {
        if (this.doc == null) {
            return null;
        }
        DOMSource domSource = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(domSource, result);
        return writer.toString();
    }

    @Override
    public String toString() {
        try {
            return this.toXmlString();
        }
        catch (TransformerException e) {
            return "";
        }
    }
}

