/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.maven;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.EnvironmentConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.RuntimeInformation;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.slf4j.LoggerFactory;
import org.sonar.batch.Batch;
import org.sonar.batch.MavenProjectConverter;
import org.sonar.batch.bootstrapper.EnvironmentInformation;
import org.sonar.batch.bootstrapper.ProjectDefinition;
import org.sonar.batch.bootstrapper.Reactor;
import org.sonar.maven.Maven2PluginExecutor;

public final class SonarMojo
extends AbstractMojo {
    private MavenSession session;
    private MavenProject project;
    private LifecycleExecutor lifecycleExecutor;
    private PluginManager pluginManager;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private MavenProjectBuilder projectBuilder;
    private RuntimeInformation runtimeInformation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.initLogging();
        this.executeBatch();
    }

    private void executeBatch() throws MojoExecutionException {
        ProjectDefinition def = MavenProjectConverter.convert((List)this.session.getSortedProjects(), (MavenProject)this.project);
        Reactor reactor = new Reactor(def);
        Batch batch = new Batch(this.getInitialConfiguration(), new Object[]{reactor, this.session, this.project, this.getLog(), this.lifecycleExecutor, this.pluginManager, this.artifactFactory, this.localRepository, this.artifactMetadataSource, this.artifactCollector, this.dependencyTreeBuilder, this.projectBuilder, this.getEnvironmentInformation(), Maven2PluginExecutor.class});
        batch.execute();
    }

    private EnvironmentInformation getEnvironmentInformation() {
        String mavenVersion = this.runtimeInformation.getApplicationVersion().toString();
        return new EnvironmentInformation("Maven", mavenVersion);
    }

    private void initLogging() throws MojoExecutionException {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)context);
        context.reset();
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/org/sonar/batch/logback.xml");
        System.setProperty("ROOT_LOGGER_LEVEL", this.getLog().isDebugEnabled() ? "DEBUG" : "INFO");
        try {
            jc.doConfigure(input);
        }
        catch (JoranException e) {
            throw new MojoExecutionException("can not initialize logging", (Exception)((Object)e));
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private Configuration getInitialConfiguration() {
        CompositeConfiguration configuration = new CompositeConfiguration();
        configuration.addConfiguration((Configuration)new SystemConfiguration());
        configuration.addConfiguration((Configuration)new EnvironmentConfiguration());
        configuration.addConfiguration((Configuration)new MapConfiguration((Map)this.project.getModel().getProperties()));
        return configuration;
    }
}

