/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.token;

import java.io.Reader;
import java.io.StringReader;
import org.sonar.channel.Channel;
import org.sonar.channel.ChannelDispatcher;
import org.sonar.channel.CodeReader;
import org.sonar.channel.CodeReaderConfiguration;
import org.sonar.duplications.DuplicationsException;
import org.sonar.duplications.token.BlackHoleTokenChannel;
import org.sonar.duplications.token.TokenChannel;
import org.sonar.duplications.token.TokenQueue;

public final class TokenChunker {
    private static final int BUFFER_CAPACITY = 80000;
    private final ChannelDispatcher<TokenQueue> channelDispatcher;

    public static Builder builder() {
        return new Builder();
    }

    private TokenChunker(Builder builder) {
        this.channelDispatcher = builder.getChannelDispatcher();
    }

    public TokenQueue chunk(String sourceCode) {
        return this.chunk(new StringReader(sourceCode));
    }

    public TokenQueue chunk(Reader reader) {
        CodeReaderConfiguration codeReaderConfiguration = new CodeReaderConfiguration();
        codeReaderConfiguration.setBufferCapacity(80000);
        CodeReader code = new CodeReader(reader, codeReaderConfiguration);
        TokenQueue queue = new TokenQueue();
        try {
            this.channelDispatcher.consume(code, (Object)queue);
            return queue;
        }
        catch (Exception e) {
            throw new DuplicationsException("Unable to lex source code at line : " + code.getLinePosition() + " and column : " + code.getColumnPosition(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Builder {
        private ChannelDispatcher.Builder channelDispatcherBuilder = ChannelDispatcher.builder();

        private Builder() {
        }

        public TokenChunker build() {
            return new TokenChunker(this);
        }

        public Builder ignore(String regularExpression) {
            this.channelDispatcherBuilder.addChannel((Channel)new BlackHoleTokenChannel(regularExpression));
            return this;
        }

        public Builder token(String regularExpression) {
            this.channelDispatcherBuilder.addChannel((Channel)new TokenChannel(regularExpression));
            return this;
        }

        public Builder token(String regularExpression, String normalizationValue) {
            this.channelDispatcherBuilder.addChannel((Channel)new TokenChannel(regularExpression, normalizationValue));
            return this;
        }

        private ChannelDispatcher<TokenQueue> getChannelDispatcher() {
            return this.channelDispatcherBuilder.build();
        }
    }
}

