/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.javac.InProcessCompiler;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Named(value="javac")
@Singleton
public class JavacCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    private static final String[] MISC_PREFIXES = new String[]{"["};
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private volatile Class<?> javacClass;
    private final Deque<Class<?>> javacClasses = new ConcurrentLinkedDeque();
    private static final Pattern JAVA_MAJOR_AND_MINOR_VERSION_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");
    private static final Map<String, String> VERSION_PER_EXECUTABLE = new ConcurrentHashMap<String, String>();
    @Inject
    private InProcessCompiler inProcessCompiler;
    private static final Pattern STACK_TRACE_FIRST_LINE = Pattern.compile("^(?:[\\w+.-]+\\.)[\\w$]*?(?:Exception|Error|Throwable|Failure|Result|Abort|Fault|ThreadDeath|Overflow|Warning|NotSupported|NotFound|BadArgs|BadClassFile|Illegal|Invalid|Unexpected|Unchecked|Unmatched\\w+).*$");
    private static final Pattern STACK_TRACE_OTHER_LINE = Pattern.compile("^(?:Caused by:\\s.*|\\s*at .*|\\s*\\.\\.\\.\\s\\d+\\smore)$");
    private static final Pattern JAVAC_OR_JVM_ERROR = Pattern.compile("^(?:javac:|Error occurred during initialization of (?:boot layer|VM)).*", 32);

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public String getCompilerId() {
        return "javac";
    }

    private String getInProcessJavacVersion() throws CompilerException {
        return System.getProperty("java.version");
    }

    private String getOutOfProcessJavacVersion(String executable) throws CompilerException {
        String version = VERSION_PER_EXECUTABLE.get(executable);
        if (version == null) {
            Commandline cli = new Commandline();
            cli.setExecutable(executable);
            cli.addArguments(new String[]{"-version"});
            CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
            try {
                int exitCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
                if (exitCode != 0) {
                    throw new CompilerException("Could not retrieve version from " + executable + ". Exit code " + exitCode + ", Output: " + out.getOutput());
                }
            }
            catch (CommandLineException e) {
                throw new CompilerException("Error while executing the external compiler " + executable, (Throwable)e);
            }
            version = JavacCompiler.extractMajorAndMinorVersion(out.getOutput());
            VERSION_PER_EXECUTABLE.put(executable, version);
        }
        return version;
    }

    static String extractMajorAndMinorVersion(String text) {
        Matcher matcher = JAVA_MAJOR_AND_MINOR_VERSION_PATTERN.matcher(text);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Could not extract version from \"" + text + "\"");
        }
        return matcher.group();
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String javacVersion;
        String executable;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        this.logCompiling(sourceFiles, config);
        if (config.isFork()) {
            executable = this.getJavacExecutable(config);
            javacVersion = this.getOutOfProcessJavacVersion(executable);
        } else {
            javacVersion = this.getInProcessJavacVersion();
            executable = null;
        }
        String[] args = JavacCompiler.buildCompilerArguments(config, sourceFiles, javacVersion);
        CompilerResult result = config.isFork() ? this.compileOutOfProcess(config, executable, args) : (JavacCompiler.hasJavaxToolProvider() && !config.isForceJavacCompilerUse() ? this.inProcessCompiler().compileInProcess(args, config, sourceFiles) : this.compileInProcess(args, config));
        return result;
    }

    protected InProcessCompiler inProcessCompiler() {
        return this.inProcessCompiler;
    }

    protected static boolean hasJavaxToolProvider() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("javax.tools.ToolProvider");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        String javacVersion;
        if (config.isFork()) {
            String executable = this.getJavacExecutable(config);
            javacVersion = this.getOutOfProcessJavacVersion(executable);
        } else {
            javacVersion = this.getInProcessJavacVersion();
        }
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles((CompilerConfiguration)config), javacVersion);
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles, String javacVersion) {
        List sourceLocations;
        List modulepathEntries;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(JavacCompiler.getPathString((List)classpathEntries));
        }
        if ((modulepathEntries = config.getModulepathEntries()) != null && !modulepathEntries.isEmpty()) {
            args.add("--module-path");
            args.add(JavacCompiler.getPathString((List)modulepathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(JavacCompiler.getPathString((List)sourceLocations));
        }
        if (!JavacCompiler.hasJavaxToolProvider() || config.isForceJavacCompilerUse() || config.isFork()) {
            args.addAll(Arrays.asList(sourceFiles));
        }
        if (JavaVersion.JAVA_1_6.isOlderOrEqualTo(javacVersion)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args.add("-s");
                args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args.add(buffer.toString());
            }
            if (config.getProcessorPathEntries() != null && !config.getProcessorPathEntries().isEmpty()) {
                args.add("-processorpath");
                args.add(JavacCompiler.getPathString((List)config.getProcessorPathEntries()));
            }
            if (config.getProcessorModulePathEntries() != null && !config.getProcessorModulePathEntries().isEmpty()) {
                args.add("--processor-module-path");
                args.add(JavacCompiler.getPathString((List)config.getProcessorModulePathEntries()));
            }
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty((String)config.getDebugLevel())) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (JavaVersion.JAVA_1_8.isOlderOrEqualTo(javacVersion) && config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isEnablePreview()) {
            args.add("--enable-preview");
        }
        if (config.getImplicitOption() != null) {
            args.add("-implicit:" + config.getImplicitOption());
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        } else {
            String warnings = config.getWarnings();
            if (config.isShowLint()) {
                if (config.isShowWarnings() && StringUtils.isNotEmpty((String)warnings)) {
                    args.add("-Xlint:" + warnings);
                } else {
                    args.add("-Xlint");
                }
            }
        }
        if (config.isFailOnWarning()) {
            args.add("-Werror");
        }
        if (JavaVersion.JAVA_9.isOlderOrEqualTo(javacVersion) && !StringUtils.isEmpty((String)config.getReleaseVersion())) {
            args.add("--release");
            args.add(config.getReleaseVersion());
        } else {
            if (StringUtils.isEmpty((String)config.getTargetVersion())) {
                args.add("-target");
                args.add("1.1");
            } else {
                args.add("-target");
                args.add(config.getTargetVersion());
            }
            if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion) && StringUtils.isEmpty((String)config.getSourceVersion())) {
                args.add("-source");
                args.add("1.3");
            } else if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion)) {
                args.add("-source");
                args.add(config.getSourceVersion());
            }
        }
        if (JavaVersion.JAVA_1_4.isOlderOrEqualTo(javacVersion) && !StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!StringUtils.isEmpty((String)config.getModuleVersion())) {
            args.add("--module-version");
            args.add(config.getModuleVersion());
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("-J")) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        if (!config.isFork() && !args.contains("-XDuseUnsharedTable=false")) {
            args.add("-XDuseUnsharedTable=true");
        }
        return args.toArray(new String[0]);
    }

    protected CompilerResult compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block11: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args, config.getBuildDirectory().getAbsolutePath());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty((String)config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty((String)config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
                for (String key : config.getCustomCompilerArgumentsAsMap().keySet()) {
                    if (!StringUtils.isNotEmpty((String)key) || !key.startsWith("-J")) continue;
                    cli.addArguments(new String[]{key});
                }
            }
            catch (IOException e) {
                throw new CompilerException("Error creating file with javac arguments", (Throwable)e);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            if (this.getLog().isDebugEnabled()) {
                String debugFileName = StringUtils.isEmpty((String)config.getDebugFileName()) ? "javac" : config.getDebugFileName();
                File commandLineFile = new File(config.getBuildDirectory(), StringUtils.trim((String)debugFileName) + "." + (Os.isFamily((String)"windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite((String)commandLineFile.getAbsolutePath(), (String)cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily((String)"windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e) {
                    if (!this.getLog().isWarnEnabled()) break block11;
                    this.getLog().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", (Throwable)e);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)out);
            messages = JavacCompiler.parseModernStream(returnCode, new BufferedReader(new StringReader(out.getOutput())));
        }
        catch (IOException | CommandLineException e) {
            throw new CompilerException("Error while executing the external compiler.", e);
        }
        boolean success = returnCode == 0;
        return new CompilerResult(success, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        Class<?> javacClass = this.getJavacClass(config);
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(javacClass.getClassLoader());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("ttcl changed run compileInProcessWithProperClassloader");
        }
        try {
            CompilerResult compilerResult = this.compileInProcessWithProperClassloader(javacClass, args);
            return compilerResult;
        }
        finally {
            this.releaseJavaccClass(javacClass, config);
            thread.setContextClassLoader(contextClassLoader);
        }
    }

    protected CompilerResult compileInProcessWithProperClassloader(Class<?> javacClass, String[] args) throws CompilerException {
        return JavacCompiler.compileInProcess0(javacClass, args);
    }

    private static CompilerResult compileInProcess0(Class<?> javacClass, String[] args) throws CompilerException {
        List<CompilerMessage> messages;
        Integer ok;
        StringWriter out = new StringWriter();
        try {
            Method compile = javacClass.getMethod("compile", String[].class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        StringBuilder buffer = new StringBuilder();
        boolean hasPointer = false;
        int stackTraceLineCount = 0;
        while (true) {
            String line;
            if ((line = input.readLine()) == null) {
                String bufferAsString = buffer.toString();
                if (buffer.length() > 0) {
                    if (JAVAC_OR_JVM_ERROR.matcher(bufferAsString).matches()) {
                        errors.add(new CompilerMessage(bufferAsString, CompilerMessage.Kind.ERROR));
                    } else if (hasPointer) {
                        errors.add(JavacCompiler.parseModernError(exitCode, bufferAsString));
                    } else if (stackTraceLineCount > 0) {
                        String lineBeforeStackTrace;
                        String[] lines = bufferAsString.split("\\R");
                        int linesTotal = lines.length;
                        buffer = new StringBuilder();
                        int firstLine = linesTotal - stackTraceLineCount;
                        if (firstLine > 0 && ((lineBeforeStackTrace = lines[firstLine - 1]).contains("java.sun.com/webapps/bugreport") || lineBeforeStackTrace.contains("bugreport.java.com"))) {
                            --firstLine;
                        }
                        for (int i = firstLine; i < linesTotal; ++i) {
                            buffer.append(lines[i]).append(EOL);
                        }
                        errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                    }
                }
                return errors;
            }
            stackTraceLineCount = stackTraceLineCount == 0 && STACK_TRACE_FIRST_LINE.matcher(line).matches() || STACK_TRACE_OTHER_LINE.matcher(line).matches() ? ++stackTraceLineCount : 0;
            if (!line.startsWith(" ") && hasPointer) {
                errors.add(JavacCompiler.parseModernError(exitCode, buffer.toString()));
                buffer = new StringBuilder();
                hasPointer = false;
            }
            if (buffer.length() == 0 && line.startsWith("error: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.ERROR));
            } else if (buffer.length() == 0 && line.startsWith("warning: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.WARNING));
            } else if (buffer.length() != 0 || !JavacCompiler.isNote(line)) {
                if (buffer.length() == 0 && JavacCompiler.isMisc(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.OTHER));
                } else {
                    buffer.append(line);
                    buffer.append(EOL);
                }
            }
            if (!line.endsWith("^")) continue;
            hasPointer = true;
        }
    }

    private static boolean isMisc(String line) {
        return JavacCompiler.startsWithPrefix(line, MISC_PREFIXES);
    }

    private static boolean isNote(String line) {
        return JavacCompiler.startsWithPrefix(line, NOTE_PREFIXES);
    }

    private static boolean startsWithPrefix(String line, String[] prefixes) {
        for (String prefix : prefixes) {
            if (!line.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            StringBuilder file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    if (file == null) {
                        file = new StringBuilder(currentToken);
                    } else {
                        file.append(':').append(currentToken);
                    }
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = file.toString().lastIndexOf(93);
            if (startOfFileName > -1) {
                file = new StringBuilder(file.substring(startOfFileName + 1 + EOL.length()));
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String warnPrefix = JavacCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            } else {
                isError = exitCode != 0;
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = null;
            do {
                String msgLine = tokens.nextToken(EOL);
                if (pointer != null) {
                    msgBuffer.append(msgLine);
                    msgBuffer.append(EOL);
                    continue;
                }
                if (msgLine.endsWith("^")) {
                    pointer = msgLine;
                    continue;
                }
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                context = msgLine;
            } while (tokens.hasMoreTokens());
            msgBuffer.append(EOL);
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerMessage(file.toString(), isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (String warningPrefix : WARNING_PREFIXES) {
            if (!msg.startsWith(warningPrefix)) continue;
            return warningPrefix;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile;
            if (this.getLog().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (String arg : args) {
                String argValue = arg.replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    protected String getJavacExecutable(CompilerConfiguration config) {
        String executable = config.getExecutable();
        if (StringUtils.isEmpty((String)executable)) {
            try {
                executable = JavacCompiler.getJavacExecutable();
            }
            catch (IOException e) {
                if (this.getLog().isWarnEnabled()) {
                    this.getLog().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                }
                executable = "javac";
            }
        }
        return executable;
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }

    private void releaseJavaccClass(Class<?> javaccClass, CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration.getCompilerReuseStrategy() == CompilerConfiguration.CompilerReuseStrategy.ReuseCreated) {
            this.javacClasses.add(javaccClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getJavacClass(CompilerConfiguration compilerConfiguration) throws CompilerException {
        switch (compilerConfiguration.getCompilerReuseStrategy()) {
            case AlwaysNew: {
                return this.createJavacClass();
            }
            case ReuseCreated: {
                Class<?> c = this.javacClasses.poll();
                if (c == null) {
                    c = this.createJavacClass();
                }
                return c;
            }
        }
        Class<?> c = this.javacClass;
        if (c == null) {
            JavacCompiler javacCompiler = this;
            synchronized (javacCompiler) {
                c = this.javacClass;
                if (c == null) {
                    this.javacClass = c = this.createJavacClass();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> createJavacClass() throws CompilerException {
        try {
            return JavacCompiler.class.getClassLoader().loadClass(JAVAC_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new CompilerException("tools.jar not found: " + toolsJar);
            }
            URL[] originalUrls = ((URLClassLoader)JavacCompiler.class.getClassLoader()).getURLs();
            URL[] urls = new URL[originalUrls.length + 1];
            urls[0] = toolsJar.toURI().toURL();
            System.arraycopy(originalUrls, 0, urls, 1, originalUrls.length);
            URLClassLoader javacClassLoader = new URLClassLoader(urls);
            Thread thread = Thread.currentThread();
            ClassLoader contextClassLoader = thread.getContextClassLoader();
            thread.setContextClassLoader(javacClassLoader);
            try {
                Class<?> clazz = javacClassLoader.loadClass(JAVAC_CLASSNAME);
                thread.setContextClassLoader(contextClassLoader);
                return clazz;
            }
            catch (Throwable throwable) {
                try {
                    thread.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new CompilerException("Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.", (Throwable)ex);
                }
            }
        }
    }

    static enum JavaVersion {
        JAVA_1_3_OR_OLDER("1.3", "1.2", "1.1", "1.0"),
        JAVA_1_4("1.4"),
        JAVA_1_5("1.5"),
        JAVA_1_6("1.6"),
        JAVA_1_7("1.7"),
        JAVA_1_8("1.8"),
        JAVA_9("9");

        final Set<String> versionPrefixes;

        private JavaVersion(String ... versionPrefixes) {
            this.versionPrefixes = new HashSet<String>(Arrays.asList(versionPrefixes));
        }

        boolean isOlderOrEqualTo(String version) {
            JavaVersion[] allJavaVersionPrefixes = JavaVersion.values();
            for (int n = this.ordinal() - 1; n > -1; --n) {
                if (!allJavaVersionPrefixes[n].versionPrefixes.stream().anyMatch(version::startsWith)) continue;
                return false;
            }
            return true;
        }
    }
}

