/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.bzip2;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.bzip2.CBZip2InputStream;

public class BZip2UnArchiver
extends AbstractUnArchiver {
    public BZip2UnArchiver() {
    }

    public BZip2UnArchiver(File sourceFile) {
        super(sourceFile);
    }

    /*
     * Loose catch block
     */
    protected void execute() throws ArchiverException {
        block29: {
            if (this.getSourceFile().lastModified() > this.getDestFile().lastModified()) {
                IOException ioex2222;
                BufferedInputStream bis;
                FileInputStream fis;
                InputStream zIn;
                FileOutputStream out;
                block26: {
                    this.getLogger().info("Expanding " + this.getSourceFile().getAbsolutePath() + " to " + this.getDestFile().getAbsolutePath());
                    out = null;
                    zIn = null;
                    fis = null;
                    bis = null;
                    out = new FileOutputStream(this.getDestFile());
                    fis = new FileInputStream(this.getSourceFile());
                    bis = new BufferedInputStream(fis);
                    zIn = BZip2UnArchiver.getBZip2InputStream(bis);
                    if (zIn == null) {
                        throw new ArchiverException(this.getSourceFile().getAbsolutePath() + " is an invalid bz2 file.");
                    }
                    byte[] buffer = new byte[8192];
                    int count = 0;
                    do {
                        out.write(buffer, 0, count);
                    } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
                    Object var8_9 = null;
                    if (bis == null) break block26;
                    try {
                        bis.close();
                    }
                    catch (IOException ioex2222) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioex2222) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioex2222) {
                        // empty catch block
                    }
                }
                if (zIn != null) {
                    try {
                        zIn.close();
                    }
                    catch (IOException ioex2222) {}
                }
                break block29;
                {
                    catch (IOException ioe) {
                        String msg = "Problem expanding bzip2 " + ioe.getMessage();
                        throw new ArchiverException(msg, ioe);
                    }
                }
                catch (Throwable throwable) {
                    IOException ioex2222;
                    Object var8_10 = null;
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ioex2222) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioex2222) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioex2222) {
                            // empty catch block
                        }
                    }
                    if (zIn != null) {
                        try {
                            zIn.close();
                        }
                        catch (IOException ioex2222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    public static CBZip2InputStream getBZip2InputStream(InputStream bis) throws IOException {
        int b = bis.read();
        if (b != 66) {
            return null;
        }
        b = bis.read();
        if (b != 90) {
            return null;
        }
        return new CBZip2InputStream(bis);
    }

    protected void execute(String path, File outputDirectory) {
        throw new UnsupportedOperationException("Targeted extraction not supported in BZIP2 format.");
    }
}

