/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.steps;

import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class HtmlParserMessage
implements Comparable {
    private int fColumn;
    private int fLine;
    private String fMessage;
    private Type fType;
    private URL fUrl;
    private volatile int fHash;

    public HtmlParserMessage(Type type, URL url, String strMessage, int iLine, int iColumn) {
        this.fType = type;
        this.fUrl = url;
        this.fMessage = strMessage;
        this.fLine = iLine;
        this.fColumn = iColumn;
    }

    public int compareTo(Object o) {
        HtmlParserMessage other = (HtmlParserMessage)o;
        int iRep = this.getURL().toString().compareTo(other.getURL().toString());
        if (iRep != 0) {
            return iRep;
        }
        iRep = this.getLine() - other.getLine();
        if (iRep != 0) {
            return iRep;
        }
        iRep = this.getColumn() - other.getColumn();
        if (iRep != 0) {
            return iRep;
        }
        iRep = this.getType().compareTo(other.getType());
        if (iRep != 0) {
            return iRep;
        }
        return this.getMessage().compareTo(other.getMessage());
    }

    public int hashCode() {
        if (this.fHash == 0) {
            this.fHash = this.calculateHash();
        }
        return this.fHash;
    }

    private int calculateHash() {
        int h1 = 3 * new Integer(this.fColumn).hashCode();
        int h2 = 5 * new Integer(this.fLine).hashCode();
        int h3 = 7 * this.fMessage.hashCode();
        int h4 = 11 * this.fType.hashCode();
        int h5 = 13 * this.fUrl.hashCode();
        return h1 + h2 + h3 + h4 + h5;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public int getColumn() {
        return this.fColumn;
    }

    public int getLine() {
        return this.fLine;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public Type getType() {
        return this.fType;
    }

    public URL getURL() {
        return this.fUrl;
    }

    public static class MessageCollector
    implements HTMLParserListener {
        private List fMessages = new ArrayList();

        public void error(String message, URL url, int line, int column, String key) {
            this.fMessages.add(new HtmlParserMessage(Type.ERROR, url, message, line, column));
        }

        public void warning(String message, URL url, int line, int column, String key) {
            this.fMessages.add(new HtmlParserMessage(Type.WARNING, url, message, line, column));
        }

        public List popAll() {
            List l = this.fMessages;
            this.fMessages = new ArrayList();
            return l;
        }
    }

    public static final class Type
    implements Comparable {
        public static final String ERROR_NAME = "error";
        public static final String WARNING_NAME = "warning";
        public static final Type ERROR = new Type("error");
        public static final Type WARNING = new Type("warning");
        private String fName;

        private Type(String str) {
            this.fName = str;
        }

        public int compareTo(Object o) {
            Type other = (Type)o;
            if (this.getName().equals(other.getName())) {
                return 0;
            }
            return this.isError() ? 1 : -1;
        }

        public String getName() {
            return this.fName;
        }

        public boolean isError() {
            return ERROR_NAME.equals(this.getName());
        }

        public boolean isWarning() {
            return WARNING_NAME.equals(this.getName());
        }

        public String toString() {
            return this.getName();
        }
    }
}

