/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart;

import com.sun.tools.apache.ant.pack200.Pack200Task;
import com.sun.tools.apache.ant.pack200.Unpack200Task;
import java.io.File;
import java.io.FileFilter;
import org.apache.tools.ant.Project;

public class Pack200 {
    public static void packJars(File directory, FileFilter jarFileFilter, boolean gzip) {
        File[] jarFiles = directory.listFiles(jarFileFilter);
        for (int i = 0; i < jarFiles.length; ++i) {
            String extension = gzip ? ".pack.gz" : ".pack";
            File pack200Jar = new File(jarFiles[i].getParentFile(), jarFiles[i].getName() + extension);
            if (pack200Jar.exists()) {
                pack200Jar.delete();
            }
            Pack200Task packTask = new Pack200Task();
            packTask.setProject(new Project());
            packTask.setDestfile(pack200Jar);
            packTask.setSrc(jarFiles[i]);
            packTask.setGZIPOutput(gzip);
            packTask.setSegmentLimit("-1");
            packTask.execute();
            pack200Jar.setLastModified(jarFiles[i].lastModified());
        }
    }

    public static void unpackJars(File directory, FileFilter pack200FileFilter) {
        File[] packFiles = directory.listFiles(pack200FileFilter);
        for (int i = 0; i < packFiles.length; ++i) {
            String packedJarPath = packFiles[i].getAbsolutePath();
            int extensionLength = packedJarPath.endsWith(".jar.pack.gz") ? 8 : 5;
            String jarFileName = packedJarPath.substring(0, packedJarPath.length() - extensionLength);
            File jarFile = new File(jarFileName);
            if (jarFile.exists()) {
                jarFile.delete();
            }
            Unpack200Task unpackTask = new Unpack200Task();
            unpackTask.setProject(new Project());
            unpackTask.setDest(jarFile);
            unpackTask.setSrc(packFiles[i]);
            unpackTask.execute();
            jarFile.setLastModified(packFiles[i].lastModified());
        }
    }
}

