/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webstart.dependency;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyConfig;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequest;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequestConsumer;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyRequests;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyResult;
import org.codehaus.mojo.webstart.dependency.JnlpDependencyResults;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTask;
import org.codehaus.mojo.webstart.dependency.task.JnlpDependencyTaskException;
import org.codehaus.mojo.webstart.util.IOUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=JnlpDependencyRequestConsumer.class)
public class DefaultJnlpDependencyRequestConsumer
extends AbstractLogEnabled
implements JnlpDependencyRequestConsumer {
    @Requirement
    private IOUtil ioUtil;
    private int maxThreads;
    private boolean failFast;

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public JnlpDependencyResults execute(JnlpDependencyRequests requests) {
        List<JnlpDependencyRequest> dependencyRequests = requests.getRequests();
        this.getLogger().info("Process " + dependencyRequests.size() + " requests.");
        JnlpDependencyResults results = new JnlpDependencyResults();
        for (JnlpDependencyRequest request : dependencyRequests) {
            JnlpDependencyResult result = this.execute(request);
            results.registerResult(request, result);
            if (!this.failFast || !result.isError()) continue;
            this.getLogger().warn("Fail fast after first dependency processing error.");
            break;
        }
        return results;
    }

    protected JnlpDependencyResult execute(JnlpDependencyRequest request) {
        JnlpDependencyConfig config = request.getConfig();
        JnlpDependencyResult result = this.prepareResult(config);
        File workingDirectory = config.getWorkingDirectory();
        File workingFile = result.getOriginalfile();
        JnlpDependencyTask[] tasks = request.getTasks();
        int length = tasks.length;
        for (int i = 0; i < length; ++i) {
            JnlpDependencyTask task = tasks[i];
            File newDirectory = new File(workingDirectory, i + "_" + task.getClass().getSimpleName());
            try {
                this.ioUtil.copyFileToDirectoryIfNecessary(workingFile, newDirectory);
            }
            catch (MojoExecutionException e) {
                result.setError((Exception)((Object)e));
                break;
            }
            workingFile = new File(newDirectory, workingFile.getName());
            this.getLogger().debug(String.format("[task %s] (%s): workingFile: %s", i, task, workingFile));
            try {
                workingFile = task.execute(config, workingFile);
                continue;
            }
            catch (JnlpDependencyTaskException e) {
                result.setError(e);
                break;
            }
        }
        this.finalizeResult(config, workingFile, result);
        this.getLogger().info("Dependency " + config.getArtifact().getId() + " treated.");
        return result;
    }

    private JnlpDependencyResult prepareResult(JnlpDependencyConfig config) {
        File workingDirectory = config.getWorkingDirectory();
        Artifact artifact = config.getArtifact();
        File incomingFile = artifact.getFile();
        String fileName = config.getDependencyFilenameStrategy().getDependencyFilename(artifact, false);
        File workingFile = new File(workingDirectory, fileName);
        JnlpDependencyResult result = new JnlpDependencyResult(artifact, workingFile);
        this.copyFile(incomingFile, workingFile, result);
        return result;
    }

    private void finalizeResult(JnlpDependencyConfig config, File workingFile, JnlpDependencyResult result) {
        File finalDirectory = config.getFinalDirectory();
        String filename = config.getDependencyFilenameStrategy().getDependencyFilename(config.getArtifact(), config.isOutputJarVersion());
        if (config.isPack200()) {
            filename = filename + ".pack";
        }
        if (config.isGzip()) {
            filename = filename + ".gz";
        }
        File finalFile = new File(finalDirectory, filename);
        this.copyFile(workingFile, finalFile, result);
        result.setFinalFile(finalFile);
    }

    private void copyFile(File source, File destination, JnlpDependencyResult result) {
        this.getLogger().debug("Copy " + source.getName() + " to " + destination);
        try {
            this.ioUtil.copyFile(source, destination);
        }
        catch (MojoExecutionException e) {
            result.setError((Exception)((Object)e));
        }
    }
}

