/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.webminifier;

import com.google.javascript.jscomp.CompilationLevel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.webminifier.AbstractCompressor;
import org.codehaus.mojo.webminifier.DocumentResourceReplacer;
import org.codehaus.mojo.webminifier.ExceptionState;
import org.codehaus.mojo.webminifier.closure.ClosureJsCompressor;
import org.codehaus.mojo.webminifier.yui.YuiJsCompressor;
import org.codehaus.plexus.util.DirectoryScanner;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebMinifierMojo
extends AbstractMojo {
    private File sourceFolder;
    private File destinationFolder;
    private List<String> htmlIncludes;
    private List<String> htmlExcludes;
    private Properties jsSplitPoints;
    private String encoding;
    private JsCompressorType jsCompressorType;
    private int yuiLinebreak;
    private boolean yuiDisableOptimizations;
    private boolean yuiMunge;
    private boolean yuiPreserveSemi;
    private CompilationLevel closureCompilationLevel;
    private boolean closureAcceptConstKeyword;
    private File projectSourceFolder;
    private boolean splitDependencies;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatenateFile(File inputFile, File outputFile) throws IOException {
        FileInputStream is = new FileInputStream(inputFile);
        try {
            FileOutputStream os = new FileOutputStream(outputFile, true);
            try {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Concatenating file: " + inputFile));
                }
                IOUtils.copy((InputStream)is, (OutputStream)os);
                ((OutputStream)os).write(59);
                ((OutputStream)os).write(10);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileUtils.deleteQuietly((File)this.destinationFolder);
        try {
            FileUtils.copyDirectory((File)this.sourceFolder, (File)this.destinationFolder);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot copy file to target folder", (Exception)e);
        }
        int minifiedCounter = 0;
        HashSet<File> existingConcatenatedJsResources = new HashSet<File>();
        HashSet<File> consumedJsResources = new HashSet<File>();
        for (String targetHTMLFile : this.getArrayOfTargetHTMLFiles()) {
            ListIterator<File> concatenatedJsResourcesIter;
            int jsDependencyProjectResourcesIndex;
            DocumentResourceReplacer replacer;
            File targetHTML = new File(this.destinationFolder, targetHTMLFile);
            try {
                replacer = new DocumentResourceReplacer(targetHTML);
            }
            catch (SAXException e) {
                throw new MojoExecutionException("Problem reading html document", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem opening html document", (Exception)e);
            }
            List<File> jsResources = replacer.findJSResources();
            if (this.jsSplitPoints == null) {
                this.jsSplitPoints = new Properties();
            }
            File concatenatedJsResource = null;
            URI destinationFolderUri = this.destinationFolder.toURI();
            if (this.splitDependencies) {
                ArrayList<File> jsDependencyResources = new ArrayList<File>(jsResources.size());
                ArrayList<File> jsProjectResources = new ArrayList<File>(jsResources.size());
                for (File jsResource : jsResources) {
                    String jsResourceUri = destinationFolderUri.relativize(jsResource.toURI()).toString();
                    File jsResourceFile = new File(this.projectSourceFolder, jsResourceUri);
                    if (jsResourceFile.exists()) {
                        jsProjectResources.add(jsResource);
                        continue;
                    }
                    jsDependencyResources.add(jsResource);
                }
                jsDependencyProjectResourcesIndex = jsDependencyResources.size();
                jsResources = jsDependencyResources;
                jsResources.addAll(jsProjectResources);
            } else {
                jsDependencyProjectResourcesIndex = 0;
            }
            LinkedHashMap<File, File> jsResourceTargetFiles = new LinkedHashMap<File, File>(jsResources.size());
            ListIterator<File> jsResourcesIter = jsResources.listIterator(jsResources.size());
            boolean splittingDependencies = false;
            while (jsResourcesIter.hasPrevious()) {
                int jsResourceIterIndex = jsResourcesIter.previousIndex();
                File jsResource = jsResourcesIter.previous();
                String candidateSplitPointNameUri = destinationFolderUri.relativize(jsResource.toURI()).toString();
                String splitPointName = (String)this.jsSplitPoints.get(candidateSplitPointNameUri);
                if (this.splitDependencies && splitPointName == null && !splittingDependencies && jsResourceIterIndex < jsDependencyProjectResourcesIndex) {
                    splitPointName = Integer.valueOf(++minifiedCounter).toString();
                    splittingDependencies = true;
                }
                if (splitPointName == null && concatenatedJsResource == null) {
                    splitPointName = Integer.valueOf(++minifiedCounter).toString();
                }
                if (splitPointName != null && (concatenatedJsResource = new File(this.destinationFolder, splitPointName + ".js")).exists()) {
                    existingConcatenatedJsResources.add(concatenatedJsResource);
                }
                jsResourceTargetFiles.put(jsResource, concatenatedJsResource);
            }
            for (File jsResource : jsResources) {
                concatenatedJsResource = (File)jsResourceTargetFiles.get(jsResource);
                if (existingConcatenatedJsResources.contains(concatenatedJsResource)) continue;
                try {
                    this.concatenateFile(jsResource, concatenatedJsResource);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Problem concatenating JS files", (Exception)e);
                }
                consumedJsResources.add(jsResource);
            }
            LinkedHashSet concatenatedJsResourcesSet = new LinkedHashSet(jsResourceTargetFiles.values());
            File[] concatenatedJsResourcesArray = new File[concatenatedJsResourcesSet.size()];
            concatenatedJsResourcesSet.toArray(concatenatedJsResourcesArray);
            List<File> concatenatedJsResources = Arrays.asList(concatenatedJsResourcesArray);
            if (this.jsCompressorType != JsCompressorType.NONE) {
                ArrayList<File> minifiedJSResources = new ArrayList<File>(concatenatedJsResources.size());
                concatenatedJsResourcesIter = concatenatedJsResources.listIterator(concatenatedJsResources.size());
                while (concatenatedJsResourcesIter.hasPrevious()) {
                    boolean warningsFound;
                    File minifiedJSResource;
                    concatenatedJsResource = concatenatedJsResourcesIter.previous();
                    try {
                        String uri = concatenatedJsResource.toURI().toString();
                        int i = uri.lastIndexOf(".js");
                        String minUri = i > -1 ? uri.substring(0, i) + "-min.js" : uri;
                        minifiedJSResource = FileUtils.toFile((URL)new URL(minUri));
                    }
                    catch (MalformedURLException e) {
                        throw new MojoExecutionException("Problem determining file URL", (Exception)e);
                    }
                    minifiedJSResources.add(minifiedJSResource);
                    if (existingConcatenatedJsResources.contains(concatenatedJsResource)) continue;
                    try {
                        warningsFound = this.minifyJSFile(concatenatedJsResource, minifiedJSResource);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Problem reading/writing JS", (Exception)e);
                    }
                    this.logCompressionRatio(minifiedJSResource.getName(), concatenatedJsResource.length(), minifiedJSResource.length());
                    if (!warningsFound) continue;
                    this.getLog().warn((CharSequence)("Warnings were found. " + concatenatedJsResource + " is available for your further investigations."));
                }
                replacer.replaceJSResources(this.destinationFolder, targetHTML, minifiedJSResources);
            } else {
                ArrayList<File> unminifiedJSResources = new ArrayList<File>(concatenatedJsResources.size());
                concatenatedJsResourcesIter = concatenatedJsResources.listIterator(concatenatedJsResources.size());
                while (concatenatedJsResourcesIter.hasPrevious()) {
                    concatenatedJsResource = concatenatedJsResourcesIter.previous();
                    unminifiedJSResources.add(concatenatedJsResource);
                }
                replacer.replaceJSResources(this.destinationFolder, targetHTML, unminifiedJSResources);
                this.getLog().info((CharSequence)"Concatenated resources with no compression");
            }
            try {
                replacer.writeHTML(targetHTML, this.encoding);
            }
            catch (TransformerException e) {
                throw new MojoExecutionException("Problem transforming html", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem writing html", (Exception)e);
            }
        }
        for (File consumedJsResource : consumedJsResources) {
            consumedJsResource.delete();
        }
        this.removeEmptyFolders(this.destinationFolder);
    }

    private String[] getArrayOfTargetHTMLFiles() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.destinationFolder);
        String[] includesArray = this.getPatternsOrDefault(this.htmlIncludes, this.getDefaultIncludes());
        scanner.setIncludes(includesArray);
        String[] excludesArray = this.getPatternsOrDefault(this.htmlExcludes, this.getDefaultExcludes());
        scanner.setExcludes(excludesArray);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        return includedFiles;
    }

    protected String[] getDefaultExcludes() {
        return new String[0];
    }

    protected String[] getDefaultIncludes() {
        return new String[]{"**/*.html", "**/*.htm"};
    }

    public File getDestinationFolder() {
        return this.destinationFolder;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public List<String> getHtmlExcludes() {
        return this.htmlExcludes;
    }

    public List<String> getHtmlIncludes() {
        return this.htmlIncludes;
    }

    public JsCompressorType getJsCompressorType() {
        return this.jsCompressorType;
    }

    public Properties getJsSplitPoints() {
        return this.jsSplitPoints;
    }

    private String[] getPatternsOrDefault(List<String> patterns, String[] defaultPatterns) {
        if (patterns == null || patterns.isEmpty()) {
            return defaultPatterns;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public File getProjectSourceFolder() {
        return this.projectSourceFolder;
    }

    public File getSourceFolder() {
        return this.sourceFolder;
    }

    public int getYuiLinebreak() {
        return this.yuiLinebreak;
    }

    public boolean isSplitDependencies() {
        return this.splitDependencies;
    }

    public boolean isYuiDisableOptimizations() {
        return this.yuiDisableOptimizations;
    }

    public boolean isYuiMunge() {
        return this.yuiMunge;
    }

    public boolean isYuiPreserveSemi() {
        return this.yuiPreserveSemi;
    }

    private void logCompressionRatio(String filename, long original, long changed) {
        String percentageString;
        if (original > 0L) {
            int sizePercentage = (int)(Double.valueOf(changed) / Double.valueOf(original) * 100.0);
            percentageString = sizePercentage + "%";
        } else {
            percentageString = "-";
        }
        this.getLog().info((CharSequence)(filename + " minified from " + Long.valueOf(original) + " to " + Long.valueOf(changed) + " bytes (" + percentageString + " of original size)"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean minifyJSFile(File source, File target) throws IOException, MojoExecutionException {
        boolean warningsFound = false;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        try {
            FileOutputStream os = new FileOutputStream(target);
            try {
                AbstractCompressor compressor;
                switch (this.jsCompressorType) {
                    case YUI: {
                        compressor = new YuiJsCompressor(is, os, this.encoding, this.getLog());
                        ((YuiJsCompressor)compressor).setOptions(this.yuiLinebreak, this.yuiMunge, this.yuiPreserveSemi, this.yuiDisableOptimizations);
                        break;
                    }
                    case CLOSURE: {
                        compressor = new ClosureJsCompressor(is, os, this.encoding, this.getLog());
                        ((ClosureJsCompressor)compressor).setOptions(this.closureCompilationLevel, this.closureAcceptConstKeyword);
                        break;
                    }
                    default: {
                        assert (false);
                        compressor = null;
                    }
                }
                if (compressor != null) {
                    compressor.compress();
                    ExceptionState exceptionState = compressor.getExceptionState();
                    if (exceptionState.hasErrors()) {
                        throw new MojoExecutionException("Problem(s) prevented compression from completing.");
                    }
                    warningsFound = exceptionState.hasWarnings();
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
        return warningsFound;
    }

    private void removeEmptyFolders(File folder) {
        File[] files = folder.listFiles();
        boolean folderHasFile = false;
        for (File file : files) {
            if (file.isDirectory()) {
                this.removeEmptyFolders(file);
                continue;
            }
            folderHasFile = true;
        }
        if (!folderHasFile) {
            folder.delete();
        }
    }

    public void setDestinationFolder(File destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setHtmlExcludes(List<String> htmlExcludes) {
        this.htmlExcludes = htmlExcludes;
    }

    public void setHtmlIncludes(List<String> htmlIncludes) {
        this.htmlIncludes = htmlIncludes;
    }

    public void setJsCompressorType(JsCompressorType jsCompressorType) {
        this.jsCompressorType = jsCompressorType;
    }

    public void setJsSplitPoints(Properties jsSplitPoints) {
        this.jsSplitPoints = jsSplitPoints;
    }

    public void setProjectSourceFolder(File projectSourceFolder) {
        this.projectSourceFolder = projectSourceFolder;
    }

    public void setSourceFolder(File sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setSplitDependencies(boolean splitDependencies) {
        this.splitDependencies = splitDependencies;
    }

    public void setYuiDisableOptimizations(boolean yuiDisableOptimizations) {
        this.yuiDisableOptimizations = yuiDisableOptimizations;
    }

    public void setYuiLinebreak(int yuiLinebreak) {
        this.yuiLinebreak = yuiLinebreak;
    }

    public void setYuiMunge(boolean yuiMunge) {
        this.yuiMunge = yuiMunge;
    }

    public void setYuiPreserveSemi(boolean yuiPreserveSemi) {
        this.yuiPreserveSemi = yuiPreserveSemi;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JsCompressorType {
        YUI,
        CLOSURE,
        NONE;

    }
}

