/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:wagon-maven-plugin:1.0-beta-4", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Wagon plugin", 0);
        this.append(sb, "Maven 2 plugin that can be used to access various operations on a given URL using a supported maven wagon. Supports recursive upload, download, and list directory content functionality.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "copy".equals(this.goal)) {
            this.append(sb, "wagon:copy", 0);
            this.append(sb, "Copy artifacts from one Wagon repository to another Wagon repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "caseSensitive", 2);
                this.append(sb, "Whether to consider remote path case sensitivity during scan", 3);
                this.append(sb, "Expression: ${wagon.caseSensitive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of Ant's excludes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDir", 2);
                this.append(sb, "Directory path relative to source's Wagon", 3);
                this.append(sb, "Expression: ${wagon.fromDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: **)", 2);
                this.append(sb, "Comma separated list of Ant's includes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: false)", 2);
                this.append(sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle. This only works with SCP's URL", 3);
                this.append(sb, "Expression: ${wagon.optimize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "source", 2);
                this.append(sb, "The URL to the source repository.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.source}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceId (Default: source)", 2);
                this.append(sb, "settings.xml's server id of the source repository. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.sourceId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "The URL to the target repository.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetId (Default: target)", 2);
                this.append(sb, "settings.xml's server id of the target repository. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.targetId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toDir", 2);
                this.append(sb, "Remote path relative to target's url to copy files to.", 3);
                this.append(sb, "Expression: ${wagon.toDir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "download".equals(this.goal)) {
            this.append(sb, "wagon:download", 0);
            this.append(sb, "Transfers a set of files from a remote URL to a specified local directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "caseSensitive (Default: true)", 2);
                this.append(sb, "Whether to consider remote path case sensitivity during scan", 3);
                this.append(sb, "Expression: ${wagon.caseSensitive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of Ant's excludes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDir", 2);
                this.append(sb, "Directory path relative to Wagon's URL", 3);
                this.append(sb, "Expression: ${wagon.fromDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: *)", 2);
                this.append(sb, "Comma separated list of Ant's includes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toDir (Default: ${project.build.directory}/wagon-plugin)", 2);
                this.append(sb, "Local directory to download the remote resource ( tree ) to.", 3);
                this.append(sb, "Expression: ${wagon.toDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "download-single".equals(this.goal)) {
            this.append(sb, "wagon:download-single", 0);
            this.append(sb, "Download a single file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fromFile", 2);
                this.append(sb, "Relative path to the URL.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.fromFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toDir", 2);
                this.append(sb, "Directory to download the remote file to", 3);
                this.append(sb, "Expression: ${wagon.toDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toFile", 2);
                this.append(sb, "File to download the remote file to. Use this option to rename the file after download. When toDir is present, this argument is ignored", 3);
                this.append(sb, "Expression: ${wagon.toFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "exist".equals(this.goal)) {
            this.append(sb, "wagon:exist", 0);
            this.append(sb, "Check for the existing of remote resource.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "resource", 2);
                this.append(sb, "relative path to a remote resource", 3);
                this.append(sb, "Expression: ${wagon.resource}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "wagon:help", 0);
            this.append(sb, "Display help information on wagon-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0wagon:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "list".equals(this.goal)) {
            this.append(sb, "wagon:list", 0);
            this.append(sb, "Lists the content of the specified directory (remotePath) under a specified repository (url)", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "caseSensitive (Default: true)", 2);
                this.append(sb, "Whether to consider remote path case sensitivity during scan", 3);
                this.append(sb, "Expression: ${wagon.caseSensitive}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separated list of Ant's excludes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDir", 2);
                this.append(sb, "Directory path relative to Wagon's URL", 3);
                this.append(sb, "Expression: ${wagon.fromDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes (Default: *)", 2);
                this.append(sb, "Comma separated list of Ant's includes to scan for remote files", 3);
                this.append(sb, "Expression: ${wagon.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "merge-maven-repos".equals(this.goal)) {
            this.append(sb, "wagon:merge-maven-repos", 0);
            this.append(sb, "Merge artifacts from one Maven repository to another Maven repository.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: false)", 2);
                this.append(sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle. This only works with SCP's URL", 3);
                this.append(sb, "Expression: ${wagon.optimize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "source", 2);
                this.append(sb, "The URL to the source repository.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.source}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceId (Default: source)", 2);
                this.append(sb, "settings.xml's server id of the source repository. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.sourceId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "target", 2);
                this.append(sb, "The URL to the target repository.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.target}", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetId (Default: target)", 2);
                this.append(sb, "settings.xml's server id of the target repository. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.targetId}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "upload".equals(this.goal)) {
            this.append(sb, "wagon:upload", 0);
            this.append(sb, "Upload multiple sets of files.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Comma separate list of Ant's excludes to scan for local files", 3);
                this.append(sb, "Expression: ${wagon.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "followSymLink (Default: false)", 2);
                this.append(sb, "Follow local symbolic link if possible", 3);
                this.append(sb, "Expression: ${wagon.followSymLink}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fromDir (Default: ${project.basedir})", 2);
                this.append(sb, "Local directory to upload to wagon's 'url/toDir'", 3);
                this.append(sb, "Expression: ${wagon.fromDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Comma separate list of Ant's includes to scan for local files", 3);
                this.append(sb, "Expression: ${wagon.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "optimize (Default: false)", 2);
                this.append(sb, "Optimize the upload by locally compressed all files in one bundle, upload the bundle, and finally remote uncompress the bundle.", 3);
                this.append(sb, "Expression: ${wagon.optimize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toDir", 2);
                this.append(sb, "Remote path relative to Wagon's url to upload local files to.", 3);
                this.append(sb, "Expression: ${wagon.toDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultExcludes (Default: true)", 2);
                this.append(sb, "Use default exclude sets", 3);
                this.append(sb, "Expression: ${wagon.useDefaultExcludes}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "upload-single".equals(this.goal)) {
            this.append(sb, "wagon:upload-single", 0);
            this.append(sb, "Upload a single file with option to change name", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "fromFile", 2);
                this.append(sb, "Path to a local file to be uploaded", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.fromFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "serverId (Default: serverId)", 2);
                this.append(sb, "settings.xml's server id for the URL. This is used when wagon needs extra authentication information.", 3);
                this.append(sb, "Expression: ${wagon.serverId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "When true, skip the execution.", 3);
                this.append(sb, "Expression: ${wagon.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "toFile", 2);
                this.append(sb, "Relative path to the URL. When blank, default to fromFile's file name.", 3);
                this.append(sb, "Expression: ${wagon.toFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "url", 2);
                this.append(sb, "URL to upload to or download from or list. Must exist and point to a directory.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${wagon.url}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

