/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.AbstractDoubleWagonMojo;

public abstract class AbstractCopyMojo
extends AbstractDoubleWagonMojo {
    protected abstract void copy(Wagon var1, Wagon var2) throws IOException, WagonException;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution.");
            return;
        }
        Wagon srcWagon = null;
        Wagon targetWagon = null;
        try {
            srcWagon = this.createWagon(this.sourceId, this.source);
            targetWagon = this.createWagon(this.targetId, this.target);
            this.copy(srcWagon, targetWagon);
            this.disconnectWagon(srcWagon);
            this.disconnectWagon(targetWagon);
        }
        catch (Exception e) {
            try {
                throw new MojoExecutionException("Error during performing repository copy", e);
            }
            catch (Throwable throwable) {
                this.disconnectWagon(srcWagon);
                this.disconnectWagon(targetWagon);
                throw throwable;
            }
        }
    }

    private void disconnectWagon(Wagon wagon) {
        try {
            if (wagon != null) {
                wagon.disconnect();
            }
        }
        catch (ConnectionException e) {
            this.getLog().debug((CharSequence)"Error disconnecting wagon - ignored", (Throwable)e);
        }
    }
}

