/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ArtifactVersionService {
    private static final int MAX_CACHE_SIZE = 512;
    private static final Map<String, DefaultArtifactVersion> CACHE = new LRUMap(512);
    private static final ReentrantReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArtifactVersion getArtifactVersion(String version) {
        try {
            CACHE_LOCK.readLock().lock();
            DefaultArtifactVersion result = CACHE.get(version);
            if (result != null) {
                DefaultArtifactVersion defaultArtifactVersion = result;
                return defaultArtifactVersion;
            }
        }
        finally {
            CACHE_LOCK.readLock().unlock();
        }
        try {
            CACHE_LOCK.writeLock().lock();
            ArtifactVersion artifactVersion = (ArtifactVersion)CACHE.computeIfAbsent(version, DefaultArtifactVersion::new);
            return artifactVersion;
        }
        finally {
            CACHE_LOCK.writeLock().unlock();
        }
    }
}

