/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractPluginUpdatesReportMojo;
import org.codehaus.mojo.versions.reporting.ReportRendererFactory;
import org.codehaus.mojo.versions.reporting.util.AggregateReportUtils;
import org.codehaus.plexus.i18n.I18N;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="plugin-updates-aggregate-report", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true, aggregator=true)
public class PluginUpdatesAggregateReportMojo
extends AbstractPluginUpdatesReportMojo {
    @Inject
    protected PluginUpdatesAggregateReportMojo(I18N i18n, ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, ReportRendererFactory rendererFactory) {
        super(i18n, artifactHandlerManager, repositorySystem, wagonMap, rendererFactory);
    }

    @Override
    protected void populatePluginManagement(Set<Plugin> pluginManagementCollector) {
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            if (!this.haveBuildPluginManagementPlugins(project)) continue;
            pluginManagementCollector.addAll(project.getBuild().getPluginManagement().getPlugins());
        }
    }

    @Override
    protected void populatePlugins(Set<Plugin> pluginsCollector) {
        for (MavenProject project : AggregateReportUtils.getProjectsToProcess(this.getProject())) {
            if (!this.haveBuildPluginManagementPlugins(project)) continue;
            pluginsCollector.addAll(project.getBuild().getPlugins());
        }
    }

    @Override
    public String getOutputName() {
        return "plugin-updates-aggregate-report";
    }
}

