/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.unix.rpm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.mojo.unix.HasRelaxedEquality;
import org.codehaus.mojo.unix.util.SystemCommand;
import org.codehaus.plexus.util.StringUtils;

public class RpmUtil {
    private static final String EOL = System.getProperty("line.separator");
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd HH:mm");

    public static List queryPackageForFileInfo(File rpm) throws IOException {
        RpmQueryParser parser = new RpmQueryParser();
        new SystemCommand().withStdoutConsumer((SystemCommand.LineConsumer)parser).setCommand("rpm").addArgument("--package").addArgument(rpm.getAbsolutePath()).addArgument("-q").addArgument("-l").addArgument("-v").execute().assertSuccess();
        return parser.getList();
    }

    public static SpecFile getSpecFileFromRpm(File rpm) throws IOException {
        RpmSpecParser parser = new RpmSpecParser();
        new SystemCommand().dumpCommandIf(true).withStdoutConsumer((SystemCommand.LineConsumer)parser).withStderrConsumer((OutputStream)System.err).setCommand("rpm").addArgument("--query").addArgument("--queryformat").addArgument("%{NAME}\\n%{VERSION}\\n%{RELEASE}\\n%{SUMMARY}\\n%{LICENSE}\\n%{GROUP}\\n").addArgument("--package").addArgument(rpm.getAbsolutePath()).execute().assertSuccess();
        ByteArrayOutputStream description = new ByteArrayOutputStream();
        new SystemCommand().dumpCommandIf(true).withStdoutConsumer((OutputStream)description).withStderrConsumer((OutputStream)System.err).setCommand("rpm").addArgument("--query").addArgument("--queryformat").addArgument("%{DESCRIPTION}").addArgument("--package").addArgument(rpm.getAbsolutePath()).execute().assertSuccess();
        return new SpecFile(parser.name, parser.version, parser.release, parser.summary, parser.license, parser.group, description.toString());
    }

    private static class RpmSpecParser
    implements SystemCommand.LineConsumer {
        public String name;
        public String version;
        public int release;
        public String summary;
        public String license;
        public String group;
        private int count;

        private RpmSpecParser() {
        }

        public void onLine(String line) throws IOException {
            switch (this.count++) {
                case 0: {
                    this.name = line;
                    break;
                }
                case 1: {
                    this.version = line;
                    break;
                }
                case 2: {
                    this.release = Integer.parseInt(line);
                    break;
                }
                case 3: {
                    this.summary = line;
                    break;
                }
                case 4: {
                    this.license = line;
                    break;
                }
                case 5: {
                    this.group = line;
                }
            }
        }
    }

    private static class RpmQueryParser
    implements SystemCommand.LineConsumer {
        private List list = new ArrayList();

        private RpmQueryParser() {
        }

        public void onLine(String line) throws IOException {
            String[] parts = line.replaceAll(" +", " ").split(" ");
            try {
                this.list.add(new FileInfo(parts[8].trim(), parts[2].trim(), parts[3].trim(), parts[0].trim(), Integer.parseInt(parts[4].trim()), DATE_FORMAT.parse(parts[5] + " " + parts[6] + " " + parts[7])));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }

        public List getList() {
            return this.list;
        }
    }

    public static final class SpecFile
    implements HasRelaxedEquality {
        public String name;
        public String version;
        public int release;
        public String summary;
        public String license;
        public String group;
        public String description;

        public SpecFile(String name, String version, int release, String summary, String license, String group, String description) {
            this.name = name;
            this.version = version;
            this.release = release;
            this.summary = summary;
            this.license = license;
            this.group = group;
            this.description = description;
        }

        public boolean equalsIgnoreNull(HasRelaxedEquality other) {
            SpecFile that = (SpecFile)other;
            return this.name.equals(that.name) && this.version.equals(that.version) && this.release == that.release && this.summary.equals(that.summary) && this.license.equals(that.license) && this.group.equals(that.group) && (this.description == null || this.description.equals(that.description));
        }

        public String toString() {
            return "Name: " + this.name + EOL + "Version: " + this.version + EOL + "Release: " + this.release + EOL + "Summary: " + this.summary + EOL + "License: " + this.license + EOL + "Group: " + this.group + EOL + EOL + "%description " + EOL + StringUtils.clean((String)this.description);
        }
    }

    public static final class FileInfo
    implements HasRelaxedEquality {
        public final String path;
        public final String user;
        public final String group;
        public final String mode;
        public final int size;
        public final Date date;

        public FileInfo(String path, String user, String group, String mode, int size, Date date) {
            this.path = path;
            this.user = user;
            this.group = group;
            this.mode = mode;
            this.size = size;
            this.date = date;
        }

        public boolean equalsIgnoreNull(HasRelaxedEquality other) {
            FileInfo that = (FileInfo)other;
            return this.size == that.size && (this.date == null || this.date.equals(that.date)) && this.group.equals(that.group) && this.mode.equals(that.mode) && this.path.equals(that.path) && this.user.equals(that.user);
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo that = (FileInfo)o;
            return this.path.equals(that.path);
        }

        public final int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return this.mode + " " + this.user + " " + this.group + " " + this.size + " " + (this.date != null ? DATE_FORMAT.format(this.date) : "not set") + " " + this.path;
        }
    }
}

