/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.truezip;

import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.mojo.truezip.AbstractManipulateArchiveMojo;
import org.codehaus.mojo.truezip.Fileset;
import org.codehaus.mojo.truezip.TrueZipFileSet;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class ListMojo
extends AbstractManipulateArchiveMojo {
    private File outputFile;
    private boolean printFullPath = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip this execution");
            return;
        }
        super.execute();
        this.intitializeArchiveDectector();
        PrintStream ps = System.out;
        FileOutputStream os = null;
        if (this.outputFile != null) {
            try {
                this.outputFile.getParentFile().mkdirs();
                os = new FileOutputStream(this.outputFile);
                ps = new PrintStream(os);
            }
            catch (IOException e) {
                throw new MojoFailureException(e.getMessage());
            }
        }
        try {
            this.processFileSets(ps);
        }
        finally {
            IOUtil.close(os);
        }
        this.tryImmediateUpdate();
    }

    private void processFileSets(PrintStream ps) throws MojoExecutionException, MojoFailureException {
        if (this.fileset != null) {
            this.filesets.add(this.fileset);
            this.fileset = null;
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            Fileset fileSet = (Fileset)((Object)this.filesets.get(i));
            if (StringUtils.isBlank((String)fileSet.getDirectory())) {
                fileSet.setDirectory(this.project.getBasedir().getAbsolutePath());
            }
            this.resolveRelativePath((FileSet)fileSet);
            List fileList = this.truezip.list((TrueZipFileSet)this.filesets.get(i));
            for (int j = 0; j < fileList.size(); ++j) {
                TFile file = (TFile)fileList.get(j);
                if (this.printFullPath) {
                    ps.println(file.getPath());
                    continue;
                }
                int startPos = fileSet.getDirectory().length() + 1;
                ps.println(file.getPath().substring(startPos));
            }
        }
    }
}

