/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.shared.keytool;

import java.io.File;
import org.codehaus.mojo.shared.keytool.CommandLineConfigurationException;
import org.codehaus.mojo.shared.keytool.KeyToolExportRequest;
import org.codehaus.mojo.shared.keytool.KeyToolGenKeyRequest;
import org.codehaus.mojo.shared.keytool.KeyToolImportRequest;
import org.codehaus.mojo.shared.keytool.KeyToolRequest;
import org.codehaus.mojo.shared.keytool.KeyToolUtil;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class KeyToolCommandLineBuilder {
    private static final Logger DEFAULT_LOGGER = new ConsoleLogger(0, KeyToolCommandLineBuilder.class.getName());
    private Logger logger = DEFAULT_LOGGER;
    private String keyToolFile;

    public Commandline build(KeyToolRequest request) throws CommandLineConfigurationException {
        String[] arguments;
        this.checkRequiredState();
        Commandline cli = new Commandline();
        cli.setExecutable(this.keyToolFile);
        cli.setWorkingDirectory(request.getWorkingDirectory());
        if (request instanceof KeyToolImportRequest) {
            this.build((KeyToolImportRequest)request, cli);
        }
        if (request instanceof KeyToolGenKeyRequest) {
            this.build((KeyToolGenKeyRequest)request, cli);
        }
        if (request instanceof KeyToolExportRequest) {
            this.build((KeyToolExportRequest)request, cli);
        }
        if ((arguments = request.getArguments()) != null) {
            cli.addArguments(arguments);
        }
        return cli;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setKeyToolFile(String keyToolFile) {
        this.keyToolFile = keyToolFile;
    }

    protected void checkRequiredState() {
        if (this.logger == null) {
            throw new IllegalStateException("A logger instance is required.");
        }
        if (this.keyToolFile == null) {
            throw new IllegalStateException("A keyTool file is required.");
        }
    }

    protected void build(KeyToolImportRequest request, Commandline cli) {
        this.addArg(cli, "-import");
        this.addArg(cli, "-noprompt");
        if (request.isVerbose()) {
            this.addArg(cli, "-v");
        }
        this.addArgIfNotEmpty(cli, "-alias", request.getAlias());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        String keystore = request.getKeystore();
        if (StringUtils.isNotEmpty((String)keystore)) {
            this.addArgIfNotEmpty(cli, "-keystore", keystore);
        } else if (request.isUseJREcacerts()) {
            this.addArg(cli, "-keystore");
            this.addArg(cli, KeyToolUtil.getJRECACerts());
        }
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-storetype", request.getStoretype());
        this.addArgIfNotEmpty(cli, "-storepass", request.getStorepass());
    }

    protected void build(KeyToolGenKeyRequest request, Commandline cli) {
        this.addArg(cli, "-genkey");
        if (request.isVerbose()) {
            this.addArg(cli, "-v");
        }
        this.addArgIfNotEmpty(cli, "-dname", request.getDname());
        this.addArgIfNotEmpty(cli, "-alias", request.getAlias());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-keystore", request.getKeystore());
        this.addArgIfNotEmpty(cli, "-storepass", request.getStorepass());
        this.addArgIfNotEmpty(cli, "-validity", request.getValidity());
        this.addArgIfNotEmpty(cli, "-keyalg", request.getKeyalg());
        this.addArgIfNotEmpty(cli, "-keysize", request.getKeysize());
        this.addArgIfNotEmpty(cli, "-sigalg", request.getSigalg());
        this.addArgIfNotEmpty(cli, "-storetype", request.getStoretype());
    }

    protected void build(KeyToolExportRequest request, Commandline cli) {
        this.addArg(cli, "-export");
        if (request.isVerbose()) {
            this.addArg(cli, "-v");
        }
        this.addArgIfNotEmpty(cli, "-alias", request.getAlias());
        this.addArgIfNotEmpty(cli, "-file", request.getFile());
        this.addArgIfNotEmpty(cli, "-storetype", request.getStoretype());
        this.addArgIfNotEmpty(cli, "-keystore", request.getKeystore());
        this.addArgIfNotEmpty(cli, "-keypass", request.getKeypass());
        this.addArgIfNotEmpty(cli, "-storepass", request.getStorepass());
    }

    protected void addArgIfNotEmpty(Commandline cli, String key, String value) {
        if (!StringUtils.isEmpty((String)value)) {
            this.addArg(cli, key);
            this.addArg(cli, value);
        }
    }

    protected void addArg(Commandline cli, String value) {
        cli.createArg().setValue(value);
    }

    protected void addArg(Commandline cli, File value) {
        cli.createArg().setFile(value);
    }
}

