/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;

public class GetPatchesMojo
extends AbstractMojo {
    private boolean skipRetrieval;
    private List<String> urls;
    private File patchSourceDir;
    private WagonManager wagonManager;

    public void execute() throws MojoExecutionException {
        if (this.skipRetrieval) {
            this.getLog().info((CharSequence)"Skipping remote patchfile retrieval (per configuration).");
            return;
        }
        if (this.urls == null || this.urls.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to do");
            return;
        }
        if (!this.patchSourceDir.exists()) {
            this.patchSourceDir.mkdirs();
        }
        for (String url : this.urls) {
            this.retrievePatch(url);
        }
    }

    private void retrievePatch(String url) throws MojoExecutionException {
        URL sourceUrl;
        try {
            sourceUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Invalid source URL: '" + url + "'", (Exception)e);
        }
        Wagon wagon = null;
        try {
            wagon = this.wagonManager.getWagon(sourceUrl.getProtocol());
            String remotePath = sourceUrl.getPath();
            String baseUrl = url.substring(0, url.length() - remotePath.length());
            int lastSlash = remotePath.replace('\\', '/').lastIndexOf(47);
            String filename = remotePath;
            if (lastSlash > -1 && lastSlash < remotePath.length() - 1) {
                filename = remotePath.substring(lastSlash + 1);
            }
            File downloaded = new File(this.patchSourceDir, filename);
            Repository repo = new Repository("source-get", baseUrl);
            wagon.connect(repo, this.wagonManager.getAuthenticationInfo(repo.getId()), this.wagonManager.getProxy(sourceUrl.getProtocol()));
            wagon.get(remotePath, downloaded);
        }
        catch (UnsupportedProtocolException e) {
            throw new MojoExecutionException("Invalid source protocol: '" + sourceUrl.getProtocol() + "'", (Exception)((Object)e));
        }
        catch (TransferFailedException e) {
            throw new MojoExecutionException("Failed to download source from: " + url, (Exception)((Object)e));
        }
        catch (ResourceDoesNotExistException e) {
            throw new MojoExecutionException("Failed to download source from: " + url, (Exception)((Object)e));
        }
        catch (AuthorizationException e) {
            throw new MojoExecutionException("Failed to download source from: " + url, (Exception)((Object)e));
        }
        catch (ConnectionException e) {
            throw new MojoExecutionException("Failed to download source from: " + url, (Exception)((Object)e));
        }
        catch (AuthenticationException e) {
            throw new MojoExecutionException("Failed to download source from: " + url, (Exception)((Object)e));
        }
        finally {
            if (wagon != null) {
                try {
                    wagon.disconnect();
                }
                catch (ConnectionException e) {
                    this.getLog().debug((CharSequence)("Failed to disconnect wagon for: " + url), (Throwable)e);
                }
            }
        }
    }
}

