/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.patch;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.patch.AbstractPatchMojo;
import org.codehaus.mojo.patch.PatchContext;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyPatchDirectoryMojo
extends AbstractPatchMojo {
    public static final List<String> PATCH_FAILURE_WATCH_PHRASES;
    private boolean skipApplication;
    private boolean optimizations;
    private File patchTrackingFile;
    private File targetDirectory;
    private List<String> ignoredPatches;
    private boolean strictPatching;
    private int strip = 0;
    private boolean ignoreWhitespace = true;
    private boolean reverse = false;
    private boolean backups = false;
    private List<String> patchFailureWatchPhrases = PATCH_FAILURE_WATCH_PHRASES;
    private File patchDirectory;
    private File patchArtifactUnpackDirectory;
    private CommandLineManager cliManager;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipApplication) {
            this.getLog().info((CharSequence)"Skipping patchfile application (per configuration).");
            return;
        }
        this.patchTrackingFile.getParentFile().mkdirs();
        PatchContext ctx = new PatchContext();
        File patchSourceDir = ctx.getPatchDirectory(this.patchArtifactUnpackDirectory, this.patchDirectory);
        if (patchSourceDir == null) {
            throw new MojoExecutionException("Patch directory was not set. Please ensure that you have the resolve-patches mojo bound earlier in the lifecycle.\n\n(Tip: use 'mvn help:effective-pom' for more information.)");
        }
        ArrayList<String> foundPatchFiles = new ArrayList<String>(Arrays.asList(patchSourceDir.list()));
        Map<String, Commandline> patchesApplied = this.findPatchesToApply(foundPatchFiles, patchSourceDir);
        this.checkStrictPatchCompliance(foundPatchFiles);
        String output = this.applyPatches(patchesApplied);
        this.checkForWatchPhrases(output);
        this.writeTrackingFile(patchesApplied);
    }

    private Map<String, Commandline> findPatchesToApply(List<String> foundPatchFiles, File patchSourceDir) throws MojoFailureException {
        List<String> patches = this.getPatches();
        LinkedHashMap<String, Commandline> patchesApplied = new LinkedHashMap<String, Commandline>(patches.size());
        for (String patch : patches) {
            File patchFile = new File(patchSourceDir, patch);
            this.getLog().debug((CharSequence)("Looking for patch: " + patch + " in: " + patchFile));
            if (!patchFile.exists()) {
                if (this.strictPatching) {
                    throw new MojoFailureException((Object)this, "Patch operation cannot proceed.", "Cannot find specified patch: '" + patch + "' in patch-source directory: '" + patchSourceDir + "'.\n\nEither fix this error, or relax strictPatching.");
                }
                this.getLog().info((CharSequence)("Skipping patch: " + patch + " listed in the patches parameter; it is missing."));
                continue;
            }
            foundPatchFiles.remove(patch);
            patchesApplied.put(patch, this.createPatchCommand(patchFile));
        }
        return patchesApplied;
    }

    private void checkStrictPatchCompliance(List<String> foundPatchFiles) throws MojoExecutionException {
        if (this.strictPatching) {
            ArrayList<String> ignored = new ArrayList<String>();
            if (this.ignoredPatches != null) {
                ignored.addAll(this.ignoredPatches);
            }
            if (this.useDefaultIgnores()) {
                ignored.addAll(DEFAULT_IGNORED_PATCHES);
            }
            ArrayList<String> limbo = new ArrayList<String>(foundPatchFiles);
            for (String ignoredFile : ignored) {
                limbo.remove(ignoredFile);
            }
            if (!limbo.isEmpty()) {
                StringBuffer extraFileBuffer = new StringBuffer();
                extraFileBuffer.append("Found " + limbo.size() + " unlisted patch files:");
                for (String patch : foundPatchFiles) {
                    extraFileBuffer.append("\n  '").append(patch).append('\'');
                }
                extraFileBuffer.append("\n\nEither remove these files, add them to the patches configuration list, or relax strictPatching.");
                throw new MojoExecutionException(extraFileBuffer.toString());
            }
        }
    }

    private String applyPatches(Map<String, Commandline> patchesApplied) throws MojoExecutionException {
        final StringWriter outputWriter = new StringWriter();
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                if (ApplyPatchDirectoryMojo.this.getLog().isDebugEnabled()) {
                    ApplyPatchDirectoryMojo.this.getLog().debug((CharSequence)line);
                }
                outputWriter.write(line + "\n");
            }
        };
        for (Map.Entry<String, Commandline> entry : patchesApplied.entrySet()) {
            String patchName = entry.getKey();
            Commandline cli = entry.getValue();
            try {
                int result = this.cliManager.execute(cli, consumer, consumer);
                if (result == 0) continue;
                throw new MojoExecutionException("Patch command failed (exit value != 0). Please see debug output for more information.");
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to apply patch: " + patchName + ". See debug output for more information.", (Exception)((Object)e));
            }
        }
        return outputWriter.toString();
    }

    private void writeTrackingFile(Map<String, Commandline> patchesApplied) throws MojoExecutionException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.patchTrackingFile);
            Iterator<String> it = patchesApplied.keySet().iterator();
            while (it.hasNext()) {
                String patch = it.next();
                writer.write(patch);
                if (!it.hasNext()) continue;
                writer.write(System.getProperty("line.separator"));
            }
            writer.flush();
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to write patch-tracking file: " + this.patchTrackingFile, (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Writer)writer);
    }

    private void checkForWatchPhrases(String output) throws MojoExecutionException {
        for (String phrase : this.patchFailureWatchPhrases) {
            if (output.indexOf(phrase) <= -1) continue;
            throw new MojoExecutionException("Failed to apply patches (detected watch-phrase: '" + phrase + "' in output). " + "If this is in error, configure the patchFailureWatchPhrases parameter.");
        }
    }

    private Commandline createPatchCommand(File patchFile) {
        Commandline cli = new Commandline((Shell)new BourneShell());
        cli.setExecutable("patch");
        cli.setWorkingDirectory(this.targetDirectory.getAbsolutePath());
        cli.createArg().setLine("-p" + this.strip);
        if (this.ignoreWhitespace) {
            cli.createArg().setValue("-l");
        }
        if (this.reverse) {
            cli.createArg().setValue("-R");
        }
        if (this.backups) {
            cli.createArg().setValue("-b");
        }
        cli.createArg().setLine("--input=" + patchFile.getAbsolutePath());
        return cli;
    }

    static {
        ArrayList<String> watches = new ArrayList<String>();
        watches.add("fail");
        watches.add("skip");
        watches.add("reject");
        PATCH_FAILURE_WATCH_PHRASES = watches;
    }
}

