/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.netbeans.nbbuild.JarWithModuleAttributes;
import org.netbeans.nbbuild.ModuleType;
import org.netbeans.nbbuild.ParseProjectXml;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ModuleListParser {
    private static Map<File, Map<String, Entry>> SOURCE_SCAN_CACHE = new HashMap<File, Map<String, Entry>>();
    private static Map<File, Map<String, Entry>> SUITE_SCAN_CACHE = new HashMap<File, Map<String, Entry>>();
    private static Map<File, Entry> STANDALONE_SCAN_CACHE = new HashMap<File, Entry>();
    private static Map<File, Map<String, Entry>> BINARY_SCAN_CACHE = new HashMap<File, Map<String, Entry>>();
    private static final String[] FOREST = new String[]{null, "contrib"};
    private static final String[] MODULE_DIRS = new String[]{"modules", "modules/eager", "modules/autoload", "lib", "core"};
    private final Map<String, Entry> entries;

    public static void resetCaches() {
        SOURCE_SCAN_CACHE.clear();
        SUITE_SCAN_CACHE.clear();
        STANDALONE_SCAN_CACHE.clear();
        BINARY_SCAN_CACHE.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Entry> scanNetBeansOrgSources(File root, Map<String, String> properties, Project project) throws IOException {
        Map entries = SOURCE_SCAN_CACHE.get(root);
        if (entries == null) {
            File scanCache;
            String basedir;
            boolean doFastScan;
            HashSet<String> standardModules;
            block32: {
                standardModules = new HashSet<String>();
                doFastScan = false;
                basedir = properties.get("basedir");
                if (basedir != null) {
                    String config;
                    File basedirF = new File(basedir);
                    String clusterList = properties.get("nb.clusters.list");
                    if (clusterList == null && (config = properties.get("cluster.config")) != null) {
                        clusterList = properties.get("clusters.config." + config + ".list");
                    }
                    if (clusterList != null) {
                        StringTokenizer tok = new StringTokenizer(clusterList, ", ");
                        while (tok.hasMoreTokens()) {
                            String clusterName = tok.nextToken();
                            String moduleList = properties.get(clusterName);
                            if (moduleList == null) continue;
                            StringTokenizer tok2 = new StringTokenizer(moduleList, ", ");
                            while (tok2.hasMoreTokens()) {
                                String module = tok2.nextToken();
                                standardModules.add(module);
                                doFastScan |= new File(root, module.replace('/', File.separatorChar)).equals(basedirF);
                            }
                        }
                    }
                }
                if ((scanCache = new File(root, "nbbuild" + File.separatorChar + "nbproject" + File.separatorChar + "private" + File.separatorChar + "scan-cache-" + (doFastScan ? "standard" : "full") + ".ser")).isFile()) {
                    if (project != null) {
                        project.log("Loading module list from " + scanCache);
                    }
                    try {
                        FileInputStream is = new FileInputStream(scanCache);
                        try {
                            File myProjectXml;
                            Set storedStandardModules;
                            ObjectInputStream oi = new ObjectInputStream(new BufferedInputStream(is));
                            Map timestampsAndSizes = (Map)oi.readObject();
                            boolean matches = true;
                            for (Map.Entry entry : timestampsAndSizes.entrySet()) {
                                File f = (File)entry.getKey();
                                if (f.lastModified() == ((Long[])entry.getValue())[0].longValue() && f.length() == ((Long[])entry.getValue())[1].longValue()) continue;
                                if (project != null) {
                                    project.log("Cache ignored due to modifications in " + f);
                                }
                                matches = false;
                                break;
                            }
                            if (doFastScan && !((Object)standardModules).equals(storedStandardModules = (Set)oi.readObject())) {
                                TreeSet added = new TreeSet(standardModules);
                                added.removeAll(storedStandardModules);
                                TreeSet removed = new TreeSet(storedStandardModules);
                                removed.removeAll(standardModules);
                                project.log("Cache ignored due to changes in modules among standard clusters: + " + added + " - " + removed);
                                matches = false;
                            }
                            if ((myProjectXml = project.resolveFile("nbproject/project.xml")).isFile() && !timestampsAndSizes.containsKey(myProjectXml)) {
                                project.log("Cache ignored since it has no mention of " + myProjectXml);
                                matches = false;
                            }
                            if (matches) {
                                Map _entries;
                                entries = _entries = (Map)oi.readObject();
                                if (project != null) {
                                    project.log("Loaded modules: " + entries.keySet(), 4);
                                }
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    catch (Exception x) {
                        if (project == null) break block32;
                        project.log("Error loading " + scanCache + ": " + x, 1);
                    }
                }
            }
            if (entries == null) {
                entries = new HashMap<String, Entry>();
                HashMap<File, Long[]> timestampsAndSizes = new HashMap<File, Long[]>();
                ModuleListParser.registerTimestampAndSize(new File(root, "nbbuild" + File.separatorChar + "cluster.properties"), timestampsAndSizes);
                ModuleListParser.registerTimestampAndSize(new File(root, "nbbuild" + File.separatorChar + "build.properties"), timestampsAndSizes);
                ModuleListParser.registerTimestampAndSize(new File(root, "nbbuild" + File.separatorChar + "user.build.properties"), timestampsAndSizes);
                if (doFastScan) {
                    if (project != null) {
                        project.log("Scanning for modules in " + root + " among standard clusters");
                    }
                    for (String module : standardModules) {
                        ModuleListParser.scanPossibleProject(new File(root, module.replace('/', File.separatorChar)), entries, properties, module, ModuleType.NB_ORG, project, timestampsAndSizes);
                    }
                } else {
                    if (project != null) {
                        project.log("Scanning for modules in " + root);
                        project.log("Quick scan mode disabled since " + basedir + " not among standard modules of " + root + " which are " + standardModules, 3);
                    }
                    for (String tree : FOREST) {
                        File dir = tree == null ? root : new File(root, tree);
                        File[] kids = dir.listFiles();
                        if (kids == null) continue;
                        for (File kid : kids) {
                            if (!kid.isDirectory()) continue;
                            String name = kid.getName();
                            String path = tree == null ? name : tree + "/" + name;
                            ModuleListParser.scanPossibleProject(kid, entries, properties, path, ModuleType.NB_ORG, project, timestampsAndSizes);
                        }
                    }
                }
                if (project != null) {
                    project.log("Found modules: " + entries.keySet(), 3);
                    project.log("Cache depends on files: " + timestampsAndSizes.keySet(), 4);
                }
                scanCache.getParentFile().mkdirs();
                FileOutputStream os = new FileOutputStream(scanCache);
                try {
                    ObjectOutputStream oo = new ObjectOutputStream(os);
                    oo.writeObject(timestampsAndSizes);
                    if (doFastScan) {
                        oo.writeObject(standardModules);
                    }
                    oo.writeObject(entries);
                    oo.flush();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            SOURCE_SCAN_CACHE.put(root, entries);
        }
        return entries;
    }

    private static void registerTimestampAndSize(File f, Map<File, Long[]> timestampsAndSizes) {
        if (timestampsAndSizes != null) {
            timestampsAndSizes.put(f, new Long[]{f.lastModified(), f.length()});
        }
    }

    private static boolean scanPossibleProject(File dir, Map<String, Entry> entries, Map<String, String> properties, String path, ModuleType moduleType, Project project, Map<File, Long[]> timestampsAndSizes) throws IOException {
        Document doc;
        File nbproject = new File(dir, "nbproject");
        File projectxml = new File(nbproject, "project.xml");
        if (!projectxml.isFile()) {
            return false;
        }
        ModuleListParser.registerTimestampAndSize(projectxml, timestampsAndSizes);
        try {
            doc = XMLUtil.parse(new InputSource(projectxml.toURI().toString()), false, true, null, null);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error parsing project file\n" + projectxml + ": " + e.getMessage()).initCause(e);
        }
        Element typeEl = XMLUtil.findElement(doc.getDocumentElement(), "type", "http://www.netbeans.org/ns/project/1");
        if (!XMLUtil.findText(typeEl).equals("org.netbeans.modules.apisupport.project")) {
            return false;
        }
        Element configEl = XMLUtil.findElement(doc.getDocumentElement(), "configuration", "http://www.netbeans.org/ns/project/1");
        Element dataEl = ParseProjectXml.findNBMElement(configEl, "data");
        if (dataEl == null) {
            if (project != null) {
                project.log(projectxml.toString() + ": warning: module claims to be a NBM project but is missing <data xmlns=\"" + "http://www.netbeans.org/ns/nb-module-project/3" + "\">; maybe an old NB 4.[01] project?", 1);
            }
            return false;
        }
        Element cnbEl = ParseProjectXml.findNBMElement(dataEl, "code-name-base");
        String cnb = XMLUtil.findText(cnbEl);
        if (moduleType == ModuleType.NB_ORG && project != null) {
            String expectedDirName = ModuleListParser.abbreviate(cnb);
            String actualDirName = dir.getName();
            if (!actualDirName.equals(expectedDirName)) {
                throw new IOException("Expected module to be in dir named " + expectedDirName + " but was actually found in dir named " + actualDirName);
            }
        }
        Project fakeproj = new Project();
        if (project != null) {
            Iterator it = project.getBuildListeners().iterator();
            while (it.hasNext()) {
                fakeproj.addBuildListener((BuildListener)it.next());
            }
        }
        fakeproj.setBaseDir(dir);
        Property faketask = new Property();
        faketask.setProject(fakeproj);
        switch (moduleType) {
            case NB_ORG: {
                break;
            }
            case SUITE: {
                faketask.setFile(new File(nbproject, "private/suite-private.properties"));
                faketask.execute();
                faketask.setFile(new File(nbproject, "suite.properties"));
                faketask.execute();
                faketask.setFile(new File(fakeproj.replaceProperties("${suite.dir}/nbproject/private/platform-private.properties")));
                faketask.execute();
                faketask.setFile(new File(fakeproj.replaceProperties("${suite.dir}/nbproject/platform.properties")));
                faketask.execute();
                break;
            }
            case STANDALONE: {
                faketask.setFile(new File(nbproject, "private/platform-private.properties"));
                faketask.execute();
                faketask.setFile(new File(nbproject, "platform.properties"));
                faketask.execute();
                break;
            }
            default: {
                assert (false) : moduleType;
                break;
            }
        }
        File privateProperties = new File(nbproject, "private/private.properties".replace('/', File.separatorChar));
        ModuleListParser.registerTimestampAndSize(privateProperties, timestampsAndSizes);
        faketask.setFile(privateProperties);
        faketask.execute();
        File projectProperties = new File(nbproject, "project.properties");
        ModuleListParser.registerTimestampAndSize(projectProperties, timestampsAndSizes);
        faketask.setFile(projectProperties);
        faketask.execute();
        faketask.setFile(null);
        faketask.setName("module.jar.dir");
        faketask.setValue("modules");
        faketask.execute();
        assert (fakeproj.getProperty("module.jar.dir") != null) : fakeproj.getProperties();
        faketask.setName("module.jar.basename");
        faketask.setValue(cnb.replace('.', '-') + ".jar");
        faketask.execute();
        faketask.setName("module.jar");
        faketask.setValue(fakeproj.replaceProperties("${module.jar.dir}/${module.jar.basename}"));
        faketask.execute();
        switch (moduleType) {
            case NB_ORG: {
                assert (path != null);
                String clusterDir = properties.get(path + ".dir");
                if (clusterDir != null) {
                    clusterDir = clusterDir.substring(clusterDir.lastIndexOf(47) + 1);
                } else {
                    for (Map.Entry<String, String> entry : properties.entrySet()) {
                        String key;
                        String val = entry.getValue();
                        String[] modules = val.split(", *");
                        if (!Arrays.asList(modules).contains(path) || (clusterDir = properties.get((key = entry.getKey()) + ".dir")) == null) continue;
                        faketask.setName("cluster.dir");
                        faketask.setValue(clusterDir);
                        faketask.execute();
                        break;
                    }
                    if (clusterDir == null) {
                        clusterDir = "extra";
                    }
                }
                faketask.setName("cluster.dir");
                faketask.setValue(clusterDir);
                faketask.execute();
                faketask.setName("netbeans.dest.dir");
                faketask.setValue(properties.get("netbeans.dest.dir"));
                faketask.execute();
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${netbeans.dest.dir}/${cluster.dir}"));
                faketask.execute();
                break;
            }
            case SUITE: {
                assert (path == null);
                faketask.setName("suite.dir");
                faketask.setValue(properties.get("suite.dir"));
                faketask.execute();
                faketask.setName("suite.build.dir");
                faketask.setValue(fakeproj.replaceProperties("${suite.dir}/build"));
                faketask.execute();
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${suite.build.dir}/cluster"));
                faketask.execute();
                break;
            }
            case STANDALONE: {
                assert (path == null);
                faketask.setName("build.dir");
                faketask.setValue(fakeproj.replaceProperties("${basedir}/build"));
                faketask.execute();
                faketask.setName("cluster");
                faketask.setValue(fakeproj.replaceProperties("${build.dir}/cluster"));
                faketask.execute();
                break;
            }
            default: {
                assert (false) : moduleType;
                break;
            }
        }
        File jar = fakeproj.resolveFile(fakeproj.replaceProperties("${cluster}/${module.jar}"));
        ArrayList<File> exts = new ArrayList<File>();
        for (Element ext : XMLUtil.findSubElements(dataEl)) {
            if (!ext.getLocalName().equals("class-path-extension")) continue;
            Element binaryOrigin = ParseProjectXml.findNBMElement(ext, "binary-origin");
            File origBin = null;
            if (binaryOrigin != null) {
                String reltext = XMLUtil.findText(binaryOrigin);
                String nball = properties.get("nb_all");
                if (nball != null) {
                    faketask.setName("nb_all");
                    faketask.setValue(nball);
                    faketask.execute();
                }
                fakeproj.setBaseDir(dir);
                origBin = fakeproj.resolveFile(fakeproj.replaceProperties(reltext));
            }
            File resultBin = null;
            if (origBin == null || !origBin.exists()) {
                Element runtimeRelativePath = ParseProjectXml.findNBMElement(ext, "runtime-relative-path");
                if (runtimeRelativePath == null) {
                    throw new IOException("Have malformed <class-path-extension> in " + projectxml);
                }
                String reltext = XMLUtil.findText(runtimeRelativePath);
                resultBin = new File(jar.getParentFile(), reltext.replace('/', File.separatorChar));
            }
            if (origBin != null) {
                exts.add(origBin);
            }
            if (resultBin == null) continue;
            exts.add(resultBin);
        }
        ArrayList<String> prereqs = new ArrayList<String>();
        ArrayList<String> rundeps = new ArrayList<String>();
        Element depsEl = ParseProjectXml.findNBMElement(dataEl, "module-dependencies");
        if (depsEl == null) {
            throw new IOException("Malformed project file " + projectxml);
        }
        Element testDepsEl = ParseProjectXml.findNBMElement(dataEl, "test-dependencies");
        HashMap<String, String[]> compileTestDeps = new HashMap<String, String[]>();
        if (testDepsEl != null) {
            for (Element depssEl : XMLUtil.findSubElements(testDepsEl)) {
                String testtype = ParseProjectXml.findTextOrNull(depssEl, "name");
                if (testtype == null) {
                    throw new IOException("Must declare <name>unit</name> (e.g.) in <test-type> in " + projectxml);
                }
                ArrayList<String> compileDepsList = new ArrayList<String>();
                for (Element dep : XMLUtil.findSubElements(depssEl)) {
                    if (!dep.getTagName().equals("test-dependency") || ParseProjectXml.findNBMElement(dep, "test") == null) continue;
                    compileDepsList.add(ParseProjectXml.findTextOrNull(dep, "code-name-base"));
                }
                compileTestDeps.put(testtype, compileDepsList.toArray(new String[0]));
            }
        }
        for (Element dep : XMLUtil.findSubElements(depsEl)) {
            Element cnbEl2 = ParseProjectXml.findNBMElement(dep, "code-name-base");
            if (cnbEl2 == null) {
                throw new IOException("Malformed project file " + projectxml);
            }
            String cnb2 = XMLUtil.findText(cnbEl2);
            rundeps.add(cnb2);
            if (ParseProjectXml.findNBMElement(dep, "build-prerequisite") == null) continue;
            prereqs.add(cnb2);
        }
        String cluster = fakeproj.getProperty("cluster.dir");
        Entry entry = new Entry(cnb, jar, exts.toArray(new File[exts.size()]), dir, path, prereqs.toArray(new String[prereqs.size()]), cluster, rundeps.toArray(new String[rundeps.size()]), compileTestDeps, new File(dir, "module-auto-deps.xml"));
        if (entries.containsKey(cnb)) {
            throw new IOException("Duplicated module " + cnb + ": found in " + entries.get(cnb) + " and " + entry);
        }
        entries.put(cnb, entry);
        return true;
    }

    static String abbreviate(String cnb) {
        return cnb.replaceFirst("^org\\.netbeans\\.modules\\.", "").replaceFirst("^org\\.netbeans\\.(libs|lib|api|spi|core)\\.", "$1.").replaceFirst("^org\\.netbeans\\.", "o.n.").replaceFirst("^org\\.openide\\.", "openide.").replaceFirst("^org\\.", "o.").replaceFirst("^com\\.sun\\.", "c.s.").replaceFirst("^com\\.", "c.");
    }

    private static Map<String, Entry> scanBinaries(Project project, File[] clusters) throws IOException {
        HashMap<String, Entry> allEntries = new HashMap<String, Entry>();
        for (File cluster : clusters) {
            Map<String, Entry> entries = BINARY_SCAN_CACHE.get(cluster);
            if (entries == null) {
                if (project != null) {
                    project.log("Scanning for modules in " + cluster);
                }
                entries = new HashMap<String, Entry>();
                ModuleListParser.doScanBinaries(cluster, entries);
                if (project != null) {
                    project.log("Found modules: " + entries.keySet(), 3);
                }
                BINARY_SCAN_CACHE.put(cluster, entries);
            }
            allEntries.putAll(entries);
        }
        return allEntries;
    }

    private static void doScanBinaries(File cluster, Map<String, Entry> entries) throws IOException {
        File moduleAutoDepsDir = new File(new File(cluster, "config"), "ModuleAutoDeps");
        for (String moduleDir : MODULE_DIRS) {
            File dir;
            if (moduleDir.endsWith("lib") && !cluster.getName().contains("platform") || !(dir = new File(cluster, moduleDir.replace('/', File.separatorChar))).isDirectory()) continue;
            File[] jars = dir.listFiles();
            if (jars == null) {
                throw new IOException("Cannot examine dir " + dir);
            }
            for (File m : jars) {
                ModuleListParser.scanOneBinary(m, cluster, entries, moduleAutoDepsDir);
            }
        }
        File configDir = new File(new File(cluster, "config"), "Modules");
        File[] configs = configDir.listFiles();
        XPathExpression expr = null;
        DocumentBuilder b = null;
        if (configs != null) {
            for (File xml : configs) {
                String fileName = xml.getName();
                if (!fileName.endsWith(".xml") || entries.containsKey(fileName.substring(0, fileName.length() - 4).replace('-', '.'))) continue;
                try {
                    Document doc;
                    String res;
                    File jar;
                    if (expr == null) {
                        expr = XPathFactory.newInstance().newXPath().compile("/module/param[@name='jar']");
                        b = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        b.setEntityResolver(new EntityResolver(){

                            @Override
                            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                                return new InputSource(new ByteArrayInputStream(new byte[0]));
                            }
                        });
                    }
                    if (!(jar = new File(cluster, (res = expr.evaluate(doc = b.parse(xml))).replace('/', File.separatorChar))).isFile()) {
                        if (cluster.getName().equals("ergonomics")) continue;
                        throw new BuildException("Cannot find module " + jar + " from " + xml);
                    }
                    ModuleListParser.scanOneBinary(jar, cluster, entries, moduleAutoDepsDir);
                }
                catch (Exception ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }
    }

    private static Map<String, Entry> scanSuiteSources(Map<String, String> properties, Project project) throws IOException {
        File basedir = new File(properties.get("basedir"));
        String suiteDir = properties.get("suite.dir");
        if (suiteDir == null) {
            throw new IOException("No definition of suite.dir in " + basedir);
        }
        File suite = FileUtils.getFileUtils().resolveFile(basedir, suiteDir);
        if (!suite.isDirectory()) {
            throw new IOException("No such suite " + suite);
        }
        Map<String, Entry> entries = SUITE_SCAN_CACHE.get(suite);
        if (entries == null) {
            if (project != null) {
                project.log("Scanning for modules in suite " + suite);
            }
            entries = new HashMap<String, Entry>();
            ModuleListParser.doScanSuite(entries, suite, properties, project);
            if (project != null) {
                project.log("Found modules: " + entries.keySet(), 3);
            }
            SUITE_SCAN_CACHE.put(suite, entries);
        }
        return entries;
    }

    private static void doScanSuite(Map<String, Entry> entries, File suite, Map<String, String> properties, Project project) throws IOException {
        Project fakeproj = new Project();
        fakeproj.setBaseDir(suite);
        Property faketask = new Property();
        faketask.setProject(fakeproj);
        faketask.setFile(new File(suite, "nbproject/private/private.properties".replace('/', File.separatorChar)));
        faketask.execute();
        faketask.setFile(new File(suite, "nbproject/project.properties".replace('/', File.separatorChar)));
        faketask.execute();
        String modulesS = fakeproj.getProperty("modules");
        if (modulesS == null) {
            throw new IOException("No definition of modules in " + suite);
        }
        String[] modules = Path.translatePath((Project)fakeproj, (String)modulesS);
        for (int i = 0; i < modules.length; ++i) {
            File module = new File(modules[i]);
            if (!module.isDirectory()) {
                throw new IOException("No such module " + module + " referred to from " + suite);
            }
            if (ModuleListParser.scanPossibleProject(module, entries, properties, null, ModuleType.SUITE, project, null)) continue;
            throw new IOException("No valid module found in " + module + " referred to from " + suite);
        }
    }

    private static Entry scanStandaloneSource(Map<String, String> properties, Project project) throws IOException {
        if (properties.get("project") == null) {
            return null;
        }
        File basedir = new File(properties.get("project"));
        Entry entry = STANDALONE_SCAN_CACHE.get(basedir);
        if (entry == null) {
            HashMap<String, Entry> entries = new HashMap<String, Entry>();
            if (!ModuleListParser.scanPossibleProject(basedir, entries, properties, null, ModuleType.STANDALONE, project, null)) {
                throw new IOException("No valid module found in " + basedir);
            }
            assert (entries.size() == 1);
            entry = (Entry)entries.values().iterator().next();
            STANDALONE_SCAN_CACHE.put(basedir, entry);
        }
        return entry;
    }

    public ModuleListParser(Map<String, String> properties, ModuleType type, Project project) throws IOException {
        String nball = properties.get("nb_all");
        File basedir = new File(properties.get("basedir"));
        FileUtils fu = FileUtils.getFileUtils();
        if (type != ModuleType.NB_ORG) {
            String suiteDirS = properties.get("suite.dir");
            boolean hasSuiteDir = suiteDirS != null && suiteDirS.length() > 0;
            String clusterPath = properties.get("cluster.path.final");
            File[] clusters = null;
            if (clusterPath != null) {
                String[] clustersS;
                if (hasSuiteDir) {
                    Project fakeproj = new Project();
                    fakeproj.setBaseDir(new File(suiteDirS));
                    clustersS = Path.translatePath((Project)fakeproj, (String)clusterPath);
                } else {
                    clustersS = Path.translatePath((Project)project, (String)clusterPath);
                }
                clusters = new File[clustersS.length];
                if (clustersS != null && clustersS.length > 0) {
                    for (int j = 0; j < clustersS.length; ++j) {
                        File cluster = new File(clustersS[j]);
                        if (!cluster.isDirectory()) {
                            throw new IOException("No such cluster " + cluster + " referred to from ${cluster.path.final}: " + clusterPath);
                        }
                        clusters[j] = cluster;
                    }
                }
            }
            if (clusters == null || clusters.length == 0) {
                throw new IOException("Invalid ${cluster.path.final}: " + clusterPath);
            }
            if (nball != null && project != null) {
                project.log("You must *not* declare <suite-component/> or <standalone/> for a netbeans.org module in " + basedir + "; fix project.xml to use the /2 schema", 1);
            }
            this.entries = ModuleListParser.scanBinaries(project, clusters);
            if (type == ModuleType.SUITE) {
                this.entries.putAll(ModuleListParser.scanSuiteSources(properties, project));
            } else {
                assert (type == ModuleType.STANDALONE);
                Entry e = ModuleListParser.scanStandaloneSource(properties, project);
                this.entries.put(e.getCnb(), e);
            }
        } else {
            String buildS = properties.get("netbeans.dest.dir");
            if (buildS == null) {
                throw new IOException("No definition of netbeans.dest.dir in " + basedir);
            }
            File build = fu.normalize(fu.resolveFile(basedir, buildS).getAbsolutePath());
            if (nball == null) {
                throw new IOException("You must declare either <suite-component/> or <standalone/> for an external module in " + new File(properties.get("basedir")));
            }
            if (!build.equals(new File(new File(nball, "nbbuild"), "netbeans"))) {
                if (!build.isDirectory()) {
                    throw new IOException("No such netbeans.dest.dir: " + build);
                }
                File[] clusters = build.listFiles();
                if (clusters == null) {
                    throw new IOException("Cannot examine dir " + build);
                }
                this.entries = ModuleListParser.scanBinaries(project, clusters);
                Entry e = ModuleListParser.scanStandaloneSource(properties, project);
                if (e != null) {
                    this.entries.put(e.getCnb(), e);
                }
                this.entries.putAll(ModuleListParser.scanNetBeansOrgSources(new File(nball), properties, project));
            } else {
                this.entries = ModuleListParser.scanNetBeansOrgSources(new File(nball), properties, project);
            }
        }
    }

    public Set<Entry> findAll() {
        return new HashSet<Entry>(this.entries.values());
    }

    public Entry findByCodeNameBase(String cnb) {
        return this.entries.get(cnb);
    }

    private static String[] parseRuntimeDependencies(String moduleDependencies) {
        if (moduleDependencies == null) {
            return new String[0];
        }
        ArrayList<String> cnds = new ArrayList<String>();
        StringTokenizer toks = new StringTokenizer(moduleDependencies, ",");
        while (toks.hasMoreTokens()) {
            String token = toks.nextToken().trim();
            int slIdx = token.indexOf(47);
            if (slIdx != -1) {
                token = token.substring(0, slIdx);
            }
            if ((slIdx = token.indexOf(32)) != -1) {
                token = token.substring(0, slIdx);
            }
            if ((slIdx = token.indexOf(62)) != -1) {
                token = token.substring(0, slIdx);
            }
            if ((token = token.trim()).length() <= 0) continue;
            cnds.add(token);
        }
        return cnds.toArray(new String[cnds.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean scanOneBinary(File m, File cluster, Map<String, Entry> entries, File moduleAutoDepsDir) throws IOException {
        if (!m.getName().endsWith(".jar")) {
            return true;
        }
        JarFile jf = new JarFile(m);
        File dir = m.getParentFile();
        try {
            File[] exts;
            Attributes attr = jf.getManifest().getMainAttributes();
            String codename = JarWithModuleAttributes.extractCodeName(attr);
            if (codename == null) {
                boolean bl = true;
                return bl;
            }
            int slash = codename.lastIndexOf(47);
            String codenamebase = slash == -1 ? codename : codename.substring(0, slash);
            String cp = attr.getValue("Class-Path");
            if (cp == null) {
                exts = new File[]{};
            } else {
                String[] pieces = cp.split(" +");
                exts = new File[pieces.length];
                for (int l = 0; l < pieces.length; ++l) {
                    exts[l] = new File(dir, pieces[l].replace('/', File.separatorChar));
                }
            }
            String moduleDependencies = attr.getValue("OpenIDE-Module-Module-Dependencies");
            Entry entry = new Entry(codenamebase, m, exts, dir, null, null, cluster.getName(), ModuleListParser.parseRuntimeDependencies(moduleDependencies), Collections.<String, String[]>emptyMap(), new File(moduleAutoDepsDir, codenamebase.replace('.', '-') + ".xml"));
            Entry prev = entries.put(codenamebase, entry);
            if (prev != null && !prev.equals(entry)) {
                throw new IOException("Duplicated module " + codenamebase + ": found in " + prev + " and " + entry);
            }
        }
        finally {
            jf.close();
        }
        return false;
    }

    public static final class Entry
    implements Serializable {
        private final String cnb;
        private final File jar;
        private final File[] classPathExtensions;
        private final File sourceLocation;
        private final String netbeansOrgPath;
        private final String[] buildPrerequisites;
        private final String clusterName;
        private final String[] runtimeDependencies;
        private final Map<String, String[]> testDependencies;
        private final File moduleAutoDeps;

        Entry(String cnb, File jar, File[] classPathExtensions, File sourceLocation, String netbeansOrgPath, String[] buildPrerequisites, String clusterName, String[] runtimeDependencies, Map<String, String[]> testDependencies, File moduleAutoDeps) {
            this.cnb = cnb;
            this.jar = jar;
            this.classPathExtensions = classPathExtensions;
            this.sourceLocation = sourceLocation;
            this.netbeansOrgPath = netbeansOrgPath;
            this.buildPrerequisites = buildPrerequisites;
            this.clusterName = clusterName;
            this.runtimeDependencies = runtimeDependencies;
            assert (testDependencies != null);
            this.testDependencies = testDependencies;
            this.moduleAutoDeps = moduleAutoDeps;
        }

        public String getCnb() {
            return this.cnb;
        }

        public File getJar() {
            return this.jar;
        }

        public File[] getClassPathExtensions() {
            return this.classPathExtensions;
        }

        public File getSourceLocation() {
            return this.sourceLocation;
        }

        public String getNetbeansOrgPath() {
            return this.netbeansOrgPath;
        }

        public String[] getBuildPrerequisites() {
            return this.buildPrerequisites;
        }

        public String[] getRuntimeDependencies() {
            return this.runtimeDependencies;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public Map<String, String[]> getTestDependencies() {
            return this.testDependencies;
        }

        public File getModuleAutoDeps() {
            return this.moduleAutoDeps;
        }

        public String toString() {
            return (this.sourceLocation != null ? this.sourceLocation : this.jar).getAbsolutePath();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.cnb == null ? other.cnb != null : !this.cnb.equals(other.cnb)) {
                return false;
            }
            if (!(this.jar == other.jar || this.jar != null && this.jar.equals(other.jar))) {
                return false;
            }
            if (!Arrays.deepEquals(this.classPathExtensions, other.classPathExtensions)) {
                return false;
            }
            if (!(this.sourceLocation == other.sourceLocation || this.sourceLocation != null && this.sourceLocation.equals(other.sourceLocation))) {
                return false;
            }
            if (this.netbeansOrgPath == null ? other.netbeansOrgPath != null : !this.netbeansOrgPath.equals(other.netbeansOrgPath)) {
                return false;
            }
            if (!Arrays.deepEquals(this.buildPrerequisites, other.buildPrerequisites)) {
                return false;
            }
            if (this.clusterName == null ? other.clusterName != null : !this.clusterName.equals(other.clusterName)) {
                return false;
            }
            if (!Arrays.deepEquals(this.runtimeDependencies, other.runtimeDependencies)) {
                return false;
            }
            return this.testDependencies == other.testDependencies || this.testDependencies != null && ((Object)this.testDependencies).equals(other.testDependencies);
        }

        public int hashCode() {
            int hash = 5;
            hash = 83 * hash + (this.cnb != null ? this.cnb.hashCode() : 0);
            hash = 83 * hash + (this.jar != null ? this.jar.hashCode() : 0);
            hash = 83 * hash + Arrays.deepHashCode(this.classPathExtensions);
            hash = 83 * hash + (this.sourceLocation != null ? this.sourceLocation.hashCode() : 0);
            hash = 83 * hash + (this.netbeansOrgPath != null ? this.netbeansOrgPath.hashCode() : 0);
            hash = 83 * hash + Arrays.deepHashCode(this.buildPrerequisites);
            hash = 83 * hash + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            hash = 83 * hash + Arrays.deepHashCode(this.runtimeDependencies);
            hash = 83 * hash + (this.testDependencies != null ? ((Object)this.testDependencies).hashCode() : 0);
            return hash;
        }
    }
}

