/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;
import org.codehaus.mojo.nbm.CreateNetbeansFileStructure;
import org.codehaus.mojo.nbm.CreateUpdateSiteMojo;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.netbeans.nbbuild.MakeNBM;

public class CreateNbmMojo
extends CreateNetbeansFileStructure
implements Contextualizable {
    private String keystore;
    private String keystorepassword;
    private String keystorealias;
    private boolean skipNbm;
    private PlexusContainer container;
    private ArtifactFactory artifactFactory;
    private MavenProjectHelper projectHelper;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipNbm) {
            this.getLog().info((CharSequence)"Skipping generation of NBM file.");
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getId() + ", no nbm:nbm execution for 'pom' packaging"));
            return;
        }
        super.execute();
        File nbmFile = new File(this.nbmBuildDir, this.finalName + ".nbm");
        MakeNBM nbmTask = (MakeNBM)this.antProject.createTask("makenbm");
        nbmTask.setFile(nbmFile);
        nbmTask.setProductDir(this.clusterDir);
        nbmTask.setModule("modules" + File.separator + this.moduleJarName + ".jar");
        nbmTask.setNeedsrestart(Boolean.toString(this.module.isRequiresRestart()));
        String moduleAuthor = this.module.getAuthor();
        if (moduleAuthor == null) {
            moduleAuthor = this.project.getOrganization() != null ? this.project.getOrganization().getName() : null;
        }
        nbmTask.setModuleauthor(moduleAuthor);
        if (this.keystore != null && this.keystorealias != null && this.keystorepassword != null) {
            File ks = new File(this.keystore);
            if (!ks.exists()) {
                this.getLog().warn((CharSequence)("Cannot find keystore file at " + ks.getAbsolutePath()));
            } else {
                MakeNBM.Signature sig = nbmTask.createSignature();
                sig.setKeystore(ks);
                sig.setAlias(this.keystorealias);
                sig.setStorepass(this.keystorepassword);
                this.getLog().debug((CharSequence)"Setup the Ant task to sign the NBM file.");
            }
        } else if (this.keystore != null || this.keystorepassword != null || this.keystorealias != null) {
            this.getLog().warn((CharSequence)"If you want to sign the nbm file, you need to define all three keystore related parameters.");
        }
        String licenseName = this.module.getLicenseName();
        String licenseFile = this.module.getLicenseFile();
        if (licenseName != null && licenseFile != null) {
            File lf = new File(this.project.getBasedir(), licenseFile);
            if (!lf.exists() || !lf.isFile()) {
                this.getLog().warn((CharSequence)("Cannot find license file at " + lf.getAbsolutePath()));
            } else {
                MakeNBM.Blurb lb = nbmTask.createLicense();
                lb.setFile(lf);
                lb.addText(licenseName);
            }
        } else if (licenseName != null || licenseFile != null) {
            this.getLog().warn((CharSequence)"To add a license to the nbm, you need to specify both licenseName and licenseFile parameters");
        } else {
            MakeNBM.Blurb lb = nbmTask.createLicense();
            lb.addText("<Here comes the license>");
            lb.addText("Unknown license agreement");
        }
        String homePageUrl = this.module.getHomepageUrl();
        if (homePageUrl == null) {
            homePageUrl = this.project.getUrl();
        }
        if (homePageUrl != null) {
            nbmTask.setHomepage(homePageUrl);
        }
        if (this.module.getDistributionUrl() != null) {
            ArtifactRepository distRepository = CreateUpdateSiteMojo.getDeploymentRepository(this.module.getDistributionUrl(), this.container, this.getLog());
            String dist = null;
            if (distRepository == null) {
                if (!this.module.getDistributionUrl().contains("::")) {
                    dist = this.module.getDistributionUrl() + (this.module.getDistributionUrl().endsWith("/") ? "" : "/") + nbmFile.getName();
                }
            } else {
                Artifact art = this.artifactFactory.createArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, "nbm-file");
                dist = distRepository.getUrl() + (distRepository.getUrl().endsWith("/") ? "" : "/") + distRepository.pathOf(art);
            }
            nbmTask.setDistribution(dist);
        } else {
            nbmTask.setDistribution(nbmFile.getName());
        }
        nbmTask.setTargetcluster(this.cluster);
        try {
            nbmTask.execute();
        }
        catch (BuildException e) {
            throw new MojoExecutionException("Cannot Generate nbm file:" + e.getMessage(), (Exception)((Object)e));
        }
        try {
            File nbmfile = new File(this.buildDir, nbmFile.getName());
            FileUtils.getFileUtils().copyFile(nbmFile, nbmfile);
            this.projectHelper.attachArtifact(this.project, "nbm-file", null, nbmfile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot copy nbm to build directory", (Exception)ex);
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

