/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.nbm;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.tools.ant.taskdefs.Chmod;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.nbm.AbstractNbmMojo;
import org.codehaus.mojo.nbm.ExamineManifest;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.io.InputStreamFacade;
import org.netbeans.nbbuild.MakeListOfNBM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateClusterAppMojo
extends AbstractNbmMojo {
    private File outputDirectory;
    private MavenProject project;
    protected String brandingToken;
    private File etcConfFile;
    private File etcClustersFile;
    private File binDirectory;
    private String defaultCluster;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    private static final Pattern patt = Pattern.compile(".*targetcluster=\"([a-zA-Z0-9_\\.\\-]+)\".*", 32);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        File nbmBuildDirFile;
        block40: {
            block39: {
                ClusterTuple cluster;
                nbmBuildDirFile = new File(this.outputDirectory, this.brandingToken);
                if (!nbmBuildDirFile.exists()) {
                    nbmBuildDirFile.mkdirs();
                }
                if (!"nbm-application".equals(this.project.getPackaging())) break block39;
                Project antProject = this.registerNbmAntTasks();
                HashSet<String> knownClusters = new HashSet<String>();
                HashSet<String> wrappedBundleCNBs = new HashSet<String>();
                HashMap<void, ExamineManifest> bundles = new HashMap<void, ExamineManifest>();
                Set artifacts = this.project.getArtifacts();
                for (Artifact artifact : artifacts) {
                    void var8_11;
                    AbstractNbmMojo.ArtifactResult res;
                    block37: {
                        res = this.turnJarToNbmFile(artifact, this.artifactFactory, this.artifactResolver, this.project, this.localRepository);
                        if (res.hasConvertedArtifact()) {
                            Artifact artifact2 = res.getConvertedArtifact();
                        }
                        if (!var8_11.getType().equals("nbm-file")) break block37;
                        ZipFile jf = null;
                        try {
                            jf = new JarFile(var8_11.getFile());
                            String clusterName = this.findCluster((JarFile)jf);
                            cluster = this.processCluster(clusterName, knownClusters, nbmBuildDirFile, (Artifact)var8_11);
                            if (!cluster.newer) break block37;
                            this.getLog().debug((CharSequence)("Copying " + var8_11.getId() + " to cluster " + clusterName));
                            Enumeration<JarEntry> enu = ((JarFile)jf).entries();
                            MakeListOfNBM makeTask = (MakeListOfNBM)antProject.createTask("genlist");
                            antProject.setNewProperty("module.name", var8_11.getFile().getName());
                            antProject.setProperty("cluster.dir", clusterName);
                            FileSet set = makeTask.createFileSet();
                            set.setDir(cluster.location);
                            makeTask.setOutputfiledir(cluster.location);
                            while (enu.hasMoreElements()) {
                                BufferedOutputStream outstream;
                                String part;
                                File fl;
                                String path;
                                block38: {
                                    JarEntry ent = enu.nextElement();
                                    String name = ent.getName();
                                    if (!name.startsWith("netbeans/")) continue;
                                    path = name.replace("netbeans/", clusterName + "/");
                                    boolean ispack200 = path.endsWith(".jar.pack.gz");
                                    if (ispack200) {
                                        path = path.replace(".jar.pack.gz", ".jar");
                                    }
                                    fl = new File(nbmBuildDirFile, path.replace("/", File.separator));
                                    if (ent.isDirectory()) {
                                        fl.mkdirs();
                                        continue;
                                    }
                                    part = name.replace("netbeans/", "");
                                    if (ispack200) {
                                        part = part.replace(".jar.pack.gz", ".jar");
                                    }
                                    set.appendIncludes(new String[]{part});
                                    fl.getParentFile().mkdirs();
                                    fl.createNewFile();
                                    outstream = null;
                                    try {
                                        outstream = new BufferedOutputStream(new FileOutputStream(fl));
                                        InputStream instream = ((JarFile)jf).getInputStream(ent);
                                        if (ispack200) {
                                            Pack200.Unpacker unp = Pack200.newUnpacker();
                                            JarOutputStream jos = new JarOutputStream(outstream);
                                            GZIPInputStream gzip = new GZIPInputStream(instream);
                                            try {
                                                unp.unpack((InputStream)gzip, jos);
                                                break block38;
                                            }
                                            finally {
                                                jos.close();
                                            }
                                        }
                                        IOUtil.copy((InputStream)instream, (OutputStream)outstream);
                                    }
                                    catch (Throwable throwable) {
                                        IOUtil.close(outstream);
                                        throw throwable;
                                    }
                                }
                                IOUtil.close((OutputStream)outstream);
                                if (!path.endsWith(".jar") || path.contains("locale/") || path.contains("docs/")) continue;
                                ExamineManifest ex = new ExamineManifest(this.getLog());
                                ex.setJarFile(fl);
                                ex.checkFile();
                                if (ex.isNetbeansModule()) {
                                    makeTask.setModule(part);
                                    continue;
                                }
                                if (!ex.isOsgiBundle()) continue;
                                wrappedBundleCNBs.add(ex.getModule());
                            }
                            try {
                                makeTask.execute();
                            }
                            catch (BuildException e) {
                                this.getLog().error((CharSequence)"Cannot Generate update_tracking xml file");
                                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
                            }
                        }
                        catch (IOException ex) {
                            this.getLog().error((Throwable)ex);
                        }
                        finally {
                            try {
                                jf.close();
                            }
                            catch (IOException ex) {
                                this.getLog().error((Throwable)ex);
                            }
                        }
                    }
                    if (!res.isOSGiBundle()) continue;
                    bundles.put(var8_11, res.getExaminedManifest());
                }
                for (Map.Entry entry : bundles.entrySet()) {
                    Artifact art = (Artifact)entry.getKey();
                    ExamineManifest ex = (ExamineManifest)entry.getValue();
                    String spec = ex.getModule();
                    if (wrappedBundleCNBs.contains(spec)) {
                        this.getLog().debug((CharSequence)("Not including bundle " + art.getDependencyConflictId() + ". It is already included in a NetBeans module."));
                        continue;
                    }
                    cluster = this.processCluster(this.defaultCluster, knownClusters, nbmBuildDirFile, art);
                    if (!cluster.newer) continue;
                    this.getLog().debug((CharSequence)("Copying " + art.getId() + " to cluster " + this.defaultCluster));
                    File modules = new File(cluster.location, "modules");
                    modules.mkdirs();
                    File config = new File(cluster.location, "config");
                    File confModules = new File(config, "Modules");
                    confModules.mkdirs();
                    File updateTracting = new File(cluster.location, "update_tracking");
                    updateTracting.mkdirs();
                    final String cnb = ex.getModule();
                    String cnbDashed = cnb.replace(".", "-");
                    final File moduleArt = new File(modules, cnbDashed + ".jar");
                    final String specVer = ex.getSpecVersion();
                    try {
                        FileUtils.copyFile((File)art.getFile(), (File)moduleArt);
                        final File moduleConf = new File(confModules, cnbDashed + ".xml");
                        FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                            public InputStream getInputStream() throws IOException {
                                return new StringInputStream(CreateClusterAppMojo.createBundleConfigFile(cnb), "UTF-8");
                            }
                        }, (File)moduleConf);
                        FileUtils.copyStreamToFile((InputStreamFacade)new InputStreamFacade(){

                            public InputStream getInputStream() throws IOException {
                                return new StringInputStream(CreateClusterAppMojo.createBundleUpdateTracking(cnb, moduleArt, moduleConf, specVer), "UTF-8");
                            }
                        }, (File)new File(updateTracting, cnbDashed + ".xml"));
                    }
                    catch (IOException exc) {
                        this.getLog().error((Throwable)exc);
                    }
                }
                break block40;
            }
            throw new MojoExecutionException("This goal only makes sense on project with nbm-application packaging");
        }
        this.getLog().info((CharSequence)("Created NetBeans module cluster(s) at " + nbmBuildDirFile.getAbsoluteFile()));
        File[] files = nbmBuildDirFile.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            File stamp = new File(files[i], ".lastModified");
            if (!stamp.exists()) {
                try {
                    stamp.createNewFile();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            stamp.setLastModified(new Date().getTime());
        }
        try {
            this.createBinEtcDir(nbmBuildDirFile, this.brandingToken);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Cannot process etc folder content creation.", (Exception)ex);
        }
    }

    private String findCluster(JarFile jf) throws MojoFailureException, IOException {
        ZipEntry entry = jf.getEntry("Info/info.xml");
        InputStream ins = jf.getInputStream(entry);
        String str = IOUtil.toString((InputStream)ins, (String)"UTF8");
        Matcher m = patt.matcher(str);
        if (!m.matches()) {
            this.getLog().warn((CharSequence)("Cannot find cluster for " + jf.getName() + " Falling back to default value - '" + this.defaultCluster + "'."));
            return this.defaultCluster;
        }
        return m.group(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinEtcDir(File buildDir, String brandingToken) throws IOException, MojoExecutionException {
        String str;
        File etcDir;
        block19: {
            File confFile;
            block17: {
                File harnessDir;
                block18: {
                    String clustersString;
                    etcDir = new File(buildDir + File.separator + "etc");
                    etcDir.mkdir();
                    File clusterConf = new File(etcDir + File.separator + brandingToken + ".clusters");
                    if (this.etcClustersFile != null) {
                        clustersString = FileUtils.fileRead((File)this.etcClustersFile, (String)"UTF-8");
                    } else {
                        File[] clusters;
                        clusterConf.createNewFile();
                        StringBuffer buffer = new StringBuffer();
                        for (File cluster : clusters = buildDir.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return new File(pathname, ".lastModified").exists();
                            }
                        })) {
                            buffer.append(cluster.getName());
                            buffer.append("\n");
                        }
                        clustersString = buffer.toString();
                    }
                    FileUtils.fileWrite((String)clusterConf.getAbsolutePath(), (String)clustersString);
                    confFile = this.etcConfFile;
                    if (confFile != null) break block17;
                    harnessDir = new File(buildDir, "harness");
                    if (harnessDir.exists()) break block18;
                    this.getLog().debug((CharSequence)"Using fallback app.conf shipping with the nbm-maven-plugin.");
                    InputStream instream = null;
                    try {
                        instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/app.conf");
                        str = IOUtil.toString((InputStream)instream, (String)"UTF-8");
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(instream);
                        throw throwable;
                    }
                    IOUtil.close((InputStream)instream);
                    break block19;
                }
                confFile = new File(harnessDir.getAbsolutePath() + File.separator + "etc" + File.separator + "app.conf");
                str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
                break block19;
            }
            str = FileUtils.fileRead((File)confFile, (String)"UTF-8");
        }
        File confDestFile = new File(etcDir.getAbsolutePath() + File.separator + brandingToken + ".conf");
        str = str.replace("${branding.token}", brandingToken);
        FileUtils.fileWrite((String)confDestFile.getAbsolutePath(), (String)"UTF-8", (String)str);
        File destBinDir = new File(buildDir + File.separator + "bin");
        destBinDir.mkdir();
        File destExeW = new File(destBinDir, brandingToken + "_w.exe");
        File destExe = new File(destBinDir, brandingToken + ".exe");
        File destSh = new File(destBinDir, brandingToken);
        if (this.binDirectory != null) {
            File binDir = this.binDirectory;
            File[] fls = binDir.listFiles();
            if (fls == null) {
                throw new MojoExecutionException("Parameter 'binDirectory' has to point to an existing folder.");
            }
            for (File fl : fls) {
                String name = fl.getName();
                File dest = null;
                if (name.endsWith("_w.exe")) {
                    dest = destExeW;
                } else if (name.endsWith(".exe")) {
                    dest = destExe;
                } else if (!name.contains(".") || name.endsWith(".sh")) {
                    dest = destSh;
                }
                if (dest == null || !fl.exists()) continue;
                FileUtils.copyFile((File)fl, (File)dest);
            }
        } else {
            File harnessDir = new File(buildDir, "harness");
            if (harnessDir.exists()) {
                File binDir = new File(harnessDir.getAbsolutePath() + File.separator + "launchers");
                File exe = new File(binDir, "app.exe");
                FileUtils.copyFile((File)exe, (File)destExe);
                File exew = new File(binDir, "app_w.exe");
                if (exew.exists()) {
                    FileUtils.copyFile((File)exew, (File)destExeW);
                }
                File sh = new File(binDir, "app.sh");
                FileUtils.copyFile((File)sh, (File)destSh);
            } else {
                this.getLog().debug((CharSequence)"Using fallback executables shipping with the nbm-maven-plugin. (from 6.9main NetBeans Platform)");
                this.writeFile("/launchers/app.sh", destSh);
                this.writeFile("/launchers/app.exe", destExe);
            }
        }
        Project antProject = new Project();
        antProject.init();
        Chmod chmod = (Chmod)antProject.createTask("chmod");
        FileSet fs = new FileSet();
        fs.setDir(destBinDir);
        fs.setIncludes("*");
        chmod.addFileset(fs);
        chmod.setPerm("755");
        chmod.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String path, File destSh) throws IOException {
        InputStream instream = null;
        BufferedOutputStream output = null;
        try {
            instream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(path);
            destSh.createNewFile();
            output = new BufferedOutputStream(new FileOutputStream(destSh));
            IOUtil.copy((InputStream)instream, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtil.close(instream);
            IOUtil.close(output);
            throw throwable;
        }
        IOUtil.close((InputStream)instream);
        IOUtil.close((OutputStream)output);
    }

    private ClusterTuple processCluster(String cluster, Set<String> knownClusters, File nbmBuildDirFile, Artifact art) {
        if (!knownClusters.contains(cluster)) {
            this.getLog().info((CharSequence)("Processing cluster '" + cluster + "'"));
            knownClusters.add(cluster);
        }
        File clusterFile = new File(nbmBuildDirFile, cluster);
        boolean newer = false;
        if (!clusterFile.exists()) {
            clusterFile.mkdir();
            newer = true;
        } else {
            File stamp = new File(clusterFile, ".lastModified");
            if (stamp.lastModified() < art.getFile().lastModified()) {
                newer = true;
            }
        }
        return new ClusterTuple(clusterFile, newer);
    }

    static String createBundleConfigFile(String cnb) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE module PUBLIC \"-//NetBeans//DTD Module Status 1.0//EN\"\n                        \"http://www.netbeans.org/dtds/module-status-1_0.dtd\">\n<module name=\"" + cnb + "\">\n" + "    <param name=\"autoload\">true</param>\n" + "    <param name=\"eager\">false</param>\n" + "    <param name=\"jar\">modules/" + cnb.replace(".", "-") + ".jar</param>\n" + "    <param name=\"reloadable\">false</param>\n" + "</module>";
    }

    static String createBundleUpdateTracking(String cnb, File moduleArt, File moduleConf, String specVersion) throws FileNotFoundException, IOException {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<module codename=\"" + cnb + "\">\n" + "    <module_version install_time=\"" + System.currentTimeMillis() + "\" last=\"true\" origin=\"installer\" specification_version=\"" + specVersion + "\">\n" + "        <file crc=\"" + CreateClusterAppMojo.crcForFile(moduleConf).getValue() + "\" name=\"config/Modules/" + cnb.replace(".", "-") + ".xml\"/>\n" + "        <file crc=\"" + CreateClusterAppMojo.crcForFile(moduleArt).getValue() + "\" name=\"modules/" + cnb.replace(".", "-") + ".xml\"/>\n" + "    </module_version>\n" + "</module>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CRC32 crcForFile(File inFile) throws FileNotFoundException, IOException {
        FileInputStream inFileStream = null;
        CRC32 crc = new CRC32();
        try {
            inFileStream = new FileInputStream(inFile);
            byte[] array = new byte[(int)inFile.length()];
            int len = inFileStream.read(array);
            if (len != array.length) {
                throw new IOException("Cannot fully read " + inFile);
            }
            crc.update(array);
        }
        finally {
            inFileStream.close();
        }
        return crc;
    }

    private class ClusterTuple {
        final File location;
        final boolean newer;

        private ClusterTuple(File clusterFile, boolean newer) {
            this.location = clusterFile;
            this.newer = newer;
        }
    }
}

