/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=FileHeaderTransformer.class, hint="java")
public class JavaFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    protected boolean addJavaLicenseAfterPackage;
    protected boolean useNoReformatCommentStartTag;

    public JavaFileHeaderTransformer() {
        super("java", "header transformer with java comment style", "/*", " */", " * ");
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{"java", "groovy", "css", "cs", "as", "aj", "c", "h", "cpp", "js", "json", "ts", "go"};
    }

    public void setAddJavaLicenseAfterPackage(boolean addJavaLicenseAfterPackage) {
        this.addJavaLicenseAfterPackage = addJavaLicenseAfterPackage;
    }

    public void setUseNoReformatCommentStartTag(boolean useNoReformatCommentStartTag) {
        this.useNoReformatCommentStartTag = useNoReformatCommentStartTag;
    }

    public String getCommentStartTag() {
        return this.useNoReformatCommentStartTag ? "/*-" : super.getCommentStartTag();
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        if (!this.addJavaLicenseAfterPackage) {
            return super.addHeader(header, content);
        }
        String prolog = null;
        int startProlog = content.indexOf("package");
        if (startProlog > -1 && (endProlog = content.indexOf(";", startProlog)) > -1) {
            int lastIndex = endProlog + 1;
            prolog = content.substring(0, lastIndex);
            prolog = prolog + LINE_SEPARATOR;
            if (lastIndex == content.length()) {
                content = content + LINE_SEPARATOR;
            }
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + LINE_SEPARATOR + header, content);
        }
        return result;
    }
}

