/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.mojo.license.MojoHelper;
import org.codehaus.plexus.util.IOUtil;

public class License {
    public static final String LICENSE_HEADER_FILE = "header.txt";
    public static final String LICENSE_CONTENT_FILE = "license.txt";
    protected URL baseURL;
    protected String name;
    protected String description;
    protected URL licenseURL;
    protected URL headerURL;

    public String getName() {
        return this.name;
    }

    public URL getLicenseURL() {
        if (this.licenseURL == null) {
            this.licenseURL = MojoHelper.getUrl(this.getBaseURL(), LICENSE_CONTENT_FILE);
        }
        return this.licenseURL;
    }

    public URL getHeaderURL() {
        if (this.headerURL == null) {
            this.headerURL = MojoHelper.getUrl(this.getBaseURL(), LICENSE_HEADER_FILE);
        }
        return this.headerURL;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLicenseContent(String encoding) throws IOException {
        if (this.baseURL == null) {
            throw new IllegalStateException("no baseURL defined, can not obtain license content in " + this);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getLicenseURL().openStream(), encoding));
        try {
            String string = IOUtil.toString((Reader)r);
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHeaderContent(String encoding) throws IOException {
        if (this.baseURL == null) {
            throw new IllegalStateException("no baseURL defined, can not obtain header content in " + this);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.getHeaderURL().openStream(), encoding));
        try {
            String string = IOUtil.toString((Reader)r);
            return string;
        }
        finally {
            ((Reader)r).close();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    public void setLicenseURL(URL licenseURL) {
        this.licenseURL = licenseURL;
    }

    public void setHeaderURL(URL headerURL) {
        this.headerURL = headerURL;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        builder.append("name", (Object)this.name);
        builder.append("description", (Object)this.description);
        builder.append("licenseURL", (Object)this.licenseURL);
        builder.append("headerURL", (Object)this.headerURL);
        return builder.toString();
    }
}

