/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.idlj.AbstractTranslator;
import org.codehaus.mojo.idlj.CompilerTranslator;
import org.codehaus.mojo.idlj.Define;
import org.codehaus.mojo.idlj.PackagePrefix;
import org.codehaus.mojo.idlj.PackageTranslation;
import org.codehaus.mojo.idlj.Source;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdljTranslator
extends AbstractTranslator
implements CompilerTranslator {
    private static final String AIX_IDLJ_COMPILER_NAME = "com.ibm.idl.toJavaPortable.Compile";
    private static final String ORACLE_IDLJ_COMPILER_NAME = "com.sun.tools.corba.se.idl.toJavaPortable.Compile";

    @Override
    public void invokeCompiler(String sourceDirectory, File[] includeDirs, String targetDirectory, String idlFile, Source source) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-i");
        args.add(sourceDirectory);
        if (includeDirs != null && includeDirs.length > 0) {
            for (File includeDir : includeDirs) {
                args.add("-i");
                args.add(includeDir.toString());
            }
        }
        args.add("-td");
        args.add(IdljTranslator.toRelativeAndFixSeparator(new File(System.getProperty("user.dir")), new File(targetDirectory), false));
        if (source.getPackagePrefix() != null) {
            throw new MojoExecutionException("idlj compiler does not support packagePrefix");
        }
        if (source.getPackagePrefixes() != null) {
            for (PackagePrefix prefix : source.getPackagePrefixes()) {
                args.add("-pkgPrefix");
                args.add(prefix.getType());
                args.add(prefix.getPrefix());
            }
        }
        if (source.getPackageTranslations() != null) {
            for (PackageTranslation translation : source.getPackageTranslations()) {
                args.add("-pkgTranslate");
                args.add(translation.getType());
                args.add(translation.getReplacementPackage());
            }
        }
        if (source.getDefines() != null) {
            for (Define define : source.getDefines()) {
                if (define.getValue() != null) {
                    throw new MojoExecutionException("idlj compiler unable to define symbol values");
                }
                args.add("-d");
                args.add(define.getSymbol());
            }
        }
        if (this.isOptionEnabled(source.emitStubs())) {
            if (source.emitSkeletons().booleanValue()) {
                args.add("-fallTIE");
            } else {
                args.add("-fclient");
            }
        } else if (this.isOptionEnabled(source.emitSkeletons())) {
            args.add("-fserver");
        } else {
            args.add("-fserverTIE");
        }
        if (this.isOptionEnabled(source.compatible())) {
            args.add("-oldImplBase");
        }
        if (source.getAdditionalArguments() != null) {
            for (String arg : source.getAdditionalArguments()) {
                args.add(arg);
            }
        }
        args.add(idlFile);
        Class<?> compilerClass = this.getCompilerClass();
        this.invokeCompiler(compilerClass, args);
    }

    private boolean isOptionEnabled(Boolean option) {
        return option != null && option != false;
    }

    private Class<?> getCompilerClass() throws MojoExecutionException {
        Class<?> idljCompiler;
        try {
            if (this.isMacOSX()) {
                this.addToolsJarToPath();
            }
            idljCompiler = this.getClassLoaderFacade().loadClass(IdljTranslator.getIDLCompilerClassName());
        }
        catch (ClassNotFoundException e) {
            try {
                this.addToolsJarToPath();
                idljCompiler = this.getClassLoaderFacade().loadClass(IdljTranslator.getIDLCompilerClassName());
            }
            catch (Exception notUsed) {
                throw new MojoExecutionException(" IDL compiler not available", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(" IDL compiler not available", e);
        }
        return idljCompiler;
    }

    private void addToolsJarToPath() throws MalformedURLException, ClassNotFoundException {
        File javaHome = new File(System.getProperty("java.home"));
        File toolsJar = new File(javaHome, this.getToolsJarPath());
        URL toolsJarUrl = toolsJar.toURI().toURL();
        this.getClassLoaderFacade().prependUrls(toolsJarUrl);
        System.setProperty("java.class.path", System.getProperty("java.class.path") + System.getProperty("path.separator") + toolsJar.getAbsolutePath());
        if (System.getProperty("java.vm.name").contains("HotSpot")) {
            this.getClassLoaderFacade().loadClass("com.sun.tools.corba.se.idl.som.cff.FileLocator");
        }
    }

    private String getToolsJarPath() {
        return this.isMacOSX() ? "../Classes/classes.jar" : "../lib/tools.jar";
    }

    private boolean isMacOSX() {
        return System.getProperty("java.vm.vendor").contains("Apple");
    }

    private static boolean isAix() {
        return System.getProperty("java.vm.vendor").contains("IBM");
    }

    private static String getIDLCompilerClassName() {
        return IdljTranslator.isAix() ? AIX_IDLJ_COMPILER_NAME : ORACLE_IDLJ_COMPILER_NAME;
    }

    private void invokeCompiler(Class<?> compilerClass, List<String> args) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("Current dir : " + System.getProperty("user.dir")));
        if (this.isDebug()) {
            args.add(0, "-verbose");
        }
        this.invokeCompilerInProcess(compilerClass, args);
    }

    @Override
    protected int runCompiler(Class<?> compilerClass, String ... arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method compilerMainMethod = compilerClass.getMethod("main", String[].class);
        Object retVal = compilerMainMethod.invoke(compilerClass, new Object[]{arguments});
        this.getLog().debug((CharSequence)("Completed with code " + retVal));
        return retVal != null && retVal instanceof Integer ? (Integer)retVal : 0;
    }

    public static String fixSeparator(String filename) {
        return StringUtils.replace((String)filename, (char)'\\', (char)'/');
    }

    public static String getCanonicalPath(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't canonicalize system path: " + file.getAbsolutePath(), (Exception)e);
        }
    }

    public static String toRelativeAndFixSeparator(File fromdir, File todir, boolean replaceSlashesWithDashes) throws MojoExecutionException {
        String relative;
        if (!todir.isAbsolute()) {
            todir = new File(fromdir, todir.getPath());
        }
        String basedirPath = IdljTranslator.getCanonicalPath(fromdir);
        String absolutePath = IdljTranslator.getCanonicalPath(todir);
        if (absolutePath.equals(basedirPath)) {
            relative = ".";
        } else if (absolutePath.startsWith(basedirPath)) {
            int length = basedirPath.length() + 1;
            if (basedirPath.endsWith("\\")) {
                --length;
            }
            relative = absolutePath.substring(length);
        } else {
            relative = absolutePath;
        }
        relative = IdljTranslator.fixSeparator(relative);
        if (replaceSlashesWithDashes) {
            relative = StringUtils.replace((String)relative, (char)'/', (char)'-');
            relative = StringUtils.replace((String)relative, (char)':', (char)'-');
        }
        return relative;
    }
}

