/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.idlj;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:idlj-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "CORBA IDL Compiler Maven Plugin 1.1", 0);
        this.append(sb, "This plugin is for processing IDL files into java sources.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 3 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "idlj:generate", 0);
            this.append(sb, "Process CORBA IDL files in IDLJ.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compiler (Default: idlj)", 2);
                this.append(sb, "The compiler to use. Current options are Suns idlj compiler and JacORB. Should be either 'idlj' or 'jacorb'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug", 2);
                this.append(sb, "Activate more detailed debug messages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Should the plugin fail the build if there's an error while generating sources from IDLs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeDirs", 2);
                this.append(sb, "Additional include directories containing additional *.idl files required for compilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/idl)", 2);
                this.append(sb, "The directory to output the generated sources to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${basedir}/src/main/idl)", 2);
                this.append(sb, "The source directory containing *.idl files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "A List of Source configurations to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampDirectory (Default: ${project.build.directory}/idlj-timestamp)", 2);
                this.append(sb, "The directory to store the processed grammars. Used so that grammars are not constantly regenerated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate-test".equals(this.goal)) {
            this.append(sb, "idlj:generate-test", 0);
            this.append(sb, "Process CORBA IDL test files in IDLJ.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compiler (Default: idlj)", 2);
                this.append(sb, "The compiler to use. Current options are Suns idlj compiler and JacORB. Should be either 'idlj' or 'jacorb'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug", 2);
                this.append(sb, "Activate more detailed debug messages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Should the plugin fail the build if there's an error while generating sources from IDLs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeDirs", 2);
                this.append(sb, "Additional include directories containing additional *.idl files required for compilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-test-sources/idl)", 2);
                this.append(sb, "The directory to output the generated sources to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourceDirectory (Default: ${basedir}/src/test/idl)", 2);
                this.append(sb, "The source directory containing *.idl files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "A List of Source configurations to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "The granularity in milliseconds of the last modification date for testing whether a source needs recompilation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timestampDirectory (Default: ${project.build.directory}/idlj-timestamp)", 2);
                this.append(sb, "The directory to store the processed grammars. Used so that grammars are not constantly regenerated.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "idlj:help", 0);
            this.append(sb, "Display help information on idlj-maven-plugin. Call\n\u00a0\u00a0mvn\u00a0idlj:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = this.toLines(description, indent).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private List toLines(String text, int indent) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            this.toLines(lines, ind + plainLines[i]);
        }
        return lines;
    }

    private void toLines(List lines, String line) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= this.lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * this.indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", this.indentSize - buf.length() % this.indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

