/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.fitnesse;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.fitnesse.FileUtil;

public class FitnessePage {
    public static final String STATUS_OK = "OK";
    public static final String STATUS_FAIL = "Fail";
    public static final String STATUS_ERROR = "Error";
    private File mResultFile;
    private String mResultContent;

    public FitnessePage(File resultFile) {
        this.mResultFile = resultFile;
    }

    public FitnessePage(String resultContent) {
        this.mResultContent = resultContent;
    }

    public FitnessePage() {
    }

    public boolean isFitnessePageResult() {
        return this.mResultFile.getName().startsWith("fitnesseResult") && this.mResultFile.getName().endsWith(".html") && !this.mResultFile.getName().endsWith("_output.html");
    }

    String getFitnessePageName() throws MavenReportException {
        String tPageName = this.mResultFile.getName();
        if (tPageName.length() < "fitnesseResult".length() + 5) {
            throw new MavenReportException("Invalid report Name " + this.mResultFile.getName() + ", the name should match [" + "fitnesseResult" + "Xxx.xml]");
        }
        tPageName = tPageName.substring("fitnesseResult".length() + 1, tPageName.length() - 5);
        return tPageName;
    }

    public String getName() {
        return this.mResultFile.getName();
    }

    public File getResultFile() {
        return this.mResultFile;
    }

    public void setFileName(String pFileName) {
        this.mResultFile = new File(pFileName);
    }

    public String getStatus() throws MojoExecutionException {
        try {
            if (this.mResultContent == null) {
                this.mResultContent = FileUtil.getString(this.mResultFile);
            }
            if (this.mResultContent.indexOf("document.getElementById(\"test-summary\").className = \"pass") >= 0) {
                return STATUS_OK;
            }
            if (this.mResultContent.indexOf("document.getElementById(\"test-summary\").className = \"fail") >= 0) {
                return STATUS_FAIL;
            }
            if (this.mResultContent.indexOf("document.getElementById(\"test-summary\").className = \"error") >= 0) {
                return STATUS_ERROR;
            }
            throw new MojoExecutionException("This file isn't a FitNesse result page [" + this.mResultFile.getAbsolutePath() + "]");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Invalid file name [" + this.mResultFile.getAbsolutePath() + "]");
        }
    }
}

