/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.plugins.enforcer.AbstractResolveDependencies;
import org.apache.maven.plugins.enforcer.ClassFile;
import org.apache.maven.plugins.enforcer.ClassesWithSameName;
import org.apache.maven.plugins.enforcer.InputStreamSupplier;
import org.apache.maven.plugins.enforcer.JarUtils;
import org.codehaus.mojo.enforcer.Dependency;
import org.codehaus.plexus.util.FileUtils;

public class BanDuplicateClasses
extends AbstractResolveDependencies {
    private static final String[] DEFAULT_CLASSES_IGNORES = new String[]{"module-info", "META-INF/versions/*/module-info"};
    private String message;
    private String[] ignoreClasses;
    private boolean findAllDuplicates;
    private List<Dependency> dependencies;
    private List<String> scopes;
    private boolean ignoreWhenIdentical;

    @Override
    protected void handleArtifacts(Set<Artifact> artifacts) throws EnforcerRuleException {
        ArrayList<AbstractResolveDependencies.IgnorableDependency> ignorableDependencies = new ArrayList<AbstractResolveDependencies.IgnorableDependency>();
        AbstractResolveDependencies.IgnorableDependency ignoreableClasses = new AbstractResolveDependencies.IgnorableDependency();
        ignoreableClasses.applyIgnoreClasses(DEFAULT_CLASSES_IGNORES, false);
        if (this.ignoreClasses != null) {
            ignoreableClasses.applyIgnoreClasses(this.ignoreClasses, false);
        }
        ignorableDependencies.add(ignoreableClasses);
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                this.getLog().info((CharSequence)("Adding ignorable dependency: " + dependency));
                AbstractResolveDependencies.IgnorableDependency ignorableDependency = new AbstractResolveDependencies.IgnorableDependency();
                if (dependency.getGroupId() != null) {
                    ignorableDependency.groupId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getGroupId()));
                }
                if (dependency.getArtifactId() != null) {
                    ignorableDependency.artifactId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getArtifactId()));
                }
                if (dependency.getType() != null) {
                    ignorableDependency.type = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getType()));
                }
                if (dependency.getClassifier() != null) {
                    ignorableDependency.classifier = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getClassifier()));
                }
                ignorableDependency.applyIgnoreClasses(dependency.getIgnoreClasses(), true);
                ignorableDependencies.add(ignorableDependency);
            }
        }
        HashMap<String, ClassesWithSameName> classesSeen = new HashMap<String, ClassesWithSameName>();
        HashSet<String> duplicateClassNames = new HashSet<String>();
        for (Artifact artifact : artifacts) {
            if (this.scopes != null && !this.scopes.contains(artifact.getScope())) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping " + artifact + " due to scope"));
                continue;
            }
            File file = artifact.getFile();
            this.getLog().debug((CharSequence)("Searching for duplicate classes in " + file));
            if (file == null || !file.exists()) {
                this.getLog().warn((CharSequence)("Could not find " + artifact + " at " + file));
                continue;
            }
            if (file.isDirectory()) {
                try {
                    for (Object name : FileUtils.getFileNames((File)file, null, null, (boolean)false)) {
                        this.getLog().debug((CharSequence)("  " + (String)name));
                        this.checkAndAddName(artifact, (String)name, () -> BanDuplicateClasses.lambda$handleArtifacts$0(file, (String)name), classesSeen, duplicateClassNames, ignorableDependencies);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Unable to process dependency " + artifact + " due to " + e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (!JarUtils.isJarFile(artifact)) continue;
            try (JarFile jar = new JarFile(file);){
                Object name;
                name = Collections.list(jar.entries()).iterator();
                while (name.hasNext()) {
                    JarEntry entry = (JarEntry)name.next();
                    String fileName = entry.getName();
                    this.checkAndAddName(artifact, fileName, () -> jar.getInputStream(entry), classesSeen, duplicateClassNames, ignorableDependencies);
                }
            }
            catch (IOException e) {
                throw new EnforcerRuleException("Unable to process dependency " + artifact + " due to " + e.getLocalizedMessage(), (Exception)e);
            }
        }
        if (!duplicateClassNames.isEmpty()) {
            HashMap<Set<Artifact>, ArrayList<String>> inverted = new HashMap<Set<Artifact>, ArrayList<String>>();
            for (String className : duplicateClassNames) {
                ClassesWithSameName classesWithSameName = (ClassesWithSameName)classesSeen.get(className);
                Set<Artifact> artifactsOfDuplicateClass = classesWithSameName.getAllArtifactsThisClassWasFoundIn();
                ArrayList<String> s = (ArrayList<String>)inverted.get(artifactsOfDuplicateClass);
                if (s == null) {
                    s = new ArrayList<String>();
                }
                s.add(classesWithSameName.toOutputString(this.ignoreWhenIdentical));
                inverted.put(artifactsOfDuplicateClass, s);
            }
            StringBuilder stringBuilder = new StringBuilder(this.message == null ? "Duplicate classes found:" : this.message);
            stringBuilder.append('\n');
            for (Map.Entry entry : inverted.entrySet()) {
                stringBuilder.append("\n  Found in:");
                for (Artifact a : (Set)entry.getKey()) {
                    stringBuilder.append("\n    ");
                    stringBuilder.append(a);
                }
                stringBuilder.append("\n  Duplicate classes:");
                for (String classNameWithDuplicationInfo : (List)entry.getValue()) {
                    stringBuilder.append("\n    ");
                    stringBuilder.append(classNameWithDuplicationInfo);
                }
                stringBuilder.append('\n');
            }
            throw new EnforcerRuleException(stringBuilder.toString());
        }
    }

    private void checkAndAddName(Artifact artifact, String pathToClassFile, InputStreamSupplier inputStreamSupplier, Map<String, ClassesWithSameName> classesSeen, Set<String> duplicateClasses, Collection<AbstractResolveDependencies.IgnorableDependency> ignores) throws EnforcerRuleException, IOException {
        if (!pathToClassFile.endsWith(".class")) {
            return;
        }
        for (AbstractResolveDependencies.IgnorableDependency c : ignores) {
            if (!c.matchesArtifact(artifact) || !c.matches(pathToClassFile)) continue;
            if (classesSeen.containsKey(pathToClassFile)) {
                this.getLog().debug((CharSequence)("Ignoring excluded class " + pathToClassFile));
            }
            return;
        }
        ClassesWithSameName classesWithSameName = classesSeen.get(pathToClassFile);
        boolean isFirstTimeSeeingThisClass = classesWithSameName == null;
        ClassFile classFile = new ClassFile(pathToClassFile, artifact, inputStreamSupplier);
        if (isFirstTimeSeeingThisClass) {
            classesSeen.put(pathToClassFile, new ClassesWithSameName(this.getLog(), classFile, new ClassFile[0]));
            return;
        }
        classesWithSameName.add(classFile);
        if (!classesWithSameName.hasDuplicates(this.ignoreWhenIdentical)) {
            return;
        }
        if (!this.findAllDuplicates) {
            Artifact previousArtifact = classesWithSameName.previous().getArtifactThisClassWasFoundIn();
            String buf = (this.message == null ? "Duplicate class found:" : this.message) + '\n' + "\n  Found in:\n    " + previousArtifact + "\n    " + artifact + "\n  Duplicate classes:\n    " + pathToClassFile + '\n' + "There may be others but <findAllDuplicates> was set to false, so failing fast";
            throw new EnforcerRuleException(buf);
        }
        duplicateClasses.add(pathToClassFile);
    }

    private static /* synthetic */ InputStream lambda$handleArtifacts$0(File file, String name) throws IOException {
        return Files.newInputStream(file.toPath().resolve(name), new OpenOption[0]);
    }
}

