/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.ArrayList;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.toolchain.MisconfiguredToolchainException;
import org.apache.maven.toolchain.ToolchainFactory;
import org.apache.maven.toolchain.ToolchainPrivate;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.mojo.exec.PathsToolchain;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Named(value="paths")
@Singleton
class PathsToolchainFactory
implements ToolchainFactory {
    PathsToolchainFactory() {
    }

    public ToolchainPrivate createToolchain(ToolchainModel model) throws MisconfiguredToolchainException {
        if (model == null) {
            return null;
        }
        PathsToolchain pathsToolchain = new PathsToolchain(model);
        Xpp3Dom config = (Xpp3Dom)model.getConfiguration();
        if (config == null) {
            return pathsToolchain;
        }
        Xpp3Dom pathDom = config.getChild("paths");
        if (pathDom == null) {
            throw new MisconfiguredToolchainException("paths element is empty");
        }
        Xpp3Dom[] pathDoms = pathDom.getChildren("path");
        if (pathDoms == null || pathDoms.length == 0) {
            throw new MisconfiguredToolchainException("paths -> path elements are not present");
        }
        ArrayList<String> paths = new ArrayList<String>(pathDoms.length);
        for (Xpp3Dom pathdom : pathDoms) {
            String pathString = pathdom.getValue();
            if (pathString == null) {
                throw new MisconfiguredToolchainException("path element is empty");
            }
            String normalizedPath = FileUtils.normalize((String)pathString);
            File file = new File(normalizedPath);
            if (!file.exists()) {
                throw new MisconfiguredToolchainException("Non-existing path '" + file.getAbsolutePath() + "'");
            }
            paths.add(normalizedPath);
        }
        pathsToolchain.setPaths(paths);
        return pathsToolchain;
    }

    public ToolchainPrivate createDefaultToolchain() {
        return null;
    }
}

