/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.AbstractPath;
import org.codehaus.mojo.exec.Classpath;
import org.codehaus.mojo.exec.EnvStreamConsumer;
import org.codehaus.mojo.exec.ExtendedExecutor;
import org.codehaus.mojo.exec.LineRedirectOutputStream;
import org.codehaus.mojo.exec.Modulepath;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="exec", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecMojo
extends AbstractExecMojo {
    private static final Pattern ENDS_WITH_JAVA = Pattern.compile("^.*java(\\.exe|\\.bin)?$", 2);
    @Parameter(property="exec.executable")
    private String executable;
    @Parameter(property="exec.timeout", defaultValue="0")
    private int timeout;
    @Parameter(property="exec.toolchain", defaultValue="jdk")
    private String toolchain;
    @Parameter(property="exec.workingdir")
    private File workingDirectory;
    @Parameter(property="exec.outputFile")
    private File outputFile;
    @Parameter(property="exec.inheritIo")
    private boolean inheritIo;
    @Parameter(property="exec.useMavenLogger", defaultValue="false")
    private boolean useMavenLogger;
    @Parameter(property="exec.quietLogs", defaultValue="false")
    private boolean quietLogs;
    @Parameter
    private List<?> arguments;
    @Parameter(readonly=true, required=true, defaultValue="${basedir}")
    private File basedir;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    private File environmentScript = null;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter
    private int[] successCodes;
    @Parameter(property="exec.longClasspath", defaultValue="false")
    private boolean longClasspath;
    @Parameter(property="exec.longModulepath", defaultValue="true")
    private boolean longModulepath;
    @Parameter(property="exec.forceJava", defaultValue="false")
    private boolean forceJava;
    @Parameter(property="exec.async", defaultValue="false")
    private boolean async;
    @Parameter(property="exec.asyncDestroyOnShutdown", defaultValue="true")
    private boolean asyncDestroyOnShutdown = true;
    @Component
    private ToolchainManager toolchainManager;
    public static final String CLASSPATH_TOKEN = "%classpath";
    public static final String MODULEPATH_TOKEN = "%modulepath";
    private ProcessDestroyer processDestroyer;

    public void execute() throws MojoExecutionException {
        if (this.executable == null) {
            if (this.executableDependency == null) {
                throw new MojoExecutionException("The parameter 'executable' is missing or invalid");
            }
            this.executable = this.findExecutableArtifact().getFile().getAbsolutePath();
            this.getLog().debug((CharSequence)("using executable dependency " + this.executable));
        }
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        try {
            this.handleWorkingDirectory();
            String argsProp = this.getSystemProperty("exec.args");
            ArrayList<String> commandArguments = new ArrayList<String>();
            if (this.hasCommandlineArgs()) {
                this.handleCommandLineArgs(commandArguments);
            } else if (!StringUtils.isEmpty((String)argsProp)) {
                this.handleSystemPropertyArguments(argsProp, commandArguments);
            } else if (this.arguments != null) {
                this.handleArguments(commandArguments);
            }
            Map<String, String> enviro = this.handleSystemEnvVariables();
            CommandLine commandLine = this.getExecutablePath(enviro, this.workingDirectory);
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            ExtendedExecutor exec = new ExtendedExecutor(this.inheritIo);
            if (this.timeout > 0) {
                exec.setWatchdog(new ExecuteWatchdog((long)this.timeout));
            }
            exec.setWorkingDirectory(this.workingDirectory);
            this.fillSuccessCodes((Executor)exec);
            if (OS.isFamilyOpenVms() && this.inheritIo) {
                this.getLog().warn((CharSequence)"The inheritIo flag is not supported on OpenVMS, execution will proceed without stream inheritance.");
            }
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            try {
                int resultCode;
                block36: {
                    if (this.outputFile != null) {
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        try (FileOutputStream outputStream = new FileOutputStream(this.outputFile);){
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                    }
                    if (this.useMavenLogger) {
                        this.getLog().debug((CharSequence)"Will redirect program output to Maven logger");
                        String logPrefix = this.session.isParallel() ? "[" + Thread.currentThread().getName() + "] " : "";
                        Consumer<String> mavenOutRedirect = logMessage -> {
                            if (this.quietLogs) {
                                this.getLog().debug((CharSequence)(logPrefix + logMessage));
                            } else {
                                this.getLog().info((CharSequence)(logPrefix + logMessage));
                            }
                        };
                        Consumer<String> mavenErrRedirect = logMessage -> this.getLog().error((CharSequence)(logPrefix + logMessage));
                        try (LineRedirectOutputStream out = new LineRedirectOutputStream(mavenOutRedirect);
                             LineRedirectOutputStream err = new LineRedirectOutputStream(mavenErrRedirect);){
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, out, err);
                            break block36;
                        }
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (this.isResultCodeAFailure(resultCode)) {
                    String message = "Result of " + commandLine.toString() + " execution is: '" + resultCode + "'.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
            }
            catch (ExecuteException e) {
                if (exec.getWatchdog() != null && exec.getWatchdog().killedProcess()) {
                    String message = "Timeout. Process runs longer than " + this.timeout + " ms.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message, (Exception)((Object)e));
                }
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
            this.registerSourceRoots();
        }
        catch (IOException e) {
            throw new MojoExecutionException("I/O Error", (Exception)e);
        }
    }

    private Map<String, String> handleSystemEnvVariables() throws MojoExecutionException {
        HashMap<String, String> enviro = new HashMap<String, String>();
        Properties systemEnvVars = CommandLineUtils.getSystemEnvVars();
        for (Map.Entry<Object, Object> entry : systemEnvVars.entrySet()) {
            enviro.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.environmentVariables != null) {
            enviro.putAll(this.environmentVariables);
        }
        if (this.environmentScript != null) {
            this.getLog().info((CharSequence)("Pick up external environment script: " + this.environmentScript));
            Map<String, String> envVarsFromScript = this.createEnvs(this.environmentScript);
            if (envVarsFromScript != null) {
                enviro.putAll(envVarsFromScript);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            TreeSet keys = new TreeSet();
            keys.addAll(enviro.keySet());
            for (String key : keys) {
                this.getLog().debug((CharSequence)("env: " + key + "=" + (String)enviro.get(key)));
            }
        }
        return enviro;
    }

    private void handleWorkingDirectory() throws MojoExecutionException {
        if (this.workingDirectory == null) {
            this.workingDirectory = this.basedir;
        }
        if (!this.workingDirectory.exists()) {
            this.getLog().debug((CharSequence)("Making working directory '" + this.workingDirectory.getAbsolutePath() + "'."));
            if (!this.workingDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not make working directory: '" + this.workingDirectory.getAbsolutePath() + "'");
            }
        }
    }

    private void handleSystemPropertyArguments(String argsProp, List<String> commandArguments) throws MojoExecutionException {
        this.getLog().debug((CharSequence)("got arguments from system properties: " + argsProp));
        try {
            String[] args = CommandLineUtils.translateCommandline((String)argsProp);
            commandArguments.addAll(Arrays.asList(args));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't parse systemproperty 'exec.args'");
        }
    }

    private void handleCommandLineArgs(List<String> commandArguments) throws MojoExecutionException, IOException {
        String[] args = this.parseCommandlineArgs();
        for (int i = 0; i < args.length; ++i) {
            if (this.isLongClassPathArgument(args[i])) {
                commandArguments.add("-jar");
                File tmpFile = this.createJar(this.computePath(null), args[i + 2]);
                commandArguments.add(tmpFile.getAbsolutePath());
                i += 2;
                continue;
            }
            if (args[i].contains(CLASSPATH_TOKEN)) {
                commandArguments.add(args[i].replace(CLASSPATH_TOKEN, this.computeClasspathString(null)));
                continue;
            }
            commandArguments.add(args[i]);
        }
    }

    private void handleArguments(List<String> commandArguments) throws MojoExecutionException, IOException {
        String specialArg = null;
        for (int i = 0; i < this.arguments.size(); ++i) {
            Object argument = this.arguments.get(i);
            if (specialArg != null) {
                if (this.isLongClassPathArgument(specialArg) && argument instanceof Classpath) {
                    commandArguments.add("-jar");
                    File tmpFile = this.createJar(this.computePath((Classpath)argument), (String)this.arguments.get(++i));
                    commandArguments.add(tmpFile.getAbsolutePath());
                } else if (this.isLongModulePathArgument(specialArg) && argument instanceof Modulepath) {
                    String filePath = new File(this.buildDirectory, "modulepath").getAbsolutePath();
                    StringBuilder modulePath = new StringBuilder();
                    modulePath.append('\"');
                    Iterator<String> it = this.computePath((Modulepath)argument).iterator();
                    while (it.hasNext()) {
                        modulePath.append(it.next().replace("\\", "\\\\"));
                        if (!it.hasNext()) continue;
                        modulePath.append(File.pathSeparatorChar);
                    }
                    modulePath.append('\"');
                    this.createArgFile(filePath, Arrays.asList("-p", modulePath.toString()));
                    commandArguments.add('@' + filePath);
                } else {
                    commandArguments.add(specialArg);
                }
                specialArg = null;
                continue;
            }
            if (argument instanceof Classpath) {
                Classpath specifiedClasspath = (Classpath)argument;
                commandArguments.add(this.computeClasspathString(specifiedClasspath));
                continue;
            }
            if (argument instanceof Modulepath) {
                Modulepath specifiedModulepath = (Modulepath)argument;
                commandArguments.add(this.computeClasspathString(specifiedModulepath));
                continue;
            }
            if (argument instanceof String && (this.isLongModulePathArgument((String)argument) || this.isLongClassPathArgument((String)argument))) {
                specialArg = (String)argument;
                continue;
            }
            if (argument == null) {
                commandArguments.add("");
                continue;
            }
            commandArguments.add((String)argument);
        }
    }

    private void fillSuccessCodes(Executor exec) {
        if (this.successCodes != null && this.successCodes.length > 0) {
            exec.setExitValues(this.successCodes);
        }
    }

    boolean isResultCodeAFailure(int result) {
        if (this.successCodes == null || this.successCodes.length == 0) {
            return result != 0;
        }
        for (int successCode : this.successCodes) {
            if (successCode != result) continue;
            return false;
        }
        return true;
    }

    private boolean isLongClassPathArgument(String arg) {
        return this.isJavaExec() && this.longClasspath && ("-classpath".equals(arg) || "-cp".equals(arg));
    }

    private boolean isLongModulePathArgument(String arg) {
        return this.isJavaExec() && this.longModulepath && ("--module-path".equals(arg) || "-p".equals(arg));
    }

    private boolean isJavaExec() {
        if (this.forceJava) {
            return true;
        }
        if (this.executable.contains("%JAVA_HOME") || this.executable.contains("${JAVA_HOME}") || this.executable.contains("$JAVA_HOME")) {
            return true;
        }
        return ENDS_WITH_JAVA.matcher(this.executable).matches();
    }

    private String computeClasspathString(AbstractPath specifiedClasspath) {
        List<String> resultList = this.computePath(specifiedClasspath);
        StringBuffer theClasspath = new StringBuffer();
        for (String str : resultList) {
            ExecMojo.addToClasspath(theClasspath, str);
        }
        return theClasspath.toString();
    }

    private List<String> computePath(AbstractPath specifiedClasspath) {
        List<Artifact> artifacts = new ArrayList<Artifact>();
        ArrayList<Path> theClasspathFiles = new ArrayList<Path>();
        ArrayList<String> resultList = new ArrayList<String>();
        this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
        if (specifiedClasspath != null && specifiedClasspath.getDependencies() != null) {
            artifacts = this.filterArtifacts(artifacts, specifiedClasspath.getDependencies());
        }
        for (Path f : theClasspathFiles) {
            resultList.add(f.toAbsolutePath().toString());
        }
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("dealing with " + artifact));
            resultList.add(artifact.getFile().getAbsolutePath());
        }
        return resultList;
    }

    private static void addToClasspath(StringBuffer theClasspath, String toAdd) {
        if (theClasspath.length() > 0) {
            theClasspath.append(File.pathSeparator);
        }
        theClasspath.append(toAdd);
    }

    private List<Artifact> filterArtifacts(List<Artifact> artifacts, Collection<String> dependencies) {
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new IncludesArtifactFilter(new ArrayList<String>(dependencies)));
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            this.getLog().debug((CharSequence)("filtering in " + artifact));
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    CommandLine getExecutablePath(Map<String, String> enviro, File dir) {
        CommandLine toRet;
        File execFile = new File(this.executable);
        String exec = null;
        if (execFile.isFile()) {
            this.getLog().debug((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + this.executable));
            exec = execFile.getAbsolutePath();
        }
        if (exec == null) {
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in exec-maven-plugin: " + tc));
                exec = tc.findTool(this.executable);
            } else if (OS.isFamilyWindows()) {
                List<String> paths = this.getExecutablePaths(enviro);
                paths.add(0, dir.getAbsolutePath());
                exec = ExecMojo.findExecutable(this.executable, paths);
            }
        }
        if (exec == null) {
            exec = this.executable;
        }
        if (OS.isFamilyWindows() && !ExecMojo.hasNativeExtension(exec) && ExecMojo.hasExecutableExtension(exec)) {
            String comSpec = System.getenv("ComSpec");
            toRet = new CommandLine(comSpec == null ? "cmd" : comSpec);
            toRet.addArgument("/c");
            toRet.addArgument(exec);
        } else {
            toRet = new CommandLine(exec);
        }
        return toRet;
    }

    static String findExecutable(String executable, List<String> paths) {
        File f = null;
        block0: for (String path : paths) {
            f = new File(path, executable);
            if (!OS.isFamilyWindows() && f.isFile()) break;
            for (String extension : ExecMojo.getExecutableExtensions()) {
                f = new File(path, executable + extension);
                if (!f.isFile()) continue;
                break block0;
            }
        }
        if (f == null || !f.exists()) {
            return null;
        }
        return f.getAbsolutePath();
    }

    private static boolean hasNativeExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        return lowerCase.endsWith(".exe") || lowerCase.endsWith(".com");
    }

    private static boolean hasExecutableExtension(String exec) {
        String lowerCase = exec.toLowerCase();
        for (String ext : ExecMojo.getExecutableExtensions()) {
            if (!lowerCase.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private static List<String> getExecutableExtensions() {
        String pathExt = System.getenv("PATHEXT");
        return pathExt == null ? Arrays.asList(".bat", ".cmd") : Arrays.asList(StringUtils.split((String)pathExt.toLowerCase(), (String)File.pathSeparator));
    }

    private List<String> getExecutablePaths(Map<String, String> enviro) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("");
        String path = enviro.get("PATH");
        if (path != null) {
            paths.addAll(Arrays.asList(StringUtils.split((String)path, (String)File.pathSeparator)));
        }
        return paths;
    }

    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, OutputStream out, OutputStream err) throws IOException {
        PumpStreamHandler psh = new PumpStreamHandler(out, err, System.in);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    protected int executeCommandLine(Executor exec, CommandLine commandLine, Map<String, String> enviro, FileOutputStream outputFile) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(outputFile);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
        return this.executeCommandLine(exec, commandLine, enviro, psh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeCommandLine(Executor exec, final CommandLine commandLine, Map<String, String> enviro, final PumpStreamHandler psh) throws IOException {
        int result;
        exec.setStreamHandler((ExecuteStreamHandler)psh);
        try {
            psh.start();
            if (this.async) {
                if (this.asyncDestroyOnShutdown) {
                    exec.setProcessDestroyer(this.getProcessDestroyer());
                }
                exec.execute(commandLine, enviro, new ExecuteResultHandler(){

                    public void onProcessFailed(ExecuteException e) {
                        ExecMojo.this.getLog().error((CharSequence)("Async process failed for: " + commandLine), (Throwable)e);
                    }

                    public void onProcessComplete(int exitValue) {
                        ExecMojo.this.getLog().info((CharSequence)("Async process complete, exit value = " + exitValue + " for: " + commandLine));
                        try {
                            psh.stop();
                        }
                        catch (IOException e) {
                            ExecMojo.this.getLog().error((CharSequence)("Error stopping async process stream handler for: " + commandLine), (Throwable)e);
                        }
                    }
                });
                result = 0;
            } else {
                result = exec.execute(commandLine, enviro);
            }
        }
        finally {
            if (!this.async) {
                psh.stop();
            }
        }
        return result;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    String getExecutable() {
        return this.executable;
    }

    void setWorkingDirectory(String workingDir) {
        this.setWorkingDirectory(new File(workingDir));
    }

    void setWorkingDirectory(File workingDir) {
        this.workingDirectory = workingDir;
    }

    void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    void setProject(MavenProject project) {
        this.project = project;
    }

    protected String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    public void setSuccessCodes(Integer ... list) {
        this.successCodes = new int[list.length];
        for (int index = 0; index < list.length; ++index) {
            this.successCodes[index] = list[index];
        }
    }

    public int[] getSuccessCodes() {
        return this.successCodes;
    }

    private Toolchain getToolchain() {
        if (this.session != null && this.toolchainManager != null) {
            return this.toolchainManager.getToolchainFromBuildContext(this.toolchain, this.session);
        }
        return null;
    }

    private File createJar(List<String> classPath, String mainClass) throws IOException {
        File file = Files.createTempFile("maven-exec", ".jar", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(file);
             JarOutputStream jos = new JarOutputStream(fos);){
            jos.setLevel(0);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            jos.putNextEntry(je);
            Manifest man = new Manifest();
            StringBuilder cp = new StringBuilder();
            for (String el : classPath) {
                cp.append(new URL(new File(el).toURI().toASCIIString()).toExternalForm() + " ");
            }
            man.getMainAttributes().putValue("Manifest-Version", "1.0");
            man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            man.getMainAttributes().putValue("Main-Class", mainClass);
            man.write(jos);
        }
        return file;
    }

    private void createArgFile(String filePath, List<String> lines) throws IOException {
        String EOL = System.getProperty("line.separator", "\\n");
        try (FileWriter writer = new FileWriter(filePath);){
            for (String line : lines) {
                writer.append(line).append(EOL);
            }
        }
    }

    protected Map<String, String> createEnvs(File envScriptFile) throws MojoExecutionException {
        Map<String, String> results = null;
        File tmpEnvExecFile = null;
        try {
            tmpEnvExecFile = this.createEnvWrapperFile(envScriptFile);
            Commandline cl = new Commandline();
            cl.setExecutable(tmpEnvExecFile.getAbsolutePath());
            if (!OS.isFamilyWindows()) {
                cl.setExecutable("sh");
                cl.createArg().setFile(tmpEnvExecFile);
            }
            if (this.environmentVariables != null) {
                for (Map.Entry<String, String> item : this.environmentVariables.entrySet()) {
                    cl.addEnvironment(item.getKey(), item.getValue());
                }
            }
            EnvStreamConsumer stdout = new EnvStreamConsumer();
            DefaultConsumer stderr = new DefaultConsumer();
            CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (!stdout.getUnparsedLines().isEmpty()) {
                this.getLog().warn((CharSequence)"The following lines could not be parsed into environment variables :");
                for (String line : stdout.getUnparsedLines()) {
                    this.getLog().warn((CharSequence)line);
                }
            }
            results = stdout.getParsedEnv();
        }
        catch (IOException | CommandLineException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            if (tmpEnvExecFile != null) {
                tmpEnvExecFile.delete();
            }
        }
        return results;
    }

    protected File createEnvWrapperFile(File envScript) throws IOException {
        File tmpFile = null;
        if (OS.isFamilyWindows()) {
            tmpFile = Files.createTempFile("env", ".bat", new FileAttribute[0]).toFile();
            try (PrintWriter writer = new PrintWriter(tmpFile);){
                writer.append("@echo off").println();
                writer.append("call \"").append(envScript.getCanonicalPath()).append("\"").println();
                writer.append("echo ================================This is the beginning of env parsing================================").println();
                writer.append("set").println();
                writer.flush();
            }
        }
        tmpFile = Files.createTempFile("env", ".sh", new FileAttribute[0]).toFile();
        try (PrintWriter writer = new PrintWriter(tmpFile);){
            writer.append("#! /bin/sh").println();
            writer.append(". ").append(envScript.getCanonicalPath()).println();
            writer.append("echo ================================This is the beginning of env parsing================================").println();
            writer.append("env").println();
            writer.flush();
        }
        return tmpFile;
    }

    protected ProcessDestroyer getProcessDestroyer() {
        if (this.processDestroyer == null) {
            this.processDestroyer = new ShutdownHookProcessDestroyer();
        }
        return this.processDestroyer;
    }
}

