/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringInputStream;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.interpolation.MapBasedValueSource;
import org.codehaus.plexus.util.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.util.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.util.interpolation.ValueSource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MavenUtils {
    private static MavenUtils mavenUtils = null;

    private MavenUtils() {
    }

    public static MavenUtils getInstance() {
        if (mavenUtils == null) {
            mavenUtils = new MavenUtils();
        }
        return mavenUtils;
    }

    public String getConfiguration(MavenProject project, String pluginArtifact, String pluginGroupId, String optionName, String defaultValue) {
        String result = null;
        String value = "";
        try {
            value = this.getMavenPluginConfiguration(project, pluginArtifact, pluginGroupId, optionName, "");
            if (value != null && value.length() > 0) {
                if (value.indexOf("$") > -1) {
                    result = this.getInterpolatorValue(project, value);
                } else {
                    File dir = new File(value);
                    boolean isExists = dir.exists();
                    if (!isExists) {
                        File resultFile = FileUtils.resolveFile((File)project.getBasedir(), (String)value);
                        result = resultFile.getAbsolutePath();
                    } else {
                        result = value;
                    }
                }
            } else {
                result = this.getInterpolatorValue(project, defaultValue);
            }
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    private String getInterpolatorValue(MavenProject project, String value) {
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource((ValueSource)new ObjectBasedValueSource((Object)project));
        interpolator.addValueSource((ValueSource)new MapBasedValueSource((Map)project.getProperties()));
        String result = interpolator.interpolate(value, "project");
        return result;
    }

    private String getMavenPluginConfiguration(MavenProject project, String pluginArtifact, String pluginGroupId, String optionName, String defaultValue) throws IOException {
        Iterator it = project.getModel().getBuild().getPlugins().iterator();
        while (it.hasNext()) {
            Xpp3Dom pluginConf;
            Plugin plugin = (Plugin)it.next();
            if (!plugin.getGroupId().equals(pluginGroupId) || !plugin.getArtifactId().equals(pluginArtifact) || (pluginConf = (Xpp3Dom)plugin.getConfiguration()) == null) continue;
            StringBuffer sb = new StringBuffer();
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(pluginConf.toString()));
                XObject obj = XPathAPI.eval((Node)doc, (String)("//configuration//" + optionName));
                if (!StringUtils.isNotEmpty((String)obj.toString())) continue;
                StringTokenizer token = new StringTokenizer(obj.toString(), "\n ");
                while (token.hasMoreTokens()) {
                    sb.append(token.nextToken().trim());
                    if (!token.hasMoreElements()) continue;
                    sb.append(",");
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new IOException("Exception occured" + e.getMessage());
            }
        }
        return defaultValue;
    }
}

