/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.NumberFormat;
import java.util.Locale;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.CloverBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.CoberturaBarChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartStrategy;
import org.codehaus.mojo.dashboard.report.plugin.chart.MultiCloverBarChartStrategy;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.ui.RectangleInsets;

public class BarChartRenderer
extends AbstractChartRenderer {
    private static final double NUMBER_AXIS_RANGE = 1.0;

    public BarChartRenderer(IChartStrategy strategy) {
        super(strategy);
    }

    public BarChartRenderer(IChartStrategy strategy, int width, int height) {
        super(strategy, width, height);
    }

    public void createChart() {
        CategoryDataset categorydataset = (CategoryDataset)this.datasetStrategy.getDataset();
        this.report = ChartFactory.createBarChart((String)this.datasetStrategy.getTitle(), (String)this.datasetStrategy.getYAxisLabel(), (String)this.datasetStrategy.getXAxisLabel(), (CategoryDataset)categorydataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        this.report.setPadding(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        CategoryPlot categoryplot = (CategoryPlot)this.report.getPlot();
        categoryplot.setBackgroundPaint((Paint)Color.white);
        categoryplot.setRangeGridlinePaint((Paint)Color.lightGray);
        categoryplot.setDomainGridlinePaint((Paint)Color.lightGray);
        categoryplot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        NumberAxis numberaxis = (NumberAxis)categoryplot.getRangeAxis();
        if (this.datasetStrategy instanceof CoberturaBarChartStrategy || this.datasetStrategy instanceof CloverBarChartStrategy || this.datasetStrategy instanceof MultiCloverBarChartStrategy) {
            numberaxis.setRange(0.0, 1.0);
            numberaxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
        } else {
            numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        numberaxis.setLowerMargin(0.0);
        CategoryAxis axis = categoryplot.getDomainAxis();
        axis.setLowerMargin(0.02);
        axis.setCategoryMargin(0.1);
        axis.setUpperMargin(0.02);
        BarRenderer barrenderer = (BarRenderer)categoryplot.getRenderer();
        barrenderer.setItemMargin(0.1);
        barrenderer.setDrawBarOutline(false);
        barrenderer.setBaseItemLabelsVisible(true);
        if (this.datasetStrategy instanceof CoberturaBarChartStrategy || this.datasetStrategy instanceof CloverBarChartStrategy || this.datasetStrategy instanceof MultiCloverBarChartStrategy) {
            barrenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", NumberFormat.getPercentInstance(Locale.getDefault())));
        } else {
            barrenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        }
        int height = categorydataset.getColumnCount() * 13 * categorydataset.getRowCount();
        if (height > 300) {
            super.setHeight(height);
        } else {
            super.setHeight(300);
        }
        Paint[] paints = this.datasetStrategy.getPaintColor();
        for (int i = 0; i < categorydataset.getRowCount() && i < paints.length; ++i) {
            barrenderer.setSeriesPaint(i, paints[i]);
        }
    }
}

