/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.regex.Pattern;

public class CheckstyleError
implements Cloneable {
    private static final Pattern REGEXP_QUOTE = Pattern.compile("'.*?'");
    private static final Pattern REGEXP_IS_NUMBER = Pattern.compile("is (\\d)+");
    private static final Pattern REGEXP_NUMBER_TIMES = Pattern.compile("(\\d)+ times");
    private static final Pattern REGEXP_DOUBELQUOTE = Pattern.compile("\".*?\"");
    private static final Pattern REGEXP_BRAKET = Pattern.compile("\\[.*?\\]");
    private String nameClass;
    private int nbIteration;
    private String type;
    private String message;

    public CheckstyleError() {
        this.nbIteration = 1;
    }

    public CheckstyleError(String type, String nameClass, String message, int nbIteration) {
        this.type = type;
        this.nameClass = nameClass;
        this.message = message;
        this.nbIteration = nbIteration;
    }

    public CheckstyleError(CheckstyleError object) {
        this.type = object.getType();
        this.nameClass = object.getNameClass();
        this.message = object.getMessage();
        this.nbIteration = object.getNbIteration();
    }

    public String getNameClass() {
        return this.nameClass;
    }

    public int getNbIteration() {
        return this.nbIteration;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setNameClass(String nameClass) {
        this.nameClass = nameClass;
    }

    public void setNbIteration(int nbIteration) {
        this.nbIteration = nbIteration;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMessage(String message) {
        this.message = this.messageTreatment(message);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CheckstyleError)) {
            return false;
        }
        CheckstyleError checkError = new CheckstyleError((CheckstyleError)o);
        return this.message == null && checkError.getMessage() == null || this.message != null && this.message.equals(checkError.getMessage());
    }

    public void increment() {
        ++this.nbIteration;
    }

    public String toString() {
        return "[" + this.type + " ; " + this.nameClass + " ; " + this.message + " ; " + this.nbIteration + "]";
    }

    private String messageTreatment(String message) {
        String finalMessage = REGEXP_QUOTE.matcher(message).replaceAll("'X'");
        finalMessage = REGEXP_IS_NUMBER.matcher(finalMessage).replaceFirst("is 'n'");
        finalMessage = REGEXP_NUMBER_TIMES.matcher(finalMessage).replaceFirst("'n' times");
        finalMessage = REGEXP_DOUBELQUOTE.matcher(finalMessage).replaceAll("\"X\"");
        finalMessage = REGEXP_BRAKET.matcher(finalMessage).replaceAll("[...]");
        return finalMessage;
    }

    protected Object clone() {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("CheckstyleError can't clone");
        }
        return clone;
    }
}

