/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appfuse.utility;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.appfuse.utility.ConfigurationUtility;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.util.ReflectHelper;

public class JDBCConfigurationUtility
extends ConfigurationUtility {
    public static final Log LOG = LogFactory.getLog((Class)(class$org$codehaus$mojo$appfuse$utility$JDBCConfigurationUtility == null ? (class$org$codehaus$mojo$appfuse$utility$JDBCConfigurationUtility = JDBCConfigurationUtility.class$("org.codehaus.mojo.appfuse.utility.JDBCConfigurationUtility")) : class$org$codehaus$mojo$appfuse$utility$JDBCConfigurationUtility));
    private boolean preferBasicCompositeIds = true;
    private String reverseEngineeringStrategyClass;
    private String packageName;
    private List revengFiles = new ArrayList();
    static /* synthetic */ Class class$org$codehaus$mojo$appfuse$utility$JDBCConfigurationUtility;
    static /* synthetic */ Class class$org$hibernate$cfg$reveng$ReverseEngineeringStrategy;

    public Configuration createConfiguration() {
        return new JDBCMetaDataConfiguration();
    }

    public void doConfiguration(Configuration inConfiguration) throws MojoExecutionException {
        JDBCMetaDataConfiguration jmdc = (JDBCMetaDataConfiguration)inConfiguration;
        super.doConfiguration((Configuration)jmdc);
        jmdc.setPreferBasicCompositeIds(this.preferBasicCompositeIds);
        DefaultReverseEngineeringStrategy defaultStrategy = new DefaultReverseEngineeringStrategy();
        ReverseEngineeringSettings qqsettings = new ReverseEngineeringSettings().setDefaultPackageName(this.packageName);
        if (this.packageName != null) {
            defaultStrategy.setSettings(qqsettings);
        }
        DefaultReverseEngineeringStrategy strategy = defaultStrategy;
        if (this.revengFiles.size() == 0) {
            throw new MojoExecutionException("You must specify at least one ReverseEngineeringStrategy File");
        }
        if (this.revengFiles.size() > 0) {
            OverrideRepository or = new OverrideRepository();
            for (int i = 0; i < this.revengFiles.size(); ++i) {
                or.addFile(new File((String)this.revengFiles.get(i)));
            }
            strategy = or.getReverseEngineeringStrategy((ReverseEngineeringStrategy)defaultStrategy);
        }
        if (this.reverseEngineeringStrategyClass != null) {
            strategy = this.loadreverseEngineeringStrategy(this.reverseEngineeringStrategyClass, (ReverseEngineeringStrategy)strategy);
        }
        strategy.setSettings(qqsettings);
        jmdc.setReverseEngineeringStrategy((ReverseEngineeringStrategy)strategy);
        jmdc.readFromJDBC();
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public void setReverseStrategy(String inReverseStrategy) {
        this.reverseEngineeringStrategyClass = inReverseStrategy;
    }

    public void addRevEngFile(String inFileName) {
        this.revengFiles.add(inFileName);
    }

    public void setPreferBasicCompositeIds(boolean inFlag) {
        this.preferBasicCompositeIds = inFlag;
    }

    private ReverseEngineeringStrategy loadreverseEngineeringStrategy(String inClassName, ReverseEngineeringStrategy inDelegate) throws MojoExecutionException {
        try {
            Class clazz = ReflectHelper.classForName((String)inClassName);
            Constructor constructor = clazz.getConstructor(class$org$hibernate$cfg$reveng$ReverseEngineeringStrategy == null ? (class$org$hibernate$cfg$reveng$ReverseEngineeringStrategy = JDBCConfigurationUtility.class$("org.hibernate.cfg.reveng.ReverseEngineeringStrategy")) : class$org$hibernate$cfg$reveng$ReverseEngineeringStrategy);
            return (ReverseEngineeringStrategy)constructor.newInstance(inDelegate);
        }
        catch (NoSuchMethodException ex) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Could not find public " + inClassName + "(ReverseEngineeringStrategy delegate) constructor on ReverseEngineeringStrategy. Trying no-arg version."));
                }
                Class clazz = ReflectHelper.classForName((String)inClassName);
                ReverseEngineeringStrategy rev = (ReverseEngineeringStrategy)clazz.newInstance();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Using non-delegating strategy, thus packagename and revengfile will be ignored.");
                }
                return rev;
            }
            catch (Exception ex1) {
                throw new MojoExecutionException("Could not create or find " + inClassName + " with default no-arg constructor", ex1);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not create or find " + inClassName + " with one argument delegate constructor", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

