/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appfuse.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.util.ReflectHelper;
import org.xml.sax.EntityResolver;

public class ConfigurationUtility {
    public static final Log LOG = LogFactory.getLog((Class)(class$org$codehaus$mojo$appfuse$utility$ConfigurationUtility == null ? (class$org$codehaus$mojo$appfuse$utility$ConfigurationUtility = ConfigurationUtility.class$("org.codehaus.mojo.appfuse.utility.ConfigurationUtility")) : class$org$codehaus$mojo$appfuse$utility$ConfigurationUtility));
    private List fileSets = new ArrayList();
    private Configuration configuration;
    private File configurationFile;
    private File propertyFile;
    private String entityResolver;
    private String namingStrategy;
    static /* synthetic */ Class class$org$codehaus$mojo$appfuse$utility$ConfigurationUtility;

    public void addConfiguredFileSet(FileSet inFileSet) {
        this.fileSets.add(inFileSet);
    }

    public final Configuration getConfiguration() throws MojoExecutionException {
        if (this.configuration == null) {
            this.configuration = this.createConfiguration();
            this.doConfiguration(this.configuration);
            this.configuration.buildMappings();
        }
        return this.configuration;
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected void doConfiguration(Configuration configuration) throws MojoExecutionException {
        Object object;
        Class resolver;
        this.validateParameters();
        if (this.propertyFile != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(this.propertyFile));
            }
            catch (FileNotFoundException ex) {
                throw new MojoExecutionException(this.propertyFile + " not found.", (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Problem while loading " + this.propertyFile, (Exception)ex);
            }
            configuration.setProperties(properties);
        }
        if (this.entityResolver != null) {
            try {
                resolver = ReflectHelper.classForName((String)this.entityResolver, this.getClass());
                object = resolver.newInstance();
                configuration.setEntityResolver((EntityResolver)object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using " + this.entityResolver + " as entity resolver"));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not create or find " + this.entityResolver + " class to use for entity resolvement");
            }
        }
        if (this.namingStrategy != null) {
            try {
                resolver = ReflectHelper.classForName((String)this.namingStrategy, this.getClass());
                object = resolver.newInstance();
                configuration.setNamingStrategy((NamingStrategy)object);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Using " + this.namingStrategy + " as naming strategy"));
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not create or find " + this.namingStrategy + " class to use for naming strategy");
            }
        }
        if (this.configurationFile != null) {
            configuration.configure(this.configurationFile);
        }
        this.addMappings(this.getFiles());
    }

    protected void validateParameters() {
    }

    private void addMappings(File[] inFiles) throws MojoExecutionException {
        for (int i = 0; i < inFiles.length; ++i) {
            File filename = inFiles[i];
            boolean added = this.addFile(filename);
            if (added || !LOG.isDebugEnabled()) continue;
            LOG.debug((Object)(filename + " not added to Configuration"));
        }
    }

    protected boolean addFile(File inFilename) throws MojoExecutionException {
        try {
            if (inFilename.getName().endsWith(".jar")) {
                this.configuration.addJar(inFilename);
                return true;
            }
            this.configuration.addFile(inFilename);
            return true;
        }
        catch (HibernateException ex) {
            throw new MojoExecutionException("Failed in building configuration when adding " + inFilename, (Exception)((Object)ex));
        }
    }

    private File[] getFiles() {
        LinkedList files = new LinkedList();
        return files.toArray(new File[files.size()]);
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public void setConfigurationFile(File inConfigurationFile) {
        this.configurationFile = inConfigurationFile;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public void setPropertyFile(File inPropertyFile) {
        this.propertyFile = inPropertyFile;
    }

    public void setEntityResolver(String inEntityResolverName) {
        this.entityResolver = inEntityResolverName;
    }

    public void setNamingStrategy(String inNamingStrategy) {
        this.namingStrategy = inNamingStrategy;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

