/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml;

import java.util.Collections;
import java.util.Map;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.MetadataPlugin;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.XmlModelMetadata;
import org.codehaus.plexus.util.StringUtils;

public class XmlMetadataPlugin
extends AbstractMetadataPlugin
implements MetadataPlugin {
    public ModelMetadata getModelMetadata(Model model, Map data) {
        return new XmlModelMetadata();
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map data) {
        XmlClassMetadata metadata = new XmlClassMetadata();
        metadata.setTagName(this.getTagName(data));
        metadata.setNamespace(this.nullIfEmpty(data.get("xml.namespace")));
        metadata.setSchemaLocation(this.nullIfEmpty(data.get("xml.schemaLocation")));
        return metadata;
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map data) {
        XmlFieldMetadata metadata = new XmlFieldMetadata();
        String attribute = (String)data.get("xml.attribute");
        metadata.setAttribute(Boolean.valueOf(attribute));
        String trim = (String)data.get("xml.trim");
        if (trim != null) {
            metadata.setTrim(Boolean.valueOf(trim));
        }
        metadata.setTagName(this.getTagName(data));
        String associationTagName = (String)data.get("xml.associationTagName");
        metadata.setAssociationTagName(associationTagName);
        String listStyle = (String)data.get("xml.listStyle");
        metadata.setListStyle(listStyle);
        String format = (String)data.get("xml.format");
        metadata.setFormat(format);
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map data) {
        XmlAssociationMetadata metadata = new XmlAssociationMetadata();
        String mapStyle = (String)data.get("xml.mapStyle");
        metadata.setMapStyle(mapStyle);
        String reference = (String)data.get("xml.reference");
        if (reference != null) {
            metadata.setReference(Boolean.valueOf(reference));
        }
        return metadata;
    }

    public Map getFieldMap(ModelField field, FieldMetadata metadata) {
        return Collections.EMPTY_MAP;
    }

    private String getTagName(Map data) {
        return this.nullIfEmpty(data.get("xml.tagName"));
    }

    private String nullIfEmpty(Object str) {
        return StringUtils.isEmpty((String)((String)str)) ? null : (String)str;
    }
}

