/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;

public class JConstructor {
    private JModifiers modifiers = null;
    private Map<String, JParameter> params = null;
    private JClass declaringClass = null;
    private JSourceCode sourceCode = null;
    private JAnnotations annotations = null;

    public JConstructor(JClass declaringClass) {
        this.declaringClass = declaringClass;
        this.modifiers = new JModifiers();
        this.params = new LinkedHashMap<String, JParameter>();
        this.sourceCode = new JSourceCode();
    }

    public void addParameter(JParameter parameter) throws IllegalArgumentException {
        if (parameter == null) {
            return;
        }
        if (this.params.get(parameter.getName()) != null) {
            StringBuilder err = new StringBuilder();
            err.append("A parameter already exists for the constructor, ");
            err.append(this.declaringClass.getName());
            err.append(", with the name: ");
            err.append(parameter.getName());
            throw new IllegalArgumentException(err.toString());
        }
        this.params.put(parameter.getName(), parameter);
    }

    public JClass getDeclaringClass() {
        return this.declaringClass;
    }

    public JModifiers getModifiers() {
        return this.modifiers;
    }

    public JParameter[] getParameters() {
        return this.params.values().toArray(new JParameter[0]);
    }

    public JSourceCode getSourceCode() {
        return this.sourceCode;
    }

    public void print(JSourceWriter jsw) {
        JAnnotations annotations = this.getAnnotations();
        if (annotations != null) {
            annotations.print(jsw);
        }
        if (this.modifiers.isPrivate()) {
            jsw.write("private");
        } else if (this.modifiers.isProtected()) {
            jsw.write("protected");
        } else {
            jsw.write("public");
        }
        jsw.write(32);
        jsw.write(this.declaringClass.getLocalName());
        jsw.write(40);
        if (!this.params.isEmpty()) {
            Enumeration<JParameter> paramEnum = Collections.enumeration(this.params.values());
            jsw.write(paramEnum.nextElement());
            while (paramEnum.hasMoreElements()) {
                jsw.write(", ");
                jsw.write(paramEnum.nextElement());
            }
        }
        for (int i = 0; i < this.params.size(); ++i) {
        }
        jsw.writeln(')');
        jsw.writeln('{');
        this.sourceCode.print(jsw);
        if (!jsw.isNewline()) {
            jsw.writeln();
        }
        jsw.write("} //-- ");
        jsw.writeln(this.toString());
    }

    public void setModifiers(JModifiers modifiers) {
        this.modifiers = modifiers.copy();
        this.modifiers.setFinal(false);
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = new JSourceCode(sourceCode);
    }

    public void setSourceCode(JSourceCode sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.declaringClass.getName());
        sb.append('(');
        if (!this.params.isEmpty()) {
            Enumeration<JParameter> paramEnum = Collections.enumeration(this.params.values());
            sb.append(paramEnum.nextElement().getType().getName());
            while (paramEnum.hasMoreElements()) {
                sb.append(", ");
                sb.append(paramEnum.nextElement().getType().getName());
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public JAnnotations getAnnotations() {
        return this.annotations;
    }

    public void appendAnnotation(String annotation) {
        if (this.annotations == null) {
            this.annotations = new JAnnotations();
        }
        this.annotations.appendAnnotation(annotation);
    }

    public void setAnnotations(JAnnotations annotations) {
        this.annotations = annotations;
    }
}

