/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;

public class JClass
extends JStructure {
    private List<JConstructor> _constructors = null;
    private Map<String, JField> _fields = null;
    private List<JClass> _innerClasses = null;
    private List<JMethod> _methods = null;
    private String _superClass = null;
    private JSourceCode _staticInitializer = new JSourceCode();
    private List<String> sourceCodeEntries = new ArrayList<String>();

    public JClass(String name) throws IllegalArgumentException {
        super(name);
        this._constructors = new ArrayList<JConstructor>();
        this._fields = new LinkedHashMap<String, JField>();
        this._methods = new ArrayList<JMethod>();
        this._innerClasses = new ArrayList<JClass>();
        this.getJDocComment().appendComment("Class " + this.getLocalName() + ".");
    }

    public void addConstructor(JConstructor constructor) throws IllegalArgumentException {
        if (constructor == null) {
            throw new IllegalArgumentException("Constructors cannot be null");
        }
        if (constructor.getDeclaringClass() == this) {
            if (!this._constructors.contains(constructor)) {
                this._constructors.add(constructor);
            }
        } else {
            String err = "The given JConstructor was not created ";
            err = err + "by this JClass";
            throw new IllegalArgumentException(err);
        }
    }

    @Override
    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("Class members cannot be null");
        }
        String name = jField.getName();
        if (this._fields.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        this._fields.put(name, jField);
    }

    @Override
    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember instanceof JField) {
            this.addField((JField)jMember);
        } else if (jMember instanceof JMethod) {
            this.addMethod((JMethod)jMember);
        } else {
            String error = null;
            error = jMember == null ? "the argument 'jMember' must not be null." : "Cannot add JMember '" + jMember.getClass().getName() + "' to JClass, unrecognized type.";
            throw new IllegalArgumentException(error);
        }
    }

    public void addMethod(JMethod jMethod) {
        this.addMethod(jMethod, true);
    }

    public void addMethod(JMethod jMethod, boolean importReturnType) throws IllegalArgumentException {
        if (jMethod == null) {
            throw new IllegalArgumentException("Class methods cannot be null");
        }
        boolean added = false;
        JModifiers modifiers = jMethod.getModifiers();
        if (modifiers.isAbstract()) {
            this.getModifiers().setAbstract(true);
        }
        for (int i = 0; i < this._methods.size(); ++i) {
            JMethod tmp = this._methods.get(i);
            if (tmp.getModifiers().isPrivate() && !modifiers.isPrivate()) {
                this._methods.add(i, jMethod);
                added = true;
                break;
            }
            if (jMethod.getName().compareTo(tmp.getName()) >= 0) continue;
            this._methods.add(i, jMethod);
            added = true;
            break;
        }
        if (!added) {
            this._methods.add(jMethod);
        }
    }

    public void addMethods(JMethod[] jMethods) throws IllegalArgumentException {
        for (JMethod jMethod : jMethods) {
            this.addMethod(jMethod);
        }
    }

    public JConstructor createConstructor() {
        return this.createConstructor(null);
    }

    public JConstructor createConstructor(JParameter[] params) {
        JConstructor cons = new JConstructor(this);
        if (params != null) {
            for (JParameter param : params) {
                cons.addParameter(param);
            }
        }
        this.addConstructor(cons);
        return cons;
    }

    public JClass createInnerClass(String localname) {
        if (localname == null) {
            String err = "argument 'localname' must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (localname.indexOf(46) >= 0) {
            String err = "The name of an inner-class must not contain a package name.";
            throw new IllegalArgumentException(err);
        }
        String classname = this.getPackageName();
        classname = classname != null ? classname + "." + localname : localname;
        JInnerClass innerClass = new JInnerClass(classname);
        this._innerClasses.add(innerClass);
        return innerClass;
    }

    public JConstructor getConstructor(int index) {
        return this._constructors.get(index);
    }

    public JConstructor[] getConstructors() {
        int size = this._constructors.size();
        JConstructor[] jcArray = new JConstructor[size];
        for (int i = 0; i < this._constructors.size(); ++i) {
            jcArray[i] = this._constructors.get(i);
        }
        return jcArray;
    }

    @Override
    public JField getField(String name) {
        return this._fields.get(name);
    }

    @Override
    public JField[] getFields() {
        return this._fields.values().toArray(new JField[0]);
    }

    public JClass[] getInnerClasses() {
        return this._innerClasses.toArray(new JClass[0]);
    }

    public JMethod[] getMethods() {
        int size = this._methods.size();
        JMethod[] marray = new JMethod[size];
        for (int i = 0; i < this._methods.size(); ++i) {
            marray[i] = this._methods.get(i);
        }
        return marray;
    }

    public JMethod getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this._methods.size(); ++i) {
            JMethod jMethod = this._methods.get(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethod getMethod(int index) {
        return this._methods.get(index);
    }

    public JSourceCode getStaticInitializationCode() {
        return this._staticInitializer;
    }

    public String getSuperClass() {
        return this._superClass;
    }

    @Override
    public void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        int i;
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuilder buffer = new StringBuilder();
        if (!classOnly) {
            this.printHeader(jsw);
            this.printPackageDeclaration(jsw);
            ArrayList<String> removeImports = null;
            if (this._innerClasses.size() > 0) {
                removeImports = new ArrayList<String>();
                for (JClass iClass : this._innerClasses) {
                    Enumeration<String> e = iClass.getImports();
                    while (e.hasMoreElements()) {
                        String classname = e.nextElement();
                        if (this.hasImport(classname)) continue;
                        this.addImport(classname);
                        removeImports.add(classname);
                    }
                }
            }
            this.printImportDeclarations(jsw);
            if (removeImports != null) {
                for (int i2 = 0; i2 < removeImports.size(); ++i2) {
                    this.removeImport((String)removeImports.get(i2));
                }
            }
        }
        this.getJDocComment().print(jsw);
        JAnnotations annotations = this.getAnnotations();
        if (annotations != null) {
            annotations.print(jsw);
        }
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        if (this instanceof JInnerClass && modifiers.isStatic()) {
            buffer.append("static ");
        }
        if (modifiers.isFinal()) {
            buffer.append("final ");
        }
        buffer.append("class ");
        buffer.append(this.getLocalName());
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.indent();
        if (this._superClass != null) {
            buffer.append("extends ");
            buffer.append(this._superClass);
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        if (this.getInterfaceCount() > 0) {
            buffer.append("implements ");
            Enumeration<String> e = this.getInterfaces();
            while (e.hasMoreElements()) {
                buffer.append(e.nextElement());
                if (!e.hasMoreElements()) continue;
                buffer.append(", ");
            }
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        jsw.unindent();
        jsw.writeln('{');
        jsw.indent();
        if (this._fields.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //--------------------------/");
            jsw.writeln(" //- Class/Member Variables -/");
            jsw.writeln("//--------------------------/");
            jsw.writeln();
        }
        for (JField jField : this._fields.values()) {
            JAnnotations fieldAnnotations;
            JDocComment comment = jField.getComment();
            if (comment != null) {
                comment.print(jsw);
            }
            if ((fieldAnnotations = jField.getAnnotations()) != null) {
                fieldAnnotations.print(jsw);
            }
            jsw.write(jField.getModifiers().toString());
            jsw.write(32);
            JType type = jField.getType();
            String typeName = type.toString();
            if (typeName.equals(this.toString())) {
                typeName = type.getLocalName();
            }
            jsw.write(typeName);
            jsw.write(32);
            jsw.write(jField.getName());
            String init = jField.getInitString();
            if (init != null) {
                jsw.write(" = ");
                jsw.write(init);
            }
            jsw.writeln(';');
            jsw.writeln();
        }
        if (!this._staticInitializer.isEmpty()) {
            jsw.writeln();
            jsw.writeln("static");
            jsw.writeln("{");
            this._staticInitializer.print(jsw);
            jsw.writeln("};");
            jsw.writeln();
        }
        if (this._constructors.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //----------------/");
            jsw.writeln(" //- Constructors -/");
            jsw.writeln("//----------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._constructors.size(); ++i) {
            JConstructor jConstructor = this._constructors.get(i);
            jConstructor.print(jsw);
            jsw.writeln();
        }
        if (this._methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (i = 0; i < this._methods.size(); ++i) {
            JMethod jMethod = this._methods.get(i);
            jMethod.print(jsw);
            jsw.writeln();
        }
        if (this._innerClasses.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------------/");
            jsw.writeln(" //- Inner Classes -/");
            jsw.writeln("//-----------------/");
            jsw.writeln();
        }
        for (i = 0; i < this._innerClasses.size(); ++i) {
            JClass jClass = this._innerClasses.get(i);
            jClass.print(jsw, true);
            jsw.writeln();
        }
        for (String sourceCodeEntry : this.sourceCodeEntries) {
            jsw.writeln(sourceCodeEntry);
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
    }

    public void addSourceCode(String sourceCode) {
        this.sourceCodeEntries.add(sourceCode);
    }

    public boolean removeConstructor(JConstructor constructor) {
        return this._constructors.remove(constructor);
    }

    public JField removeField(String name) {
        if (name == null) {
            return null;
        }
        JField field = this._fields.remove(name);
        return field;
    }

    public boolean removeField(JField jField) {
        if (jField == null) {
            return false;
        }
        JField field = this._fields.get(jField.getName());
        if (field == jField) {
            this._fields.remove(jField.getName());
            return true;
        }
        return false;
    }

    public boolean removeInnerClass(JClass jClass) {
        return this._innerClasses.remove(jClass);
    }

    public void setSuperClass(String superClass) {
        this._superClass = superClass;
    }

    final class JInnerClass
    extends JClass {
        JInnerClass(String name) {
            super(name);
        }

        @Override
        public void setPackageName(String packageName) {
            throw new IllegalStateException("Cannot change the package of an inner-class");
        }
    }
}

