/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.schema.JsonSchema;
import org.codehaus.jackson.schema.SchemaAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializer
extends JsonSerializer<Object>
implements ResolvableSerializer,
SchemaAware {
    protected final String _className;
    protected final BeanPropertyWriter[] _props;

    public BeanSerializer(Class<?> type, BeanPropertyWriter[] props) {
        if (props.length == 0) {
            throw new IllegalArgumentException("Can not create BeanSerializer for type that has no properties");
        }
        this._props = props;
        this._className = type.getName();
    }

    public BeanSerializer(Class<?> type, Collection<BeanPropertyWriter> props) {
        this(type, props.toArray(new BeanPropertyWriter[props.size()]));
    }

    @Override
    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        jgen.writeStartObject();
        try {
            int len = this._props.length;
            for (i = 0; i < len; ++i) {
                this._props[i].serializeAsField(bean, jgen, provider);
            }
            jgen.writeEndObject();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            Throwable t = e;
            while (t instanceof InvocationTargetException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw JsonMappingException.wrapWithPath(t, bean, this._props[i].getName());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        ObjectNode o = JsonNodeFactory.instance.objectNode();
        o.put("type", "object");
        o.put("optional", true);
        ObjectNode propertiesNode = o.objectNode();
        for (int i = 0; i < this._props.length; ++i) {
            BeanPropertyWriter prop = this._props[i];
            Type hint = prop.getSerializationType();
            if (hint == null) {
                hint = prop.getGenericPropertyType();
            }
            JsonSerializer<Object> ser = provider.findValueSerializer(prop.getSerializationType() == null ? prop.getReturnType() : prop.getSerializationType());
            JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, hint) : JsonSchema.getDefaultSchemaNode();
            o.put("items", schemaNode);
            propertiesNode.put(prop.getName(), schemaNode);
        }
        o.put("properties", propertiesNode);
        return o;
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        for (BeanPropertyWriter prop : this._props) {
            if (prop.hasSerializer()) continue;
            Class<?> type = prop.getSerializationType();
            if (type == null) {
                Class<?> rt = prop.getReturnType();
                if (!Modifier.isFinal(rt.getModifiers())) continue;
                type = rt;
            }
            this._props[i] = prop.withSerializer(provider.findValueSerializer(type));
        }
    }

    public String toString() {
        return "BeanSerializer for " + this._className;
    }
}

