/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.feature;

public class Version
implements Comparable {
    public int major;
    public int minor;
    public int revision;
    public String tag;

    public Version(int major, int minor, int revision, String tag) {
        if (major <= 0 || minor < 0 || revision < 0) {
            throw new IllegalArgumentException("Major must be > 0 and minor >= 0 and revision >= 0.");
        }
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.tag = tag;
    }

    public Version(int major, int minor, int revision) {
        this(major, minor, revision, null);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major) {
        this(major, 0);
    }

    public static Version parseFromString(String version) {
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("Version must not be null or empty.");
        }
        String[] split = version.split("[.-]", 4);
        try {
            int major = Integer.parseInt(split[0]);
            int minor = 0;
            int revision = 0;
            String tag = null;
            if (split.length >= 2) {
                minor = Integer.parseInt(split[1]);
            }
            if (split.length >= 3) {
                revision = Integer.parseInt(split[2]);
            }
            if (split.length >= 4) {
                tag = "";
                for (int i = 3; i < split.length; ++i) {
                    tag = tag + split[i];
                }
            }
            return new Version(major, minor, revision, tag);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Major, minor, and revision must be integers.");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version version = (Version)obj;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.revision != version.revision) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(version.tag) : version.tag != null);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision;
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.major);
        if (this.minor != -1) {
            buff.append(".").append(this.minor);
        }
        if (this.revision != -1) {
            buff.append(".").append(this.revision);
        }
        if (this.tag != null) {
            buff.append("-").append(this.tag);
        }
        return buff.toString();
    }

    public int compareTo(Version version) {
        int mine = 1000 * this.major + 100 * this.minor + this.revision * 10;
        int theirs = 1000 * version.major + 100 * version.minor + version.revision * 10;
        if (mine == theirs && this.tag != null && version.tag != null) {
            return version.tag.compareTo(this.tag);
        }
        if (mine == theirs && this.tag == null && version.tag != null) {
            return -1;
        }
        if (mine == theirs && this.tag != null && version.tag == null) {
            return 1;
        }
        return mine - theirs;
    }

    public int compareTo(Object o) {
        return this.compareTo((Version)o);
    }
}

